<?php
/*
 * 認証コンポーネント拡張
 */

/**
 * The parent component
 */
App::import('Component', 'Auth');

class AuthPlusComponent extends AuthComponent {

/**
 * The name of the model that represents users which will be authenticated.  Defaults to 'User'.
 *
 * @var string
 * @access public
 */
	var $userModel = 'User';

	function initialize(&$controller)
	{
		// ACL: controllerごとのactionMap設定マージ
		$this->actionMap = array_merge($this->actionMap, $controller->actionMapPlus);
		$admin = Configure::read('Routing.admin');
		if (!empty($admin)) {
			foreach ($controller->actionMapPlus as $k => $v) {
				$this->actionMap = array_merge(
					$this->actionMap, 
					array($admin . '_'. $k => $v)
				);
			}
		}

		parent::initialize($controller);

		// ログイン後リダイレクト設定
		$this->loginRedirect = $controller->params["url"]["url"];
		if ("/".$this->loginRedirect == Router::normalize(Configure::read('Routing.loginPath'))) {
			$this->loginRedirect = Router::normalize(Configure::read('Routing.basePath'));
			if (Configure::read('mobileUserAgent')) {
				$this->loginRedirect .= "m/";
			}
		}
	}

	function deleteAuth()
	{
		$this->__setDefaults();
		$this->Session->del($this->sessionKey);
		$this->_loggedIn = false;
		return Router::normalize($this->logoutRedirect);
	}

	function isAuthorized($type = null, $object = null, $user = null) {
		$valid = parent::isAuthorized($type, $object, $user);

		// view prefixごとのチェック
		if ($valid) {
			if (isset($this->params['prefix']) 
				&& $this->params['prefix'] == Configure::read('Routing.admin')) {
				$valid = $this->Acl->check(
					$this->user(),
					'admin',
					$this->actionMap[$this->params['action']]
				);
			}
		}

		return $valid;
	}


}


