CREATE TABLE notes (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  member_id INTEGER UNSIGNED NOT NULL,
  lat FLOAT NOT NULL,
  lon FLOAT NOT NULL,
  title TEXT NOT NULL,
  body TEXT NOT NULL,
  public_flag VARCHAR(32) NOT NULL DEFAULT 'private',
  created DATETIME NOT NULL,
  modified DATETIME NOT NULL,
  PRIMARY KEY(id),
  INDEX note_member_id(member_id),
  INDEX note_pulic_flag(public_flag, member_id, modified),
  INDEX note_modified(modified, member_id)
)
TYPE=InnoDB;
