<?php
/**
 * 独自App Contoroller
 */

App::import('Vendor', 'pear_ini');  
App::import('Vendor', 'Net_UserAgent_Mobile', array('file' => 'Net' . DS . 'UserAgent' . DS . 'Mobile.php'));

/**
 * PC/携帯共通
 */
// 携帯チェック
$this->agent = &Net_UserAgent_Mobile::factory();
if (!$this->agent->isNonMobile()) {
	Configure::write('mobile', 1);
}

class AppController extends Controller
{

	function beforeRender()
	{
		parent::beforeRender();

		// 認証済みユーザIDのセット
		$AuthUser = $this->MemberAuth->user();
		if (!$AuthUser) {
			$this->set('uid', 0);
		} else {
			$this->set('uid', $AuthUser[$this->MemberAuth->userModel]['id']);
		}
	}

}

// AppControllerを携帯とPCで振り分け
if (Configure::read('mobile')) {
        class ModuleController extends MobileAppController
        {
        }
} else {
        class ModuleController extends PcAppController
        {
        }
}

/**
 * 携帯用AppController
 */
class MobileAppController extends AppController
{
	function beforeFilter()
	{
		parent::beforeFilter();

		// PC用URLアクセスはエラー
		if (!isset($this->params["prefix"])) {
			// BaseURLのみ遷移
			if ($this->params["url"]["url"] == "/") {
				$this->redirect("/m/");
			}
			$this->cakeError("errorPcView");
			$this->_stop();
		}
		// 入力データの文字コード変換
		@array_walk_recursive($this->data, "convertEncodeSjis2Utf8");
        }

	function beforeRender()
	{
		parent::beforeRender();

		$this->layout = 'mobile_'.$this->layout;
	}

	function afterFilter()
	{
		parent::afterFilter();

	 	// 全角文字の変換
	 	$this->output = mb_convert_kana($this->output, "rak", Configure::read('App.encoding'));
	 	// 出力文字コードの変換
	 	$this->output = mb_convert_encoding($this->output, "SJIS", Configure::read('App.encoding'));
	}

}

/**
 * PC用AppController
 */
class PcAppController extends AppController 
{
        function beforeFilter()
        {
		parent::beforeFilter();

		// 携帯用アクションへのアクセスはPC用に変更
		if (isset($this->params["prefix"]) && $this->params["prefix"] == "mobile") {
			$pc_url = substr_replace($this->params["url"]["url"], "", 0, 2+strlen($this->params["controller"])+1);

			if (!$pc_url) {
				$pc_url = substr_replace($this->params['action'], "", 0, strlen($this->params["prefix"])+1);
			}

			$this->redirect($pc_url);
		}

		// refresh設定
		$this->set('refresh', array('time' => 0, 'url' => ''));
        }

	function beforeRender()
	{
		parent::beforeRender();

	}

}


/*
 * データ処理用
 */

/*
 * 文字コード変換 SJISWin->UTF-8
 */
function convertEncodeSjis2Utf8(&$str, n$key)
{
	$str = mb_convert_encoding($str, 'UTF-8', 'SJIS-Win');
}

