<?php
class MembersController extends ModuleController {

	var $name = 'Members';
	var $helpers = array('Html', 'Form');
	var $components = array('MemberAuth');

	function beforeFilter() {
		parent::beforeFilter();

		// 認証なしアクセス可
		$this->MemberAuth->allow('login');
		$this->MemberAuth->allow('logout');
		$this->MemberAuth->allow('mobile_login');
		$this->MemberAuth->allow('mobile_logout');
		// 仮
		$this->MemberAuth->allow('add');

	}

	// 携帯用
	function mobile_login() {
		
	}

	function mobile_logout() {
		$this->Session->setFlash(__('Logout.', true));
		$this->redirect($this->MemberAuth->logout());
	}

	function mobile_index() {
		$this->set('member', $this->Member->read(null, $this->MemberAuth->user("id")));
	}
	function mobile_view($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid Member.', true));
			$this->redirect(array('action'=>'listview'));
		}
		if ($id == $this->MemberAuth->user("id")) {
			$this->redirect(array('action'=>'index'));
		}
		$member = $this->Member->read(null, $id);
		if (!$member['Member']) {
			$this->Session->setFlash(__('Invalid Member.', true));
			$this->redirect(array('action'=>'listview'));
		}
		$this->set('member', $member);
	}

	function mobile_listview() {
		$this->Member->recursive = 0;
		$this->set('members', $this->paginate());
	}
	function mobile_add() {
		if (!empty($this->data)) {
			$this->Member->create();
			if ($this->Member->save($this->data)) {
				$this->Session->setFlash(__('The Member has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__('The Member could not be saved. Please, try again.', true));
			}
		}
	}
	function mobile_edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid Member', true));
			$this->redirect(array('action'=>'index'));
		}
		if (!empty($this->data)) {
			if ($this->Member->save($this->data)) {
				$this->Session->setFlash(__('The Member has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__('The Member could not be saved. Please, try again.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Member->read(null, $id);
		}
	}
	function mobile_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Member', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($id != $this->MemberAuth->user("id")) {
			$this->Session->setFlash(__('Permission denied.', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->Member->del($id)) {
			$this->Session->setFlash(__('Member deleted', true));
			$this->redirect(array('action'=>'logout'));
		}
	}

	// PC用
	function login() { }

	function logout() {
		$this->Session->setFlash(__('Logout.', true));
		$this->redirect($this->MemberAuth->logout());
	}

	function index() {
		$this->set('member', $this->Member->read(null, $this->MemberAuth->user("id")));
	}

	function view($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid Member.', true));
			$this->redirect(array('action'=>'listview'));
		}
		if ($id == $this->MemberAuth->user("id")) {
			$this->redirect(array('action'=>'index'));
		}
		$member = $this->Member->read(null, $id);
		if (!$member['Member']) {
			$this->Session->setFlash(__('Invalid Member.', true));
			$this->redirect(array('action'=>'listview'));
		}
		$this->set('member', $member);
	}

	function listview() {
		$this->Member->recursive = 0;
		$this->set('members', $this->paginate());
	}

	function add() {
		if (!empty($this->data)) {
			$this->Member->create();
			if ($this->Member->save($this->data)) {
				$this->Session->setFlash(__('The Member has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__('The Member could not be saved. Please, try again.', true));
			}
		}
	}
	function edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid Member', true));
			$this->redirect(array('action'=>'index'));
		}
		if (!empty($this->data)) {
			if ($this->Member->save($this->data)) {
				$this->Session->setFlash(__('The Member has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__('The Member could not be saved. Please, try again.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Member->read(null, $id);
		}
	}
	function delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Member', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($id != $this->MemberAuth->user("id")) {
			$this->Session->setFlash(__('Permission denied.', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->Member->del($id)) {
			$this->Session->setFlash(__('Member deleted', true));
			$this->redirect(array('action'=>'logout'));
		}
	}

	// 管理画面用
	function admin_index() {
		$this->Member->recursive = 0;
		$this->set('members', $this->paginate());
	}
	function admin_view($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid Member.', true));
			$this->redirect(array('action'=>'index'));
		}
		$this->set('member', $this->Member->read(null, $id));
	}
	function admin_add() {
		if (!empty($this->data)) {
			$this->Member->create();
			if ($this->Member->save($this->data)) {
				$this->Session->setFlash(__('The Member has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__('The Member could not be saved. Please, try again.', true));
			}
		}
	}
	function admin_edit($id = null) {
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid Member', true));
			$this->redirect(array('action'=>'index'));
		}
		if (!empty($this->data)) {
			if ($this->Member->save($this->data)) {
				$this->Session->setFlash(__('The Member has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__('The Member could not be saved. Please, try again.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Member->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Member', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->Member->del($id)) {
			$this->Session->setFlash(__('Member deleted', true));
			$this->redirect(array('action'=>'index'));
		}
	}

}
?>