<?php
class UsersController extends ModuleController {

	var $name = 'Users';
	var $helpers = array('Html', 'Form');
	var $components = array('MemberAuth');

	function beforeFilter() {
		parent::beforeFilter();

		// 認証なしアクセス可
		$this->MemberAuth->allow('admin_login');
		$this->MemberAuth->allow('admin_add');
		$this->MemberAuth->allow('admin_logout');
		$this->MemberAuth->allow('admin_to_login');

		// ログイン後遷移先
		$this->MemberAuth->loginRedirect = '/admin/users/index';
	}


	function admin_login() {
	}

	function admin_logout() {
		$this->Session->setFlash(__('Logout.', true));
		$this->redirect($this->MemberAuth->logout());
	}

	function admin_to_login($refresh = 5)
	{
		$this->set('refresh', array('time' => $refresh, 'url' => Router::url('index', false)));

	}

	function admin_index() {
		$this->User->recursive = 0;
		$this->set('users', $this->paginate());
	}

	function admin_add() {
		$this->set('idLength', Configure::read('User.UserId.Length'));
		$this->set('passwordLength', Configure::read('User.Password.Length'));

		if (!empty($this->data)) {
			// バリデーション
			$this->User->set($this->data);
			if ($this->User->validates()) {
				// passwordセット
				$this->data['User']['password'] = $this->MemberAuth->password($this->data['User']['password1']);

				// save
				$this->User->create();
				if ($this->User->save($this->data)) {
					$this->Session->setFlash(__('The User has been saved', true));
					$this->redirect(array('action'=>'index'));
				}
			}

		}
	}

	function admin_change_password($id = null) {
		$this->set('passwordLength', Configure::read('User.Password.Length'));

		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid User', true));
			$this->redirect(array('action'=>'index'));
		}
		if (!empty($this->data)) {
			// バリデーション
			$this->User->set($this->data);
			if ($this->User->validates()) {
				// passwordセット
				$this->data[$this->MemberAuth->userModel]['password'] = $this->MemberAuth->password($this->data[$this->MemberAuth->userModel]['password1']);

				if ($this->User->save($this->data)) {
					$this->Session->setFlash(__('The password has been changed. Please login at new password.', true));

					if ($data[$this->MemberAuth->userModel]['id'] == $AuthUser[$this->MemberAuth->userModel]['id']) {
						$this->MemberAuth->logout();
						$this->redirect('/admin/users/to_login');
					} else {
						$this->redirect('/admin/users/index');
					}

				} else {
					$this->Session->setFlash(__('The User could not be saved. Please, try again.', true));
				}
			}
		}
		if (empty($this->data)) {
			$this->data = $this->User->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for User', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->User->del($id)) {
			$this->Session->setFlash(__('User deleted', true));
			$this->redirect(array('action'=>'index'));
		}
	}

}
?>
