<?php
class AppModel extends Model {
	var $actsAs = array(
		'Cakeplus.ValidationErrorI18n',
	);

	function beforeValidate(){
		$error_messages = array(
			'notEmpty' 	=> __('Please be sure to input.', true),
			'between' => __('Between %2$d and %3$d characters.', true),
			'alphaNumeric' => __('Please input only alphameric characters.', true),
			'compare2fields' => __('Please input same as above.', true),
			'betweenWrapper' => __('Too short or Too long.', true),
		);
		$this->setErrorMessageI18n($error_messages, false);

		$this->replaceValidationErrorMessagesI18n();
		return true;
	}

	/* 本線alphaNumeric()の上書き */
	function alphaNumeric($data)
	{
		$check = is_array($data) ? array_shift($data) : $data;
		if (preg_match('/^[0-9a-z]+$/i',$check)) {
			return true;
		} else {
			return false;
		}
	}

	/* 本線Betweenへのwrapper */
	function betweenWrapper($check, $min, $max)
	{
		return Validation::between($check, $min, $max);
	}


}
