<?php
class User extends AppModel {

	var $name = 'User';
	var $actsAs = array(
		'Cakeplus.AddValidationRule',
	);

	var $validate = array(
		'username' => array(
			'betweenWrapper' => array(
				'rule' => array('betweenUsername'),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'password1' => array(
			'betweenWrapper' => array(
				'rule' => array('betweenPassword'),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'password2' => array(
			'compare2fields' => array(
				'rule' => array('compare2fields', 'password1', false),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		)
	);


	function betweenUsername($data)
	{
		$idLength = Configure::read('User.UserId.Length');
		return self::betweenWrapper($data, $idLength);
	}

	function betweenPassword($data)
	{
		$idLength = Configure::read('User.Password.Length');
		return self::betweenWrapper($data, $idLength);
	}

	function betweenWrapper($data, $idLength)
	{
		$check = array_values($data);

		return parent::betweenWrapper($check[0], $idLength['min'], $idLength['max']);
	}

}
?>