<?php
/*
 * Ajax Chat for TRPG ver.2.3
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// パスワードの照合
auth();

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

check_name($request['filename']);

// 過去ログ作成
write_log($request['datetime'], $request['whisper'], $request['filename']);

if ($request['delete']) {
    // ファイルロック
    $lfp = fopen(LOCK,"w");
    stream_set_write_buffer($lfp, 0);
    flock($lfp,LOCK_EX);

    // 直近の過去ログは表示を残す
    // 行番号を書き換えて保管
    $log = file(RECENT_LOG);
    $count_log = count($log);
    $fp = @fopen(RECENT_LOG, "w") or error("ログファイルを開けません。", true);
    if ($log[0]) {
        foreach ($log as $k => $v) {
            $num = $count_log - $k;
            fwrite($fp, preg_replace("/^([0-9]{1,})<>.*/U", "$num<>", $v, 1));
        }
    }
    fclose($fp);

    // 以前の過去ログは全消去
    $fp = fopen(PAST_LOG, "w");
    fclose($fp);

    fflush($lfp);
    fclose($lfp);
}

// 過去ログ作成完了
display_finish(CHAT_TITLE.' 過去ログ作成完了', '過去ログを作成しました');

exit;


/* 関数 */
// 過去ログ作成
function write_log($datetime, $whisper, $filename) {
    $log_master = read_log(PAST_LOG, MASTERPASS, true);
    if (!$log_master) return false;
    if (!$whisper) {
        $log = read_log(PAST_LOG, '', $datetime);
    } else {
        $log = read_log(PAST_LOG, MASTERPASS, $datetime);
    }
    if (!$log) return false;

    if (file_exists(PAST_DIR.$filename.".html") || file_exists(MASTER_PAST_DIR.$filename.".html")) {
        error("同名の過去ログファイルがあります。違う名前にして下さい。", true);
    }

    $header = html_header('過去ログ '.$filename, 'pastlog', false, false);
    $header2 = html_header('過去ログ [管理用]'.$filename, 'pastlog', false, false);
    $footer = html_footer();

    $fp = fopen(PAST_DIR.$filename.".html", "w");
    stream_set_write_buffer($fp, 0);
    flock($fp,LOCK_EX);
    fwrite($fp, $header);
    if ($log) {
        foreach ($log as $v) {
            fwrite($fp, $v."\n");
        }
    }
    fwrite($fp, '<hr>');
    fwrite($fp, $footer);
    fflush($fp);
    fclose($fp);

    $fp2 = fopen(MASTER_PAST_DIR.$filename.".html", "w");
    stream_set_write_buffer($fp2, 0);
    flock($fp2,LOCK_EX);
    fwrite($fp2, $header2);
    if ($log_master) {
        foreach ($log_master as $v) {
            fwrite($fp2, $v."\n");
        }
    }
    fwrite($fp2, '<hr>');
    fwrite($fp2, $footer);
    fflush($fp2);
    fclose($fp2);

}
?>