<?php
/*
 Ajax Chat for TRPG ver.2.6
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// パスワードの照合
if (MASTERPASS && $request['admin_pwd'] != MASTERPASS) {
    error('パスワードが違います。', false, true);
}

// 遷移先の確認
$whitelist = array(
    'admin.php',
);
if (!in_array($request['action'], $whitelist)) {
    error('リクエストが不正です');
}

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

// マスターパスを暗号化してセッションに入れる
@session_name('AjaxChatForTRPG');
@session_start();
@session_regenerate_id();

$_SESSION['admin_pwd'] = crypt($request['admin_pwd'], ADMIN_HASH_KEY);

// 遷移先へ
$self_url = get_self_url();
$url = str_replace('auth.php', '', $self_url).$request['action'];

header('Location: '. $url);
exit;
?>