<?php
/*
 Ajax Chat for TRPG ver.2.6.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  カード機能：デック交換
 *******************/

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/member_check.php';
require_once './lib/card.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// デック交換者チェック
$plname = htmlspecialchars($request['n']);
if (!$plname) {
    error('チャットに参加してください', true);
}
if (OBFUSCATION) {
    $plname = obf_xor($plname);
}
$now_member = get_member_log();
$member_flag = false;
foreach($now_member as $v) {
    if ($plname == $v[0]) {
        $member_flag = true;
        break;
    }
}
if (!$member_flag) {
    error('カード変更は参加者のみ可能です', true);
}

$write_msg = array();
// 新デック設定がある場合、設定を読み込みつつ内容チェック
if (!$request['newdeck']) {
    error('カードを指定して下さい', true);
} elseif ($request['newdeck'] != 'noCard') {
    $deck_ini = parse_ini_file(CARD_DIR.$request['newdeck'], true);

    if (!$deck_ini) {
        error($request['newdeck'].' カードの設定がありません', true);
    }

    // カード設定
    if (!$deck_ini['config']) {
        error($request['newdeck'].' 設定ファイルが不正です', true);
    }

    // 新しいデック作成
    $deck_config = set_array2json($deck_ini);

    // カード状態セット
    $GLOBALS['AJAX_CHAT_TRPG']['deck']['status'] = array();
    foreach($deck_ini as $k => $v) {
        if ($v && $k != 'config') {
            card_status("deckCardSet", $k);
        }
    }
    $write_msg[]['msg'] = '現在のカードを'.$deck_ini['config']['name'].'に変えました。';

// デック削除
} else {
    $deck_ini = array();
    $deck_ini[] = 'なし';
    $deck_config = set_array2json($deck_ini);
    $GLOBALS['AJAX_CHAT_TRPG']['deck']['status'] = array();
    $write_msg[]['msg'] = '現在のカードを片付けました。';
}

// ファイルロック
$lfp = fopen(LOCK3,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// 現在のデックを削除
if (file_exists(NOW_DECK)) {
    unlink(NOW_DECK);
    unlink(NOW_DECK_STATUS);
    // デックお片づけをチャットに書き込み
}
// デック書き込み
if ($deck_config) {
    $fp = @fopen(NOW_DECK, "w") or error("カードファイルを開けません。", true);
    if ($deck_config) {
        fwrite($fp, $deck_config);
    }
    fclose($fp);
}
if (file_exists(NOW_DECK)) {
    chmod(NOW_DECK, 0666);
}

// 現在のカード配置書き込み
$deck_status = $GLOBALS['AJAX_CHAT_TRPG']['deck']['status'];
$fp = @fopen(NOW_DECK_STATUS, "w") or error("カードファイルを開けません。", true);
fwrite($fp, set_array2json($deck_status));
fclose($fp);
if (file_exists(NOW_DECK_STATUS)) {
    chmod(NOW_DECK_STATUS, 0666);
}

// 新デック展開をチャットに書き込み
echo set_array2json($write_msg);

// ロック解除
fflush($lfp);
fclose($lfp);

exit;

?>