<?php
/*
 Ajax Chat for TRPG ver.2.6.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

// かんたんセットアップ対応
require_once './lib/trpgchat.php';
require_once './trpgchat-ini-2.php';
if (!file_exists('./trpgchat-ini.php')) {
    exit('NOT ABAILABLE');
}

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/mobile.php';

// 設定セット
set_config(read_config());

// 携帯使用設定
if (!USE_MOBILE) {
    mobile_error('携帯からはご利用できません。');
}

// 携帯以外のアクセス禁止
if (!is_mobile_access($ua)) {
    mobile_error('携帯以外からはご利用できません。');
}

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// リクエスト受信
$request = $_GET;
// 受信データの成形
if ($request) {
    foreach($request as $k => $v) {
        $data[$k] = htmlspecialchars($v);
    }
}
if ($request['r']) {
    $rows = $request['r'];
} else {
    $rows = MOBILE_COMMENTS_DEFAULT;
}

// HTML出力
mb_http_output("SJIS-win");
ob_start("mb_output_handler");
html_mobile_header(CHAT_TITLE);

if ($request['msg']) {
    print '<p>'.$request['msg'].'</p>'."\n";
}
?>

<form action="./mwrite.php">
<table width="100%">

<?php
if (!UNPUBLIC_LAST_PASTLOG || is_show_mobile_body($_GET['mode'])) {
    print '<tr>';
    print '<td><font size="'.MOBILE_FONT_SIZE.'">';
    print '<a href="./mindex.php?'.http_build_query($request).'">更新</a>';

    if ($GLOBALS['AJAX_CHAT_TRPG']['MOBILE_COMMENTS']) {
        print ' 表示数 ';
        $param['c'] = $request['c'];
        foreach ($GLOBALS['AJAX_CHAT_TRPG']['MOBILE_COMMENTS'] as $v) {
            if ($v == $rows) {
                print $v." ";
            } else {
                $param['r'] = $v;
                print '<a href="./mindex.php?'.http_build_query($param).'">'.$v.'</a> ';
            }
        }
    }

    print '</font></td>';
    print '</tr>';
}
?>
<tr>
<td>
<?php 
if ($request['c']) {
    print '<input type="hidden" name="n" value="">';
    print '<input type="hidden" name="c" value="'.$request['c'].'">';
} else {
    print '<font size="'.MOBILE_FONT_SIZE.'">お名前：</font><input type="text" name="n" size="8" istyle="1" mode="hiragana" value="">';
}
print '<input type="hidden" name="r" value="'.$rows.'">';
?>
</td>
</tr>
<td><input type="text" name="m" istyle="1" mode="hiragana" value=""></td>
</tr>
<td><font size="<?php print MOBILE_FONT_SIZE; ?>">
<input type="submit" value="発言" name="submit">
</font></td>
</tr>
</table>
</form>

<?php
// 本文表示モードのチェック
if (UNPUBLIC_LAST_PASTLOG) {
    if (is_show_mobile_body($_GET['mode'])) {
        // 本文出力
        print mobile_read_log($rows, SHOW_SYSTEM_LOG);
    } else {
        print nl2br(NO_LAST_PASTLOG_MSG);
    }
} else {
    // 本文出力
    print mobile_read_log($rows, SHOW_SYSTEM_LOG);
}

// ログアウト
if ($request['c']) {
    print '<hr><a href="./mwrite.php?n='.$request['c'].'&m=ﾛｸﾞｱｳﾄ&mode=logout">ﾛｸﾞｱｳﾄ</a><br>';
}
// フッター
html_mobile_footer(true);

exit;
 ?>