<?php
/*
 Ajax Chat for TRPG ver.2.6.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// パスワードの照合
auth();

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

check_name($request['dirname']);

if ($request['type'] != MASTER_PAST_DIR && $request['type'] != PAST_DIR) {
    error('リクエストが不正です。');
}

// ディレクトリ作成
if ($request['mode'] == '新規作成') {
    // ディレクトリ名チェック
    check_name($request['dirname']);

    if ($msg = mk_pastlog_dir($request['dirname'], $request['type'], '0707')) error($msg, true);

    display_finish(CHAT_TITLE.' 過去ログディレクトリ新規作成', $request['dirname']."を作成しました");

    exit;

// ディレクトリ編集
} elseif ($request['mode'] == '変更') {

    // ディレクトリ名チェック
    check_name($request['dirname_new']);

    // 変更
    if (file_exists($request['type'].$request['dirname_new'])) {
        error('同じ名前のディレクトリが存在します', true);
    }

    if (!rename($request['type'].$request['dirname'], $request['type'].$request['dirname_new'])) {
        error('ディレクトリ名の変更に失敗しました', true);
    }
    display_finish(CHAT_TITLE.' 過去ログディレクトリ名変更', $request['dirname']."を".$request['dirname_new']."に変更しました");
    exit;

// ディレクトリ削除
} elseif ($request['mode'] == '削除') {

    if (!file_exists($request['type'].$request['dirname'])) {
        error('指定のディレクトリが存在しません', true);
    }

    $list = get_dir_contents_list($request['type'].$request['dirname']."/", 'ASC');
    if (count($list['files']) > 0) {
        error('削除したいディレクトリの中のファイルを、全て移動または削除してください', true);
    }

    // 削除
    @unlink($request['type'].$request['dirname'].'/index.html');
    if(!rmdir($request['type'].$request['dirname'])) {
        error('ディレクトリ削除に失敗しました', true);
    }

    // 完了表示
    display_finish(CHAT_TITLE.' 過去ログディレクトリ削除完了', $request['dirname']."を削除しました");

} else {
    error('アクションが不正です');
}

?>