<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*,java.util.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	/*
	 * check session
	 */
    L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
	MessageView error = new MessageView(41319,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get result message
	 */
	MessageView message = (MessageView) session
			.getAttribute(SessionKeys.RESULT_MESSAGE);

	String errorMessage = "";
	int errorNumber = 0;
	String category = "";
	
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}

	/*
	 * get command message
	 */
	MessageView commandmessage = (MessageView) session
			.getAttribute(SessionKeys.COMMAND_MESSAGE);

	String commandMessage = "";
	int commandNumber = 0;
	String commandCategory = "";

	if (commandmessage != null) {
		commandMessage = commandmessage.getMessage();
		commandNumber = commandmessage.getErrno();
		commandCategory = commandmessage.getCategory();
		session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
	}

	/*
	 * get DirectorData
	 */
	L7guiFramework framework = new L7guiFramework();
	DirectorData dd = framework.getDirectorData();
	if (dd == null) {
		MessageView error = new MessageView(41320,
		LogCategorySet.GUI_IO_FILE, Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get cluster status
	 */
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41321,
		LogCategorySet.GUI_IO_COMMAND,
		Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if (cd.self_status == ClusterStatus.ACTIVE) {
		cssSeat = "l7gui_act_style.css";
	} else if (cd.self_status == ClusterStatus.STANDBY) {
		cssSeat = "l7gui_sby_style.css";
	}
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 		
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<script src="l7gui.js" type="text/javascript"></script>
	<noscript>
	<meta http-equiv="refresh"
		content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
	</noscript>
	<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
	<link rel="shortcut icon" href="images/favicon.ico" />

	<title>Monitor Current Status</title>
</head>

<body class="normal">
<jsp:include page="menu.jsp" flush="false" />

<div id="content">


<h1>Monitor Current Status</h1>

<%
if (message != null) {
%>

<p class="error">[<%=category%>-<%=errorNumber%>]</p>
<p class="error"><%=errorMessage%></p>

<%
} else if (commandmessage != null) {
%>
<p class="success">[<%=commandCategory%>-<%=commandNumber%>]</p>
<p class="success"><%=commandMessage%></p>
<%
}
%>

<fieldset><legend>Monitor Settings</legend>
<table class="infotable">
	<tr>
		<th class="left"><label for="checkTimeOut">CheckTimeOut</label></th>
		<td class="null">
		<%
			if ( (null != dd.checkTimeOut) && ("" != dd.checkTimeOut) )
				out.print(dd.checkTimeOut + " [sec]");
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="negotiateTimeOut">NegotiateTimeOut</label>
		</th>
		<td class="null">
		<%
			if ( (null != dd.negotiateTimeOut) && ("" != dd.negotiateTimeOut) )
				out.print(dd.negotiateTimeOut + " [sec]");
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="checkInterval">CheckInterval</label>
		</th>
		<td class="null">
		<%
			if ( (null != dd.checkInterval) && ("" != dd.checkInterval) )
				out.print(dd.checkInterval + " [sec]");
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="checkCount">CheckCount</label></th>
		<td class="null">
		<%
			if ( (null != dd.checkCount) && ("" != dd.checkCount) )
				out.print(dd.checkCount + " [time]");
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="callback">Callback</label></th>
		<td class="null">
		<%
			if (null != dd.callback)
				out.print(dd.callback);
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="fallback">Fallback</label></th>
		<td class="null">
		<%
			if (null != dd.fallback)
				out.print(dd.fallback);
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="logfile">Logfile</label></th>
		<td class="null">
		<%
			if (null != dd.logfile)
				out.print(dd.logfile);
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="execute">Execute</label></th>
		<td class="null">
		<%
			if (null != dd.execute)
				out.print(dd.execute);
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="supervised">Supervised</label></th>
		<td class="null">
		<%
			if (null != dd.supervised)
				out.print(dd.supervised);
		%>
		</td>
	</tr>

	<tr>
		<th class="left"><label for="quiescent">Quiescent</label></th>
		<td class="null">
		<%
			if (null != dd.quiescent)
				out.print(dd.quiescent);
		%>
		</td>
	</tr>

</table>
</fieldset>


<h2>Modify Monitor setting</h2>
<h4>Please push the following button, if you would like to modify the Monitor setting.</h4>
<form method="post" action="monitor_modify.jsp">
	<input type="submit" value="Modify">
</form>
</div>
</body>
</html>
