package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.FileNotWriteException;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.UserData;
import org.ultramonkey.l7.model.UserManager;

/**
 * 
 * <p>
 * class UserRemoveServlet
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author kubota
 */
public class UserRemoveServlet extends org.ultramonkey.l7.view.L7guiServletBase {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);
	
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public UserRemoveServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11443 class UserModServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11444 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11445 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11446 UserModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11447 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11448 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);

		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41194, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11449 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		UserData currentUser = (UserData) session
				.getAttribute(SessionKeys.LOGIN_SESSION);
		if (currentUser == null) {
			MessageView error = new MessageView(41195, LogCategorySet.GUI_USER_AUTHENTICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11450 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// get checkbox UserName Data & button Mode
        request.setCharacterEncoding("UTF-8");
		String selectCheck[] = request.getParameterValues("ck_user");
		String button_mode = request.getParameter("button");
		if (button_mode == null
				|| button_mode.equals(ButtonMode.DELETE) == false) {
			MessageView error = new MessageView(41196, LogCategorySet.GUI_USER_MANAGE, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11451 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		if (selectCheck == null) {
			MessageView error = new MessageView(21086, LogCategorySet.GUI_USER_MANAGE,
					Message.USER_REMOVE_SELECT_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.USER_MANAGE);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11452 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		UserManager user = UserManager.getInstance();
		boolean removeUser = true;
		boolean removeFlag = true;
		String successRemoveUser = "";
		String failRemoveUser = "";
		for (int i = 0; i < selectCheck.length; i++) {
			if (true == selectCheck[i].equals(currentUser.userName)) {
				MessageView error = new MessageView(21087, LogCategorySet.GUI_USER_MANAGE,
						Message.SELF_USER_DELETE);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.USER_MANAGE);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11453 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}
		}

		for (int i = 0; i < selectCheck.length; i++) {
			try {
				removeUser = user.delUser(selectCheck[i]);
			} catch (FileNotWriteException e) {
				MessageView error = new MessageView(41197, LogCategorySet.GUI_IO_FILE,
						Message.WRITE_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11454 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			} catch (Exception e) {
				MessageView error = new MessageView(41198, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.UNEXPECTED_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11455 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}

			if (true == removeUser) {
				successRemoveUser += selectCheck[i] + " ";
			} else {
				removeFlag = false;
				failRemoveUser += selectCheck[i] + " ";
			}
		}

		if (removeFlag == true) {
			MessageView message = new MessageView(21088, LogCategorySet.GUI_USER_MANAGE,
					"UserName : " + successRemoveUser + Message.USER_DELETE_SUCCESS);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, message);
			session.setAttribute(SessionKeys.GUI_SYNC_STATE, SessionKeys.NO_SYNC);
			response.sendRedirect(RedirectPages.USER_MANAGE);
		} else {
			if (successRemoveUser.length() != 0) {
				MessageView error = new MessageView(21089, LogCategorySet.GUI_USER_MANAGE,
						"UserName : " + successRemoveUser + Message.USER_DELETE_SUCCESS
						+ "<br />\n" + "UserName : " + failRemoveUser
						+ Message.USER_DELETE_FAIL);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			} else {
				MessageView message = new MessageView(41199, LogCategorySet.GUI_USER_MANAGE, 
						"UserName : " + failRemoveUser + Message.USER_DELETE_FAIL);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, message);
			}
			response.sendRedirect(RedirectPages.USER_DELETE_FAIL);
		}

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11456 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}
}
