package org.ultramonkey.l7.view;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.EndPoint;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;

/**
 * <p>
 * class ValidationCheck
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author kubota
 */
public class ValidationCheck {

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);
	
	public ValidationCheck() {
        // --- debug log (constructor) ---
        if (logger.isDebugEnabled()) {
            logger.debug("11336 class ValidationCheck created.");
        }
        // --- debug log (constructor) ---
	}
	
	/**
	 * 
	 * <p>
	 * validationCheck method
	 * </p>
	 * 
	 * @param inputVsMap
	 * @param invalidMap
	 * @param vs
	 */
	public boolean vsCheck(HashMap<String, String> inputVsMap,
			HashMap<String, String> invalidMap, VirtualSetting vs) {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("ValidationCheck::vsCheck(HashMap<String, String> inputVsMap, HashMap<String, String> invalidMap, VirtualSetting vs) in ");
            buf.append("inputVsMap=(" + inputVsMap + "), ");
            buf.append("invalidMap=(" + invalidMap + "), ");
            buf.append("vs=(" + vs + ")");
            logger.debug("11337 " + buf.toString());
		}
		// --- debug log (in method) ---

		boolean validationFlag = true;

		final int MIN_IP = 0;
		final int MAX_IP = 255;
		final int PARTITION = 4;
		final int MIN_PORT = 1;
		final int MAX_PORT = 65535;
		final int MAX_PORT_LENGTH = 10;
		final int MAX_OPTION_LENGTH = 127;
		final long MIN_QOS_SERVICE = 0L;
		final long MAX_QOS_SERVICE = 999L;
		final long MIN_QOS_CON = 0L;
		final long MAX_QOS_CON = 999L;
		final int MIN_CON = 0;
		final int MAX_CON = 100000;
		final int MIN_TIME_OUT = 1;
		final int MAX_TIME_OUT = Integer.MAX_VALUE;
		final int MAX_CHECK_TYPE_LENGTH = 10;
		final int DOWN_CALLBACK_LENGTH = 127;
		final int UP_CALLBACK_LENGTH = 127;
		final int MIN_CHECKPORT = 1;
		final int MAX_CHECKPORT = 65535;
		final int MAX_REQUEST_LENGTH = 127;
		final int MAX_RECEIVE_LENGTH = 127;
		final int MAX_VIRTUAL_HOST_LENGTH = 127;
		final int MAX_LOGIN_USER_LENGTH = 32;
		final int MAX_LOGIN_PASS_LENGTH = 32;
		final int MAX_DB_LENGTH = 32;
		final int MIN_WEIGHT = 0;
		final int MAX_WEIGHT = 100;

		// VirtualService IP validationCheck
		String vip = inputVsMap.get("vip");
		if (vip == null || vip.length() == 0) {
			invalidMap.put("vip", Message.REQUIED_ITEM);
			validationFlag = false;
		} else {
			if (vip.equals("0.0.0.0")) {
				invalidMap.put("vip", Message.INVALID_VALUE);
				validationFlag = false;
			} else {
				String tmp_vip[] = vip.split("\\.", PARTITION);
				int int_vip = 0;

				if (tmp_vip.length != PARTITION) {
					invalidMap.put("vip", Message.INVALID_VALUE);
					validationFlag = false;
				} else {
					for (int i = 0; i < PARTITION; i++) {
						try {
							int_vip = Integer.parseInt(tmp_vip[i]);
							if ((int_vip < MIN_IP) || (int_vip > MAX_IP)) {
								invalidMap.put("vip", Message.INVALID_VALUE);
								validationFlag = false;
								break;
							}
						} catch (NumberFormatException e) {
							invalidMap.put("vip", Message.INVALID_VALUE);
							validationFlag = false;
							break;
						}
					}
				}
			}
		}
		if (vip != null)
			vs.virtual.host = vip;

		// VirtualService Port validationCheck
		String port = inputVsMap.get("port");
		if (port == null || port.length() == 0) {
			invalidMap.put("port", Message.REQUIED_ITEM);
			validationFlag = false;
		} else {
			try {
				int int_port = Integer.parseInt(port);
				if ((int_port < MIN_PORT) || ((int_port > MAX_PORT))) {
					invalidMap.put("port", Message.INVALID_VALUE);
					validationFlag = false;
				}
			} catch (NumberFormatException e) {
				Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
				Matcher matcher = pattern.matcher(port);
				if ((port.length() > MAX_PORT_LENGTH) || matcher.find()) {
					invalidMap.put("port", Message.INVALID_VALUE);
					validationFlag = false;
				}
			}
			vs.virtual.port = port;
		}

		// Protomod validationCheck
		String protomod = inputVsMap.get("protomod");
		if (protomod != null && protomod.length() == 0) {
			invalidMap.put("protomod", Message.REQUIED_ITEM);
			validationFlag = false;
		} else if (protomod == null
				|| (!protomod.equals("cinsert") && !protomod.equals("url")
						&& !protomod.equals("sslid") && !protomod
						.equals("sessionless"))) {
			invalidMap.put("protomod", Message.INVALID_VALUE);
			validationFlag = false;
		}
		if (protomod != null)
			vs.protomod = protomod;

		// Persistence option validationCheck
		String option = inputVsMap.get("option");
		if (option != null && option.length() > 0) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(option);
			if ((option.length() > MAX_OPTION_LENGTH) || matcher.find()) {
				invalidMap.put("option", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (option != null)
			vs.option = option;
		if (vs.getKey() == null) {
			invalidMap.put("option", Message.INVALID_VALUE);
			validationFlag = false;
		}

		// Scheduler Type validationCheck
		String sched = inputVsMap.get("sched");
		if (sched != null && sched.length() == 0) {
			invalidMap.put("sched", Message.REQUIED_ITEM);
			validationFlag = false;
		} else if (sched == null
				|| (!sched.equals("rr") && !sched.equals("wrr") && !sched
						.equals("lc"))) {
			invalidMap.put("sched", Message.INVALID_VALUE);
			validationFlag = false;
		}
		if (sched != null)
			vs.sched = sched;

		// QoS (per Virtual Service) validationCheck
		String qos_service = inputVsMap.get("qos_service");
		String qos_service_unit = inputVsMap.get("qos_service_unit");
		if (qos_service != null && qos_service.length() > 0) {
			long long_qos_service = 0;
			try {
				long_qos_service = Long.parseLong(qos_service);
				if ((long_qos_service < MIN_QOS_SERVICE)
						|| (long_qos_service > MAX_QOS_SERVICE)) {
					invalidMap.put("qos_service", Message.INVALID_VALUE);
					validationFlag = false;
				} else {
					if (qos_service_unit != null && qos_service_unit.equals("bps")) {
					} else if (qos_service_unit != null && qos_service_unit.equals("Kbps")) {
						long_qos_service = long_qos_service * 1000;
					} else if (qos_service_unit != null && qos_service_unit.equals("Mbps")) {
						long_qos_service = long_qos_service * 1000000;
					} else if (qos_service_unit != null && qos_service_unit.equals("Gbps")) {
						long_qos_service = long_qos_service * 1000000000;
					} else {
						invalidMap.put("qos_service", Message.INVALID_VALUE);
						validationFlag = false;
					}
				}
			} catch (NumberFormatException e) {
				invalidMap.put("qos_service", Message.INVALID_VALUE);
				validationFlag = false;
			}
			vs.qosservice = long_qos_service;
		}

		// QoS (per Client) validationCheck
		String qos_conn = inputVsMap.get("qos_conn");
		String qos_conn_unit = inputVsMap.get("qos_conn_unit");
		if (qos_conn != null && qos_conn.length() > 0) {
			long long_qos_conn = 0;
			try {
				long_qos_conn = Long.parseLong(qos_conn);
				if ((long_qos_conn < MIN_QOS_CON)
						|| (long_qos_conn > MAX_QOS_CON)) {
					invalidMap.put("qos_conn", Message.INVALID_VALUE);
					validationFlag = false;
				} else {
					if (qos_conn_unit != null && qos_conn_unit.equals("bps")) {
					} else if (qos_conn_unit != null && qos_conn_unit.equals("Kbps")) {
						long_qos_conn = long_qos_conn * 1000;
					} else if (qos_conn_unit != null && qos_conn_unit.equals("Mbps")) {
						long_qos_conn = long_qos_conn * 1000000;
					} else if (qos_conn_unit != null && qos_conn_unit.equals("Gbps")) {
						long_qos_conn = long_qos_conn * 1000000000;
					} else {
						invalidMap.put("qos_conn", Message.INVALID_VALUE);
						validationFlag = false;
					}
				}
			} catch (NumberFormatException e) {
				invalidMap.put("qos_conn", Message.INVALID_VALUE);
				validationFlag = false;
			}
			vs.qosclient = long_qos_conn;
		}

		// Max Connections validationCheck
		String max_conn = inputVsMap.get("max_conn");
		if (max_conn != null && max_conn.length() > 0) {
			int int_max_conn = 0;
			try {
				int_max_conn = Integer.parseInt(max_conn);
				if ((int_max_conn < MIN_CON) || (int_max_conn > MAX_CON)) {
					invalidMap.put("max_conn", Message.INVALID_VALUE);
					validationFlag = false;
				}
			} catch (NumberFormatException e) {
				invalidMap.put("max_conn", Message.INVALID_VALUE);
				validationFlag = false;
			}
			vs.maxconn = int_max_conn;
		}

		// Timeout validationCheck
		String timeout = inputVsMap.get("timeout");
		if (timeout != null && timeout.length() > 0) {
			int int_timeout = 0;
			try {
				int_timeout = Integer.parseInt(timeout);
				if ((int_timeout < MIN_TIME_OUT)
						|| (int_timeout > MAX_TIME_OUT)) {
					invalidMap.put("timeout", Message.INVALID_VALUE);
					validationFlag = false;
				}
			} catch (NumberFormatException e) {
				invalidMap.put("timeout", Message.INVALID_VALUE);
				validationFlag = false;
			}
			vs.timeout = int_timeout;
		}

		// Check Type validationCheck
		String check_type = inputVsMap.get("check_type");
		if (check_type != null && (check_type.length() > 0)
				&& (check_type.length() < MAX_CHECK_TYPE_LENGTH)) {
			Pattern pattern = Pattern.compile("[0-9]");
			Matcher matcher = pattern.matcher(check_type);
			if (!matcher.matches() && !check_type.equals("negotiate")
					&& !check_type.equals("connect")
					&& !check_type.equals("ping") && !check_type.equals("off")
					&& !check_type.equals("on")) {
				invalidMap.put("check_type", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (check_type != null)
			vs.checktype = check_type;

		// Check Service validationCheck
		String check_service = inputVsMap.get("check_service");
		if (check_service != null && check_service.length() > 0) {
			if (!check_service.equals("ftp") && !check_service.equals("smtp")
					&& !check_service.equals("dns")
					&& !check_service.equals("http")
					&& !check_service.equals("pop")
					&& !check_service.equals("nntp")
					&& !check_service.equals("imap")
					&& !check_service.equals("ldap")
					&& !check_service.equals("https")
					&& !check_service.equals("mysql")
					&& !check_service.equals("pgsql")
					&& !check_service.equals("dns")
					&& !check_service.equals("sip")
					&& !check_service.equals("none")) {
				invalidMap.put("check_service", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (check_service != null)
			vs.service = check_service;

		// Quiescent validationCheck
		String quiescent = inputVsMap.get("quiescent");
		if (quiescent != null && quiescent.length() > 0) {
			if (!quiescent.equals("yes") && !quiescent.equals("no")) {
				invalidMap.put("quiescent", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (quiescent != null)
			vs.quiescent = quiescent;

		// Real Server Down Callback validationCheck
		String down_callback = inputVsMap.get("down_callback");
		if ( (down_callback != null) && down_callback.length() > 0){
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(down_callback);
			if ((down_callback.length() > DOWN_CALLBACK_LENGTH) || matcher.find()){
				invalidMap.put("down_callback", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (down_callback != null)
			vs.downcallback = down_callback;

		
		// Real Server Up Callback validationCheck
		String up_callback = inputVsMap.get("up_callback");
		if ( (up_callback != null) && (up_callback.length() > 0) ){
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(up_callback);
			if ( (up_callback.length() > UP_CALLBACK_LENGTH) || matcher.find() ) {	
				invalidMap.put("up_callback", Message.INVALID_VALUE);
				validationFlag = false;
			 }
		}
		if (up_callback != null)
			vs.upcallback = up_callback;

				
		// CheckPort validationCheck
		String check_port = inputVsMap.get("check_port");
		if (check_port != null && check_port.length() > 0) {
			int int_checkport = 0;
			try {
				int_checkport = Integer.parseInt(check_port);
				if ((int_checkport < MIN_CHECKPORT)
						|| (int_checkport > MAX_CHECKPORT)) {
					invalidMap.put("check_port", Message.INVALID_VALUE);
					validationFlag = false;
				}
			} catch (NumberFormatException e) {
				invalidMap.put("check_port", Message.INVALID_VALUE);
				validationFlag = false;
			}
			vs.checkport = int_checkport;
		}

		
		// Request Path validationCheck
		String request = inputVsMap.get("request");
		if (request != null && request.length() > 0) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(request);
			if ( (request.length() > MAX_REQUEST_LENGTH) || matcher.find() ) {
				invalidMap.put("request", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (request != null)
			vs.request = request;
				
		
		// Receive String validationCheck
		String receive = inputVsMap.get("receive");
		if (receive != null && receive.length() > 0) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(receive);
		if ( (receive.length() > MAX_RECEIVE_LENGTH) || matcher.find() ) {
			invalidMap.put("receive", Message.INVALID_VALUE);
			validationFlag = false;
			}
		}
		if (receive != null)
			vs.receive = receive;
		
		
		// HTTP Method validationCheck
		String method = inputVsMap.get("method");
		if (method != null && method.length() > 0) {
			if (!method.equals("GET") && !method.equals("HEAD")) {
				invalidMap.put("method", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (method != null)
			vs.httpmethod = method;

		// Virtual Host validationCheck
		String virtual_host = inputVsMap.get("virtual_host");
		if (virtual_host != null && virtual_host.length() > 0) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(virtual_host);
			if ( (virtual_host.length() > MAX_VIRTUAL_HOST_LENGTH) || matcher.find()) {
			invalidMap.put("virtual_host", Message.INVALID_VALUE);
			validationFlag = false;
			}
		}
		if (virtual_host != null)
			vs.virtualhost = virtual_host;

		
		// Login Username validationCheck
		String login_user = inputVsMap.get("login_user");
		if ( (login_user != null) && (login_user.length() > 0) ) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(login_user);
		
			if ( (login_user.length() > MAX_LOGIN_USER_LENGTH) || matcher.find() ) {
			invalidMap.put("login_user", Message.INVALID_VALUE);
			validationFlag = false;
			}
		}
		if (login_user != null)
			vs.login = login_user;
		
		
		// Login Password validationCheck
		String login_pass = inputVsMap.get("login_pass");
		if ( (login_pass != null) && (login_pass.length() > 0) ){
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(login_pass);
			if ( (login_pass.length() > MAX_LOGIN_PASS_LENGTH) || matcher.find() ) {
				invalidMap.put("login_pass", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (login_pass != null)
			vs.passwd = login_pass;
		
		
		// Database Name validationCheck
		String db = inputVsMap.get("db");
		if ( (db != null) && (db.length() > 0) ) {
			Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
			Matcher matcher = pattern.matcher(db);
			if ( (db.length() > MAX_DB_LENGTH) || matcher.find() ) {
				invalidMap.put("db", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		if (db != null)
			vs.database = db;

		
		// RealServer Info(IP,Port.Weight) validationCheck
		int num = 1;
		while (true) {
			// Serch EndPoint
			String rs_ip = inputVsMap.get("rs" + num + "_ip");
			if (rs_ip == null)
				break;

			String rs_port = inputVsMap.get("rs" + num + "_port");
			if (rs_port == null)
				break;

			String rs_weight = inputVsMap.get("rs" + num + "_weight");
			if (rs_weight == null)
				break;

			if (rs_ip.length() == 0 && rs_port.length() == 0
					&& rs_weight.length() == 0) {
				num++;
				continue;
			} else {
				// IP
				if (rs_ip.length() == 0) {
					invalidMap.put("rs" + num + "_ip", Message.REQUIED_ITEM);
					validationFlag = false;
				} else {
					if (rs_ip.equals("0.0.0.0")) {
						invalidMap.put("rs" + num + "_ip", Message.INVALID_VALUE);
						validationFlag = false;
					} else {
						String tmp_rs_addr[] = rs_ip.split("\\.", PARTITION);
						int int_rs_addr = 0;

						if (tmp_rs_addr.length != PARTITION) {
							invalidMap.put("rs" + num + "_ip",
									Message.INVALID_VALUE);
							validationFlag = false;
						} else {
							for (int i = 0; i < PARTITION; i++) {
								try {
									int_rs_addr = Integer
											.parseInt(tmp_rs_addr[i]);
									if ((int_rs_addr < MIN_IP)
											|| (int_rs_addr > MAX_IP)) {
										invalidMap.put("rs" + num + "_ip",
												Message.INVALID_VALUE);
										validationFlag = false;
										break;
									}
								} catch (NumberFormatException e) {
									invalidMap.put("rs" + num + "_ip",
											Message.INVALID_VALUE);
									validationFlag = false;
									break;
								}
							}
						}
					}
				}

				// Port
				if (rs_port.length() == 0) {
					invalidMap.put("rs" + num + "_port", Message.REQUIED_ITEM);
					validationFlag = false;
				} else {
					try {
						int int_rs_port = Integer.parseInt(rs_port);
						if ((int_rs_port < MIN_PORT)
								|| (int_rs_port > MAX_PORT)) {
							invalidMap.put("rs" + num + "_port",
									Message.INVALID_VALUE);
							validationFlag = false;
						}
					} catch (NumberFormatException e) {
						Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
						Matcher matcher = pattern.matcher(rs_port);
						if ((rs_port.length() > MAX_PORT_LENGTH) || matcher.find()) {
							invalidMap.put("rs" + num + "_port", Message.INVALID_VALUE);
							validationFlag = false;
						}
					}
				}

				// Weight
				int int_rs_weight = 1;
				if (rs_weight.length() == 0) {
					invalidMap
							.put("rs" + num + "_weight", Message.REQUIED_ITEM);
					validationFlag = false;
				} else {
					try {
						int_rs_weight = Integer.parseInt(rs_weight);
						if ((int_rs_weight < MIN_WEIGHT)
								|| (int_rs_weight > MAX_WEIGHT)) {
							invalidMap.put("rs" + num + "_weight",
									Message.INVALID_VALUE);
							validationFlag = false;
						}
					} catch (NumberFormatException e) {
						invalidMap.put("rs" + num + "_weight",
								Message.INVALID_VALUE);
						validationFlag = false;
					}
				}

				EndPoint rs = new EndPoint(rs_ip, rs_port, int_rs_weight,
						0, 0);
				vs.real.add(rs);
			}
			num++;
		}

		// SorryServer_IP validationCheck
		String sorry_ip = inputVsMap.get("sorry_ip");
		if (sorry_ip != null && sorry_ip.length() > 0) {
			if (sorry_ip.equals("0.0.0.0")) {
				invalidMap.put("sorry_ip", Message.INVALID_VALUE);
				validationFlag = false;
			} else {
				String tmp_sorry_ip[] = sorry_ip.split("\\.", PARTITION);
				int int_sorry_ip = 0;
				if (tmp_sorry_ip.length != PARTITION) {
					invalidMap.put("sorry_ip", Message.INVALID_VALUE);
					validationFlag = false;
				} else {
					for (int i = 0; i < PARTITION; i++) {
						try {
							int_sorry_ip = Integer.parseInt(tmp_sorry_ip[i]);
							if ((int_sorry_ip < MIN_IP)
									|| (int_sorry_ip > MAX_IP)) {
								invalidMap.put("sorry_ip",
										Message.INVALID_VALUE);
								validationFlag = false;
								break;
							}
						} catch (NumberFormatException e) {
							invalidMap.put("sorry_ip", Message.INVALID_VALUE);
							validationFlag = false;
							break;
						}
					}
				}
			}
			vs.sorryserver.host = sorry_ip;
		}

		// SorryServer Port validationCheck
		String sorry_port = inputVsMap.get("sorry_port");
		if (sorry_port != null && sorry_port.length() > 0) {
			try {
				int int_sorry_port = Integer.parseInt(sorry_port);
				if ((int_sorry_port < MIN_PORT) || (int_sorry_port > MAX_PORT)) {
					invalidMap.put("sorry_port", Message.INVALID_VALUE);
					validationFlag = false;
				}
			} catch (NumberFormatException e) {
				Pattern pattern = Pattern.compile("[^\\x20-\\x7e]");
				Matcher matcher = pattern.matcher(sorry_port);
				if ((sorry_port.length() > MAX_PORT_LENGTH) || matcher.find()) {
					invalidMap.put("sorry_port", Message.INVALID_VALUE);
					validationFlag = false;
				}
			}
			vs.sorryserver.port = sorry_port;
		}

		// SorryFlag validationCheck
		String sorry_flag = inputVsMap.get("sorry_flag");
		vs.sorryflag = false;
		if (sorry_flag != null && sorry_flag.length() > 0) {
			if (sorry_flag.equals("on")) {
				vs.sorryflag = true;
			} else if (sorry_flag.equals("off")) {
				vs.sorryflag = false;
			} else {
				invalidMap.put("sorry_flag", Message.INVALID_VALUE);
				validationFlag = false;
			}
		}
		
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("ValidationCheck::vsCheck(HashMap<String, String> inputVsMap, HashMap<String, String> invalidMap, VirtualSetting vs) out ");
            buf.append("return=" + validationFlag);
            logger.debug("11338 " + buf.toString());
		}
		// --- debug log (out method) ---
		return validationFlag;
	}
}
