package org.ultramonkey.l7.controller;

import java.io.Serializable;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * 
 * <p>class SnmpAgentData</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class SnmpAgentData implements Serializable {
    static final long serialVersionUID = 1;

    /**
     * SNMP Agent interval
     */
    public int interval;
    
    /**
     * SNMP Agent status
     */
	public SnmpAgentStatus status;
	
	/**
	 * 
	 * Constructor
	 *
	 */
	public SnmpAgentData() {
        // --- debug log (constructor) ---
	    Logger snmpLogger = Logger.getLogger(LogCategorySet.GUI_IO);
        if (snmpLogger.isDebugEnabled()) {
            snmpLogger.debug("11500 class SnmpAgentData created.");
        }
        // --- debug log (constructor) ---

		this.interval = -1;
		this.status = SnmpAgentStatus.NON_CONNECTING;
	}
	
	/**
	 * 
	 * <p> equals method</p>
	 *
	 * @param snmpData
	 * @return
	 */
	public boolean equals(SnmpAgentData snmpData) {
		// --- debug log (in method) ---
	    Logger snmpLogger = Logger.getLogger(LogCategorySet.GUI_IO);
		if (snmpLogger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("SnmpAgentData::equals(SnmpAgentData snmpData) in ");
			buf.append("snmpData=(" + snmpData + ")");
			snmpLogger.debug("11501 " + buf.toString());
		}
		// --- debug log (in method) ---
		
		if (snmpData != null && this.interval == snmpData.interval &&
			this.status == snmpData.status) {
			// --- debug log (out method) ---
			if (snmpLogger.isDebugEnabled()) {
	            snmpLogger.debug("11502 SnmpAgentData::equals(snmpData) out return=true");
			}
			// --- debug log (out method) ---
			return true;
		}
		
		// --- debug log (out method) ---
		if (snmpLogger.isDebugEnabled()) {
            snmpLogger.debug("11503 SnmpAgentData::equals(snmpData) out return=false");
		}
		// --- debug log (out method) ---
		return false;
	}
	 
}
