package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.SnmpAgentData;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.LogCategorySet;
import org.ultramonkey.l7.model.Message;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SessionTransData;

/**
 * <p>
 * class VSModServlet
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author kobayashi
 */
public class SnmpAgentServlet extends org.ultramonkey.l7.view.L7guiServletBase {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public SnmpAgentServlet() {
		super();
		// --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11261 class SnmpAgentServlet created.");
		}
		// --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("SnmpAgentServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11262 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			logger.debug("11263 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11264 SnmpAgentServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11265 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11266 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);

		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41059,
						LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11267 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		/*
		 * get SnmpAgentData
		 */
		request.setCharacterEncoding("UTF-8");
		String str_snmpInterval = request.getParameter("snmp_interval");
		if (str_snmpInterval == null) {
			MessageView error = new MessageView(41060, LogCategorySet.GUI_SNMP,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11268 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// unit_snmpInterval
		String unit_snmpInterval = request.getParameter("unit_interval");
		if (unit_snmpInterval == null) {
			MessageView error = new MessageView(41061, LogCategorySet.GUI_SNMP,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11269 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// SnmpAgetData
		L7guiFramework frameWork = new L7guiFramework();
		SnmpAgentData snmp = frameWork.getSnmpAgentData();
		if (snmp == null) {
			MessageView error = new MessageView(41062, LogCategorySet.GUI_SNMP,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11270 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		/*
		 * validationCheck
		 */
		boolean validationFlag = validationcheck(session, str_snmpInterval,
				snmp);
		if (validationFlag == false) {
			session.setAttribute(SessionKeys.INPUT_SNMP, snmp);
			session
					.setAttribute(SessionKeys.INPUT_SNMP_UNIT,
							unit_snmpInterval);
			MessageView error = new MessageView(21037, LogCategorySet.GUI_SNMP,
					Message.INVALID_VALUE);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.SNMP_MODIFY);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11271 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		/*
		 * set unit_snmpInterval
		 */
		if (unit_snmpInterval.equals("ms")) {
			//
		} else if (unit_snmpInterval.equals("s")) {
			snmp.interval *= 1000;
		} else {
			session.setAttribute(SessionKeys.INPUT_SNMP, snmp);
			session
					.setAttribute(SessionKeys.INPUT_SNMP_UNIT,
							unit_snmpInterval);
			MessageView error = new MessageView(21038, LogCategorySet.GUI_SNMP,
					Message.INVALID_VALUE);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.SNMP_MODIFY);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11272 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		CommandExecuter thread = new CommandExecuter(session);

		ExecuteMode mode;
		String redirectPage;

		String button_mode = request.getParameter("button");
		// button mode : null
		if (button_mode == null) {
			MessageView error = new MessageView(41063, LogCategorySet.GUI_SNMP,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11273 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		// button mode : save
		else if (button_mode.equals(ButtonMode.SAVE)) {
			mode = ExecuteMode.SNMP_INFO_SAVE;
			redirectPage = RedirectPages.SNMP_MODIFY_EXECUTIVE;
		}
		// button mode : save and sync
		else if (button_mode.equals(ButtonMode.SAVESYNC)) {
			mode = ExecuteMode.SNMP_INFO_SAVESYNC;
			redirectPage = RedirectPages.SAVE_SYNC_EXECUTIVE;

			SessionTransData trans = new SessionTransData();
			trans.sourceURI = RedirectPages.SNMP_MODIFY;
			trans.destURI = RedirectPages.SNMP_MODIFY;
			trans.errorURI = RedirectPages.SNMP_MODIFY_NG;
			session.setAttribute(SessionKeys.PAGE_TRANSDATA, trans);
		} else {
			MessageView error = new MessageView(41064, LogCategorySet.GUI_SNMP,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11274 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		try {
			thread.setExecute(mode, snmp);
			thread.start();
		} catch (Exception e) {
			MessageView error = new MessageView(41065, LogCategorySet.GUI_SNMP,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
				logger.debug("11275 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		response.sendRedirect(redirectPage);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11276 SnmpAgentServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}

	/**
	 * 
	 * <p>
	 * validationCheck method
	 * </p>
	 * 
	 * @param session
	 * @param str_snmpInterval
	 * @param snmp
	 * @return
	 */

	private boolean validationcheck(HttpSession session,
			String str_SnmpInterval, SnmpAgentData snmp) {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("SnmpAgentServlet::validationCheck(HttpSession session, String str_SnmpInterval, SnmpAgentData snmp) in ");
			buf.append("session=(" + session + "), ");
			buf.append("str_SnmpInterval=(" + str_SnmpInterval + "), ");
			buf.append("snmp=(" + snmp + ")");
			logger.debug("11277 " + buf.toString());
		}
		// --- debug log (in method) ---

		boolean validationFlag = true;

		int MIN_SNMP_INTERVAL = 1;
		int MAX_SNMP_INTERVAL = 999;
		int int_SnmpInterval = 1;

		if (str_SnmpInterval.length() == 0) {
			session.setAttribute(SessionKeys.INVALID_MESSAGE,
					Message.REQUIED_ITEM);
			validationFlag = false;
		} else {
			try {
				int_SnmpInterval = Integer.parseInt(str_SnmpInterval);
				if ((int_SnmpInterval < MIN_SNMP_INTERVAL)
						|| (int_SnmpInterval > MAX_SNMP_INTERVAL)) {
					session.setAttribute(SessionKeys.INVALID_MESSAGE,
							Message.VALIDATION_ERROR);
					validationFlag = false;
				}
			} catch (NumberFormatException e) {
				session.setAttribute(SessionKeys.INVALID_MESSAGE,
						Message.VALIDATION_ERROR);
				validationFlag = false;
			}
		}
		snmp.interval = int_SnmpInterval;

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11278 SnmpAgentServlet::validationCheck(HttpSession session, String str_SnmpInterval, SnmpAgentData snmp) out return=" + validationFlag);
		}
		// --- debug log (out method) ---
		return validationFlag;
	}
}