<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*, java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%

	/*
	 * check session
 	 */
	if (session.isNew()) {
	MessageView error = new MessageView(41333, LogCategorySet.GUI_USER_AUTHENTICATION,
			Message.INVALID_SESSSION);
	session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
	response.sendRedirect(RedirectPages.LOGIN);
	return;
	}

	/*
	 * get result message
	 */
	MessageView message = (MessageView) session.getAttribute(SessionKeys.RESULT_MESSAGE);
	String errorMessage = null;
	int errorNumber = 0;
	String category = "";
	if (message != null) {
		errorMessage = message.getMessage();
		errorNumber = message.getErrno();
		category = message.getCategory();
		session.setAttribute(SessionKeys.RESULT_MESSAGE, null);
	}

	
	/*
	 * get command message
	 */
	MessageView commandmessage = (MessageView) session.getAttribute(SessionKeys.COMMAND_MESSAGE);
	String commandMessage = null;
	int commandNumber = 0;
	String commandCategory = "";
	if (commandmessage != null) {
		commandMessage = commandmessage.getMessage();
		commandNumber = commandmessage.getErrno();
		commandCategory = commandmessage.getCategory();
		session.setAttribute(SessionKeys.COMMAND_MESSAGE, null);
	}

	// get replicationData
	L7guiFramework framework = new L7guiFramework();
	ReplicationData rep = framework.getReplicationData();
	ReplicationStatus repStatus = ReplicationStatus.OUT;
	if ( null == rep ){
		MessageView error = new MessageView(41334, LogCategorySet.GUI_IO,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	else {
		repStatus = rep.replicationMode;
	}
	String printRepStatus = null;
	String changeModeMessage = null;
	switch (repStatus){
		case MASTER:
			printRepStatus = "Master Running";
			changeModeMessage = "If you would like to stop sending Replication data, push the following button.";
			break;
		case SLAVE:
			printRepStatus = "Slave Running";
			changeModeMessage = "If you would like to stop receiving Replication data, push the following button.";
			break;
		case MASTER_STOP:
			printRepStatus = "Master Stopped";
			changeModeMessage = "If you would like to start sending Replication data, push the following button.";
			break;
		case SLAVE_STOP:
			printRepStatus = "Slave Stopped";
			changeModeMessage = "If you would like to start receiving Replication data, push the following button.";
			break;
		case SINGLE:
			printRepStatus = "Replication Invalid";
			break;
		case OUT:
			printRepStatus = "In Starting Replication";
			break;
		default :
			MessageView error = new MessageView(41335, LogCategorySet.GUI_REPLICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			return;
	}
	
	String selfNic = rep.nic;
	String peerIp = rep.otherNode.host;
	
	if ( (selfNic == null) || (peerIp == null) ){
		MessageView error = new MessageView(41336, LogCategorySet.GUI_IO_FILE,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
			
	HashMap<String, Integer> repDatainfo = rep.component;
	Set keys = null;
	if (repDatainfo != null){
		keys = repDatainfo.keySet();		
	}
	
	/*
	 * get cluster status
	 */
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41337, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * fix style seat
	 */
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

%>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 				
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
    	<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
  		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%= cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico"/>

		<title>Replication</title>

	</head>

	<body class="normal">
	<jsp:include page="menu.jsp" flush="false"/>

	<div id="content">


		<h1>Replication</h1>
		<%
			if ( (message != null) && (errorMessage != null) ) {
		%>
		
		<p class="error">[<%=category %> - <%=errorNumber %>]</p>
		<p class="error"><%=errorMessage %></p>
		
		<%
			}
			else if ( (commandmessage != null) && (commandMessage != null) ){
		%>
		<p class="success">[<%=commandCategory %> - <%=commandNumber %>]</p>
		<p class="success"><%=commandMessage %></p>
		<%		
			}
		%>

		<h2> Replication Current Status</h2>

		<form method="post" action="ReplicationModeChangeServlet" name="rep" >
		<fieldset>
		<legend>Replication Current Status</legend>
			<table  class="infotable" cellspacing="0">
			<thead>
				<tr>
					<th>Replication Mode</th>
					</tr>
			</thead>
			<tbody>
				<tr>
					<td class="center"><%=printRepStatus %></td>
				</tr>
			</tbody>
			</table>
		</fieldset>		
		<% if ( changeModeMessage != null){
		%>
		<h4><%=changeModeMessage %></h4>
		<br />
		<% 
		}
		switch (repStatus){
		case MASTER:
		%>
			<input type="submit" name="button" value="<%=ButtonMode.REP_MASTER_STOPPING %>" onClick="return confirm(replication_stop_send)" />
		<%
			break;
		case SLAVE:
		%>
			<input type="submit" name="button" value="<%=ButtonMode.REP_SLAVE_STOPPING %>" onClick="return confirm(replication_stop_receive)" />
		<%
			break;
		case MASTER_STOP:
		%>
			<input type="submit" name="button" value="<%=ButtonMode.REP_MASTER_RUNNING %>" onClick="return confirm(replication_start_send)" />			
		<%
			break;
		case SLAVE_STOP:
			%>
			<input type="submit" name="button" value="<%=ButtonMode.REP_SLAVE_RUNNING %>" onClick="return confirm(replication_start_receive)" />	
		<%
			break;
		}
		%>
		</form>

		
		<%
		if ( repStatus != ReplicationStatus.SINGLE ){
		%>
			<form method="post" action="replication_modify.jsp" name="rep_info">
			<h2> Replication Configuration Information</h2>
			<fieldset>
			<legend>Replication Configuration Information</legend>		
				<table class="infotable" cellspacing="0">
				<thead>
				<tr>
					<th>Self Node</th><th colspan="2">Peer Node</th><th rowspan="2">Interval</th>
				</tr>
				<tr>
					<th>NIC</th><th>IP Address</th><th>Port Number</th>
				</tr>
				</thead>
				<tbody>
				<tr>
					<td class="center"><%=selfNic %></td>
					<td class="center"><%=peerIp %></td>
					<td class="center"><%=rep.otherNode.port %></td>
					<td class="center"><%=rep.interval %> [&#181;sec]</td>
				</tr>
				</tbody>
				</table>
			</fieldset>
			<h4>If you would like to modify Interval, push the following button.</h4>
			<br />		
			<input type="submit" value="Modify" />
			</form>
	
			<% if (keys != null) {%>
			<h2> Replication Data Size Information</h2>
			<fieldset>
			<legend>Replication Data Size Information</legend>		
				<table class="infotable" cellspacing="0">
				<tr>
				<%
				for (Iterator iterator = keys.iterator(); iterator.hasNext();){
				%>	
					<th><%=iterator.next() %></th>
				<%
				}
				%>
				</tr>
				<tr>
				<%
				for (Iterator iterator = keys.iterator(); iterator.hasNext();){
					String key = (String)iterator.next();
					double size = ((Integer)repDatainfo.get(key)) * 480;
					String sizeUnit = "[byte]";
					if ( (size  >= 1000)  && ( size < 1000000 )){
 						size = size / 1000 ;
 						sizeUnit = "[Kbyte]";
 					}
 					else if( size >= 1000000 ){
 						size = size / 1000000 ;
 						sizeUnit = "[Mbyte]";
 					}
					out.println("<td class=\"center\">" + size + "" + sizeUnit + "</td>");
				}
				%>
				</tr>
				</table>
			</fieldset>
					
			<%
				if ( repStatus == ReplicationStatus.MASTER ){
			%>	
			<h2> Immediate Replication</h2>		
			<form method="post" action="ReplicationRunServlet" name="rep" >	
			<h4>If you would like to execute immediate Replication, push the following button.</h4>
			<br />
			<input type="submit" name="button_immediate" value="<%=ButtonMode.REP_EXECUTE%>" onClick="return confirm(replication_dump)" />	
			</form>
			<%
			}
		}
		}
		%>

	</div>
	</body>
</html>
