#ifndef _HONGKONGFC_HARD_H_
#define _HONGKONGFC_HARD_H_
/*
DATA PORT
BIT0-BIT7: DATA IN/OUT, ADDRESS, BUS CONTROL
STATUS PORT:
BIT7: DATA ϳǧ?
CONTROL PORT:
BIT~0: DATA PORT LATCH CLOCK
  H->L  LATCH
BIT~1 2 3: DATA PORT SELECT
BIT4: ߵ MUST BE 0
BIT5: PORT DIRECTION
  L PC->BUS
  H BUS->PC
*/
enum{
	BITNUM_CONTROL_DATA_LATCH = 0,
	BITNUM_CONTROL_DATA_SELECT,
	BITNUM_CONTROL_INTERRUPT = 4,
	BITNUM_CONTROL_DIRECTION
};
/*
DATA PORT SELECT
0: DATA BUS DIRECTION PC->BUS
1: DATA BUS DIRECTION BUS->PC
2: WRITE->READ ڤ괹 DATA_SELECT_A23toA16 »
3: WRITE->READ ڤ괹 DATA_SELECT_CONTROL »
4: LATCH cartridge control
5: LATCH A23-A16, fc Ǥ write data
6: LATCH A15-A8
7: LATCH A7-A0
*/
enum{
	DATA_SELECT_WRITE = 0,
	DATA_SELECT_READ,
	DATA_SELECT_BREAK_DATA,
	DATA_SELECT_BREAK_CONTROL,
	DATA_SELECT_A7toA0 = 4,
	DATA_SELECT_A15toA8,
	DATA_SELECT_A23toA16,
	DATA_SELECT_CONTROL,
	DATA_SELECT_WRITEDATA = DATA_SELECT_A23toA16
};
enum{
	BITNUM_PPU_OUTPUT = 0,
	BITNUM_PPU_SELECT,
	BITNUM_PPU_RW,
	//bit3̤
	BITNUM_WRITEDATA_OUTPUT = 4, //b0 L ǽ
	BITNUM_WRITEDATA_LATCH, //b1 L->H
	BITNUM_CPU_RW, //b2
	BITNUM_CPU_M2 //b3
};
#endif
