﻿' table/FieldProvider/NarrowChildFieldProvider.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class CNarrowTreeFieldProvider
    Inherits CNarrowChildFieldProvider

    Public Sub New()
        Me.New(Nothing)
    End Sub

    Public Sub New(ByVal caption As String)
        MyBase.New(caption)
    End Sub

    Public Overrides Sub SetBorder(ByVal field As UTable.CField, ByVal border As UTable.CBorder, ByVal merged As Boolean)
        Dim m As Integer = UTable.CBorder._L Or UTable.CBorder._R
        SetFieldBorder(field, border, merged, Me.BorderLine And m)
    End Sub

    Protected Overrides Sub renderForeGround(ByVal g As System.Drawing.Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        Dim lm As Integer = getLevelMax(field)
        Dim l As Integer = field.Content.Level
        Dim u As Integer = rect.Width / lm
        If l < lm - 1 Then
            RenderNarrowChild(g, Me.getToggleRect(field, rect, 0), _
                              field.Value, field.Record.Child IsNot Nothing AndAlso field.Record.Child.Records.Count > 0)
        End If
        For i As Integer = 0 To lm - 2
            If i < l - 1 Then
                If Not isLastRecord(field, i) Then
                    Dim x As Integer = rect.Left + u * (i + 1)
                    Using p As New Pen(Color.Gray)
                        p.DashStyle = Drawing2D.DashStyle.Dot
                        g.DrawLine(p, x, rect.Top, x, rect.Bottom)
                    End Using
                End If
            ElseIf i = l - 1 Then
                Dim x1 As Integer = rect.Left + u * (i + 1)
                Dim x2 As Integer = x1 + u - TOGGLERECT_SIZE / 2
                Dim y As Integer = rect.Top + rect.Height / 2
                Using p As New Pen(Color.Gray)
                    p.DashStyle = Drawing2D.DashStyle.Dot
                    g.DrawLine(p, x1, y, x2, y)
                    If Not isLastRecord(field, i) Then
                        g.DrawLine(p, x1, rect.Top, x1, rect.Bottom)
                    Else
                        g.DrawLine(p, x1, rect.Top, x1, y)
                    End If
                End Using
            ElseIf i = l Then
                Using p As New Pen(Color.Gray)
                    p.DashStyle = Drawing2D.DashStyle.Dot
                    With Nothing
                        Dim y As Integer = rect.Top + rect.Height / 2
                        Dim x1 As Integer = rect.Left + u * (i + 1) + TOGGLERECT_SIZE / 2
                        Dim x2 As Integer = rect.Right - 4
                        g.DrawLine(p, x1, y, x2, y)
                    End With
                    If field.Value Then
                        Dim x As Integer = rect.Left + u * (i + 1)
                        Dim y1 As Integer = rect.Top + rect.Height / 2 + TOGGLERECT_SIZE / 2
                        Dim y2 As Integer = rect.Bottom
                        g.DrawLine(p, x, y1, x, y2)
                    End If
                End Using
            End If
        Next
    End Sub

    Protected Overrides Function getToggleRect(ByVal field As UTable.CField, ByVal rect As System.Drawing.Rectangle, ByVal w As Integer) As System.Drawing.Rectangle
        Dim lm As Integer = getLevelMax(field)
        Dim l As Integer = field.Content.Level
        If lm > l Then
            Dim x As Integer = (rect.Width / lm) * (l + 1)
            Dim size As Integer = TOGGLERECT_SIZE + w
            Return New Rectangle(rect.Left + x - size / 2, rect.Top + rect.Height / 2 - size / 2, size, size)
        Else
            Return New Rectangle(0, 0, 0, 0)
        End If
    End Function

    Private Shared Function getLevelMax(ByVal field As UTable.CField) As Integer
        If field.TopLevelContent.RecordProvider Is Nothing Then
            Return 1
        End If
        Dim ret As Integer = 0
        Dim rp As UTable.CRecordProvider = field.TopLevelContent.RecordProvider
        Do While rp IsNot Nothing
            ret += 1
            rp = rp.ChildRecordProvider
        Loop
        Return ret
    End Function

    Private Shared Function isLastRecord(ByVal field As UTable.CField, ByVal l As Integer) As Boolean
        Dim r As UTable.CRecord = field.Record
        Dim _l As Integer = r.Content.Level
        Do While l + 1 < _l
            _l -= 1
            r = r.Content.ParentRecord
        Loop
        Return r.Index = r.Content.Records.Count - 1
    End Function

    Public Overrides Function GetAdjustSize(ByVal g As Graphics, ByVal field As UTable.CField) As Size
        Dim lm As Integer = getLevelMax(field)
        Return New Size(TOGGLERECT_SIZE * lm + 8, TOGGLERECT_SIZE + 8)
    End Function

End Class