/*
 * led_subsystem.c
 *
 *  Created on: 2011/11/06
 *      Author: takemasa
 */

#include "uzume.h"

/* KIRISHIMAでは、GPIO2のbit4-7がLEDに接続されている */


void status_led_on( int led )
{
	if ( 0 <= led && led < UZUME_NUM_LED)
	{
		/* KirishimaのLEDは負論理なので、点灯するにはLにする */
		/* LED制御ピンをLにする */
		GPIO_ClearValue(
			PINSEL_PORT_2,			// GPIOポート番号
			1 << (4+led) 				// 操作するビットマスク。LEDは0から始まる
			);
	}
}

void status_led_off( int led )
{
	if ( 0 <= led && led < UZUME_NUM_LED)
	{
		/* KirishimaのLEDは負論理なので、消灯するにはHにする */
		/* LED制御ピンをHにする */
		GPIO_SetValue(
			PINSEL_PORT_2,			// GPIOポート番号
			1 << (4+led) 				// 操作するビットマスク。LEDは0から始まる
			);
	}

}

void status_led_set( int led, int state )
{
	if ( 0 <= led && led < UZUME_NUM_LED)
	{
			/* State が真なら点灯*/
		if ( state )
			/* KirishimaのLEDは負論理なので、点灯するにはLにする */
			/* LED制御ピンをLにする */
			GPIO_ClearValue(
				PINSEL_PORT_2,			// GPIOポート番号
				1 << (4+led) 				// 操作するビットマスク。LEDは0から始まる
				);
		else
			/* KirishimaのLEDは負論理なので、消灯するにはHにする */
			/* LED制御ピンをHにする */
			GPIO_SetValue(
				PINSEL_PORT_2,			// GPIOポート番号
				1 << (4+led) 				// 操作するビットマスク。LEDは0から始まる
				);
	}
}

int status_led_get( int led )
{
	if ( 0 <= led && led < UZUME_NUM_LED)
	{
		return !( GPIO_ReadValue( PINSEL_PORT_2 ) & ( 1<< (led + 4)));
	}
	else
		return 0;

}

void status_led_init()
{
	PINSEL_CFG_Type pincfg;

		/* PORT2のLED出力ポートをGPIOにする */

	pincfg.Portnum = PINSEL_PORT_2; 	/* Status LEDは port2 */
	pincfg.Pinnum = PINSEL_PIN_4;	/* Status.0は pin 4 */
	pincfg.Pinmode = PINSEL_PINMODE_NORMAL;
	pincfg.OpenDrain = PINSEL_PINMODE_NORMAL;
	pincfg.Funcnum = 0;	/* set to GPIO assign */

	PINSEL_ConfigPin(&pincfg);

	pincfg.Pinnum = PINSEL_PIN_5;	/* Status.1は pin 5 */
	PINSEL_ConfigPin(&pincfg);

	pincfg.Pinnum = PINSEL_PIN_6;	/* Status.2は pin 6 */
	PINSEL_ConfigPin(&pincfg);

	pincfg.Pinnum = PINSEL_PIN_7;	/* Status.3は pin 7 */
	PINSEL_ConfigPin(&pincfg);

	/* LED制御ピンをHにする */
	GPIO_SetValue(
		PINSEL_PORT_2,			// GPIOポート番号
		0xF << 4 // 操作するビットマスク
		);

	/* GPIO0のLED制御ピンを出力にする */
	GPIO_SetDir(
		PINSEL_PORT_2,			// GPIOポート番号
		0xF << 4,	// 操作するビットマスク
		1			// 設定する値
		);



}
