/**
 * \file audio_processing.c
 * \brief コーデックから受け取ったデータに対して、実際の信号処理を施す
 * \date 2011/02/19
 * \author: Takemasa Nakamura
 */


/**
 * \mainpage FIR Demo
 *
 * このアプリケーションでは、uzumeフレームワークの基本的な使い方として CMSISライブラリの信号処理関数を使うデモンストレーションを行う。
 *
 * ユーザー・アルゴリズムは process_audio() 関数に実装しており、それ以外のコードは変更していない。
 * process_audio() 関数の中では、入力バッファの信号にFIRフィルタをかけて出力バッファへのコピーを行っている。
 *
 */

#include "arm_math.h"
#include "uzume.h"
	/** \brief 左チャンネルインデックス */
#define LCH 0
	/** \brief 右チャンネルインデックス */
#define RCH 1

void init_audio( void )
{
	/*
	 * 必要に応じてここに初期化プログラムを書いておく。
	 */
}
#define TAPS 25

void process_audio( const AUDIO_SAMPLE input[2][UZUME_BLOCK_SIZE], AUDIO_SAMPLE output[2][UZUME_BLOCK_SIZE] )
{
	static signed short state_l[TAPS+UZUME_BLOCK_SIZE-1];
	static signed short state_r[TAPS+UZUME_BLOCK_SIZE-1];
	static signed short coeff[TAPS];
	static arm_fir_instance_q15 sl = {TAPS, coeff, state_l};
	static arm_fir_instance_q15 sr = {TAPS, coeff, state_r};


	arm_fir_q15(&sl, input[LCH], output[LCH], UZUME_BLOCK_SIZE);
	arm_fir_q15(&sr, input[RCH], output[RCH], UZUME_BLOCK_SIZE);

	/*
		 * 入力データはinput[][]に格納されている。input[LCH][]が、左チャンネル、
		 * input[RCH][]が右チャンネルである。それぞれのチャンネルにはUZUME_BLOCK_SIZE個の
		 * データが格納されている。各データは2の補数符号付き左詰め形式の整数
		 * （つまり1.15形式固定小数点数）である。
		 *
		 * 出力データの形式も同じである。
		 */
}
