/**
 * \file led_subsystem.h
 *
 *  \date 2011/11/06
 *  \author takemasa
 *  \brief LED制御APIのインクルードファイル
 *  \details
 *  このファイルはuzume.hから読み込む。アプリケーションはこのファイルではなく
 *  uzume.hを読み込むこと。
 */

#ifndef LED_SUBSYSTEM_H_
#define LED_SUBSYSTEM_H_

#include <LPC17xx.h>
#include <lpc17xx_pinsel.h>
#include <lpc17xx_gpio.h>

/**
 * \brief ステータスLEDを点灯する
 * \param led 点灯するLED。0から始まる整数で指定する。
 * \ingroup uzume
 * \details
 * 引数ledで指定したLEDを点灯する。LEDの値は0から始まりUZUME_NUM_LEDより
 * 小さい。
 */
void status_led_on( int led );

/**
 * \brief ステータスLEDを消灯する
 * \param led 消灯するLED。0から始まる整数で指定する。
 * \ingroup uzume
 * \details
 * 引数ledで指定したLEDを消灯する。LEDの値は0から始まりUZUME_NUM_LEDより
 * 小さい。
 */
void status_led_off( int led );

/**
 * \brief ステータスLEDの状態を設定する
 * \param led 設定するLED。0から始まる整数で指定する。
 * \param state 0なら消灯。0以外なら点灯
 * \ingroup uzume
 * \details
 * 引数ledで指定したLEDを点灯あるいは消灯する。LEDの値は0から始まりUZUME_NUM_LEDより
 * 小さい。
 */

void status_led_set( int led, int state );

/**
 * \brief ステータスLEDの状態を取得する
 * \param led 取得するLED。0から始まる整数で指定する。
 * \returns 0なら消灯。非0なら点灯
 * \ingroup uzume
 * \details
 * 引数ledで指定したLEDの状態を取得する。LEDの値は0から始まりUZUME_NUM_LEDより
 * 小さい。
 */

int status_led_get( int led );

/**
 * \brief ステータスLEDサブシステムの初期化
 * \details
 * KirishimaボードのLEDが接続されているポートを出力に設定し、消灯する。
 */
 void status_led_init();


#endif /* LED_SUBSYSTEM_H_ */
