package jp.co.versus;

import java.util.Calendar;

import jp.co.versus.R;
import jp.co.versus.provider.VersusContract.Point;
import jp.co.versus.provider.VersusContract.Result;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.TextView;

public class PlayInfoEditorActivity extends Activity implements OnClickListener{
    final static public int REQUEST_TEAM = 123456;		//チームコール用
    final static public int REQUEST_RESULT = 987654;	//結果を入力判定コール
    final static public String DATE_KEY = "date";		//日付
    final static public String TEAM1_KEY = "team1";		//チーム1名
    final static public String TEAM2_KEY = "team2";		//チーム2名
    final static public String RESULT_ID_KEY = "result_id";
    final static public String MODE_KEY = "mode";
    final static public String MODE_NEW = "new";
    final static public String MODE_EDIT = "edit";

    private Button datebtn;
    private Button team1btn;
    private Button team2btn;
    private ContentResolver mContentResolver;
    private int mResultId = 0;

    @Override
    public void onCreate(Bundle savedInstanceState){
        super.onCreate(savedInstanceState);
        setContentView(R.layout.playinfoeditor_layout);

        headerInitialize();

        mContentResolver = getContentResolver();
        datebtn = setButton(R.id.date_btn);
        team1btn = setButton(R.id.team1_btn);
        team2btn = setButton(R.id.team2_btn);
        setButton(R.id.ok_btn);
        setButton(R.id.cancel_btn);
        Cursor cursor = mContentResolver.query(Result.CONTENT_URI, new String[]{
        		Result._ID}, null, null, null);
        if (cursor.moveToFirst()) {
        	do {
        		mResultId++;
        	} while (cursor.moveToNext());
        }

        mResultId++;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent){
        super.onActivityResult(requestCode, resultCode, intent);
        if(intent != null){
            Bundle bundle = intent.getExtras();
            switch(requestCode){
            case REQUEST_TEAM:
                String teamName = bundle.getString(TeamSelectActivity.KEY_STRINGDATA);
                if(bundle.getInt(TeamSelectActivity.KEY_NUMBER) == R.id.team1_btn){
                    team1btn.setText(teamName);
                }else if(bundle.getInt(TeamSelectActivity.KEY_NUMBER) == R.id.team2_btn){
                    team2btn.setText(teamName);
                }
                break;
            case REQUEST_RESULT:
                if(bundle.getString(PlayResultEditorActivity.KEY_STRINGDATA).equals(PlayResultEditorActivity.RESULT_TRUE)){
                	returnIntent(PlayResultEditorActivity.RESULT_TRUE);
                    finish();
                }
                break;
            }
        }
    }

    //返しintent生成
    public void returnIntent(String result){
        Intent intent = new Intent();	//渡すインテント
        Bundle bundle = new Bundle();	//データ格納先
        bundle.putString(PlayResultEditorActivity.KEY_STRINGDATA, result);
        intent.putExtras(bundle);	//インテントにデータ格納
        setResult(RESULT_OK, intent);	//インテント完了通知
    }

    //ボタン設定埋め込み
    public Button setButton(int id){
        Button button = (Button)findViewById(id);
        button.setOnClickListener(this);
        return button;
    }

    //datepickerdialog生成
    public void datePickerDialogCreate(){
        Calendar calendar = Calendar.getInstance();
        DatePickerDialog datePickerDialog = new DatePickerDialog(
                this,
                new DatePickerDialog.OnDateSetListener() {
                    @Override
                    public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth){
                        datebtn.setText(year + "/" + (monthOfYear + 1) + "/" + dayOfMonth);	//月が入力値と実値で1の差がなぜかあるので+1
                    }
                },
                calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH));
        datePickerDialog.show();
    }

    //ボタンクリックイベント
    @Override
    public void onClick(View v) {
        int id = v.getId();
        Intent intent;
        switch(id){
        case R.id.date_btn:		//日付ボタン
            datePickerDialogCreate();
            break;
        case R.id.team1_btn:	//チーム1設定
            intent = new Intent(this, TeamSelectActivity.class);
            intent.putExtra(TeamSelectActivity.KEY_NUMBER, R.id.team1_btn);
            intent.putExtra(TeamSelectActivity.KEY_EXCLUDE, team2btn.getText().toString());
            startActivityForResult(intent, REQUEST_TEAM);
            break;
        case R.id.team2_btn:	//チーム2設定
            intent = new Intent(this, TeamSelectActivity.class);
            intent.putExtra(TeamSelectActivity.KEY_NUMBER, R.id.team2_btn);
            intent.putExtra(TeamSelectActivity.KEY_EXCLUDE, team1btn.getText().toString());
            startActivityForResult(intent, REQUEST_TEAM);
            break;
        case R.id.ok_btn:		//OKボタン
        	String date = datebtn.getText().toString();
        	String team1 = team1btn.getText().toString();
        	String team2 = team2btn.getText().toString();
        	if (date.equals(getText(R.string.date_btn).toString())) {
        		showErrorDialog(getText(R.string.date_error).toString());
        		break;
        	}
        	if (team1.equals(getText(R.string.team1_btn).toString()) ||
        		team2.equals(getText(R.string.team2_btn).toString())) {
        		showErrorDialog(getText(R.string.team_error).toString());
        		break;
        	}
        	
            intent = new Intent(PlayInfoEditorActivity.this, PlayResultEditorActivity.class);
            intent.putExtra(DATE_KEY, date);
            intent.putExtra(TEAM1_KEY, team1);
            intent.putExtra(TEAM2_KEY, team2);
            intent.putExtra(RESULT_ID_KEY, mResultId);
            intent.putExtra(MODE_KEY, MODE_NEW);
            startActivityForResult(intent, REQUEST_RESULT);
            break;
        case R.id.cancel_btn:	//キャンセルボタン
            finish();
            break;
        }
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize() {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	headerText.setText(R.string.header_play_result_editor);
    }

    private void showErrorDialog(String message) {
    	new AlertDialog.Builder(this)
		.setIcon(android.R.drawable.ic_dialog_info)
		.setMessage(message)
		.setPositiveButton("OK", new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int whichButton) {
			}
		}).show();
    }
}
