package jp.co.versus;

import jp.co.versus.R;
import jp.co.versus.provider.VersusContract.Member;
import jp.co.versus.provider.VersusContract.Team;
import jp.co.versus.provider.VersusContract.TeamMember;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class TeamMemberSelectActivity extends Activity{
    final static public String KEY_NUMBER = "key.number";
    final static public String KEY_TEAM = "key.team";
    final static public String KEY_STRINGDATA = "key.Stringdata";
    final static public String KEY_ACTIVITY_ID = "key.activity";

    final static public int SCORE = 0; // 得点者
    final static public int ASSIST = 1; // アシスト

    private ContentResolver contentResolver;
    private SimpleCursorAdapter adapter;
    private int posi;		//取得データの書き込み先情報
    private String team;	//チーム情報
    private int mActivitiId = 0; //画面ID

    @Override
    public void onCreate(Bundle savedInstanceState){
        super.onCreate(savedInstanceState);
        setContentView(R.layout.teamselect_layout);

        Bundle bundle = getIntent().getExtras();
        if(bundle != null){
            posi = bundle.getInt(KEY_NUMBER);
            team = bundle.getString(KEY_TEAM);
            mActivitiId = bundle.getInt(KEY_ACTIVITY_ID);
        }

        headerInitialize(mActivitiId);
        contentResolver = getContentResolver();

        int teamid = 0;	//チームID

        Cursor cursor = contentResolver.query(Team.CONTENT_URI, new String[]{
                Team._ID}, Team.TEAM + "=?", new String[]{team}, null);
        if(cursor.moveToFirst()){	//チーム名に対するID取り出し
            teamid = cursor.getInt(0);
        } else {
        	setResult(RESULT_CANCELED);
        	finish();
        	return;
        }

        cursor = contentResolver.query(TeamMember.CONTENT_URI, new String[] {
                TeamMember.MEMBERID}, TeamMember.TEAMID + "=?", new String[]{String.valueOf(teamid)}, null);
        String members[] = new String[cursor.getCount()]; //メンバーIDs
        int columnNum = cursor.getColumnIndex(TeamMember.MEMBERID);
        
        if (cursor.moveToFirst()) {
        	int i = 0;
        	do {
                members[i] = cursor.getString(columnNum);
                i++;
        	} while(cursor.moveToNext());
        } else {
        	setResult(RESULT_CANCELED);
        	finish();
        	return;
        }

        cursor = contentResolver.query(Member.CONTENT_URI, new String[]{Member._ID, Member.NAME},
        		makeWhareArg(members), null, Member.NAME + " asc");

        startManagingCursor(cursor);
        adapter = new SimpleCursorAdapter(this,
                android.R.layout.simple_list_item_1, cursor, new String[] {
                Member._ID, Member.NAME }, new int[] {
                android.R.id.text2, android.R.id.text1 });

        ListView listView = (ListView)findViewById(R.id.listview);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position,
                    long id) {
                TextView textView = (TextView) view.findViewById(android.R.id.text1);
                String name = textView.getText().toString();
                returnIntent(name);
                finish();
            }
        });
    }

    public void returnIntent(String name){
        Intent intent = new Intent();	//渡すインテント
        Bundle bundle = new Bundle();	//データ格納先
        bundle.putInt(KEY_NUMBER, posi);
        bundle.putString(KEY_STRINGDATA, name);
        intent.putExtras(bundle);	//インテントにデータ格納
        setResult(RESULT_OK, intent);	//インテント完了通知
    }
    
    private String makeWhareArg(String[] members) {
    	String whareArgs = null;
    	StringBuilder stringBuilder = new StringBuilder();
    	for(int i = 0; i < members.length ; i++) {
    		if (i == members.length - 1) {
        		stringBuilder.append(Member._ID + "=" + members[i]);    			
    		} else {
        		stringBuilder.append(Member._ID + "=" + members[i] + " or ");    			
    		}
    	}
    	whareArgs = stringBuilder.toString();
    	return whareArgs;
    }

    /**
     * ヘッダの初期化処理を行います。
     */
    private void headerInitialize(int activityId) {
    	TextView headerText = (TextView)findViewById(R.id.header_title);
    	if (activityId == ASSIST) {
    		headerText.setText(R.string.header_assist_select);
    	} else {
    		headerText.setText(R.string.header_score_select);
    	}
    }
}
