#import "Preferences.h"
#import "HotkeyCtrl.h"
#import "VH7PC.h"
#import "DirectController.h"
#import "ControllerController.h"
#import "MainController.h"
#import "Recoder.h"
#import "ReservationController.h"


@implementation Preferences

-(id)init{
    [super init];
    
    return self;
}

-(void)applicationDidFinishLaunching:(NSNotification *)aNotification{
    NSUserDefaults *defaults=[ NSUserDefaults standardUserDefaults ];
    id tmp;
    
    [_hotkeyCtrl regWithDictionary:[defaults objectForKey:@"Hotkeys"]];
    [_tunerHotkey regWithDictionary:[defaults objectForKey:@"TunerHotkeys"]];
    [_cdHotkey regWithDictionary:[defaults objectForKey:@"CDHotkeys"]];
    [_directCtrl setPrefsWithDictionary:[defaults objectForKey:@"DorectControllerPreferences"]];
    if(tmp=[defaults objectForKey:@"PanelPreferences"]) [self setPrefsWithDictionary:tmp];
    else [self setPrefsWithDictionary:[NSDictionary dictionaryWithObjectsAndKeys:
            [NSNumber numberWithBool:NO],@"AutoPower",
            [NSNumber numberWithBool:NO],@"RememberVolume",
            nil]
        ];
    [_controllerController setSkinFromPref:
        [[defaults objectForKey:@"ControllerControllerPreferences"]
            objectForKey:@"SkinPath"]
        ];
    if(tmp=[defaults objectForKey:@"ControllerControllerPreferences"]) [self setControllerPrefsWithDictionary:tmp];
    else [self setPrefsWithDictionary:[NSDictionary dictionaryWithObjectsAndKeys:
            [NSNumber numberWithBool:NO],@"ShowAtLaunch",
            [NSNumber numberWithBool:NO],@"TopLevel",
            nil]
        ];
    if(tmp=[defaults objectForKey:@"StatusItemVisible"]){
        if(![tmp boolValue]) [_mainCtrl menuItemTrigger];
    }
    
	//recoder
    if(tmp=[defaults objectForKey:@"RecordingDirectory"]){
        [_recoder setRecordDir:tmp];
    } else {
		[_recoder setRecordDir:[NSHomeDirectory() stringByAppendingPathComponent:@"Desktop"]];
	}
    if(tmp=[defaults objectForKey:@"PlayWhileRecording"]){
        [_recoder setPlayWhileRecording:[tmp boolValue]];
    } else {
		[_recoder setPlayWhileRecording:YES];
	}

    if(tmp=[defaults objectForKey:@"Reservation"]){
        [reservation_ setArray:tmp];
	}

    if(tmp=[defaults objectForKey:@"RecorderChannelSettings"]){
        [_recoder settingWithDictionary:tmp];
	}

    if([self controllerShowaAtLaunch]) [_directCtrl triggerController:nil];
    //if(![self sbItemShowAtLaunch]) [_mainCtrl menuItemTrigger];
}

-(void)applicationWillTerminate:(NSNotification *)aNotification{
    NSUserDefaults *defaults=[ NSUserDefaults standardUserDefaults ];
    
    if([_vh7pc connected]&&[self autoPower]){
        if([_vh7pc getStatus]==0)
            if([_vh7pc statusRef]->powerOn) [_directCtrl power:nil];
    }

    //[defaults setObject:[NSNumber numberWithBool:[_mainCtrl sbItemShowing]] forKey:@"StatusItemVisible"];

    [defaults setObject:[_hotkeyCtrl hotkeyDictionary] forKey:@"Hotkeys"];
    [defaults setObject:[_tunerHotkey hotkeyDictionary] forKey:@"TunerHotkeys"];
    [defaults setObject:[_cdHotkey hotkeyDictionary] forKey:@"CDHotkeys"];
    [defaults setObject:_prefs forKey:@"PanelPreferences"];
    [defaults setObject:[_directCtrl prefs] forKey:@"DorectControllerPreferences"];
    id tmp=_controllerPrefs;
    if([_controllerController skinPath]){
        tmp=[[[NSMutableDictionary alloc] initWithDictionary:_controllerPrefs] autorelease];
        [tmp setObject:[_controllerController skinPath] forKey:@"SkinPath"];
    }
    [defaults setObject:tmp forKey:@"ControllerControllerPreferences"];

	if (tmp = [_recoder recordDir])
		[defaults setObject:tmp forKey:@"RecordingDirectory"];
	[defaults setObject:[NSNumber numberWithBool:[_recoder playWhileRecording]] forKey:@"PlayWhileRecording"];
    
	if (tmp = [reservation_ array])
		[defaults setObject:tmp forKey:@"Reservation"];
	
	if (tmp = [_recoder settingDictionary])
		[defaults setObject:tmp forKey:@"RecorderChannelSettings"];

    [defaults synchronize];
}

-(void)setPrefsWithDictionary:(NSDictionary *)d{
    [_prefs release];
    _prefs=[d retain];

    [_autoPowerCheck setState:[[_prefs objectForKey:@"AutoPower"] boolValue]?NSOnState:NSOffState];
    [_rememberVolumeCheck setState:[[_prefs objectForKey:@"RememberVolume"] boolValue]?NSOnState:NSOffState];
    //[_sbItemShowAtLaunchCheck 
    //    setState:[[_prefs objectForKey:@"StatusBarItemShowAtLaunch"] boolValue]?NSOnState:NSOffState];
}

-(void)setControllerPrefsWithDictionary:(NSDictionary *)d{
    [_controllerPrefs release];
    _controllerPrefs=[d retain];

    [_controllerTopLevelCheck setState:[[d objectForKey:@"TopLevel"] boolValue]?NSOnState:NSOffState];
    [_controllerShowaAtLaunchCheck setState:[[d objectForKey:@"ShowAtLaunch"] boolValue]?NSOnState:NSOffState];
	[_controllerAlphaSlider setDoubleValue:[[d objectForKey:@"ControllerAlphaValue"] doubleValue]];
    
    [_controllerWindow setLevel:([self controllerTopLevel]?NSStatusWindowLevel:NSNormalWindowLevel)];
	[_controllerWindow setAlphaValue:[self controllerAlphaValue]];
}

-(BOOL)autoPower{
    return [[_prefs objectForKey:@"AutoPower"] boolValue];
}

-(BOOL)rememberVolume{
    return [[_prefs objectForKey:@"RememberVolume"] boolValue];
}
/*
-(BOOL)sbItemShowAtLaunch{
    return [[_prefs objectForKey:@"StatusBarItemShowAtLaunch"] boolValue];
}
*/
-(BOOL)controllerTopLevel{
    return [[_controllerPrefs objectForKey:@"TopLevel"] boolValue];
}

-(BOOL)controllerShowaAtLaunch{
    return [[_controllerPrefs objectForKey:@"ShowAtLaunch"] boolValue];
}

-(double)controllerAlphaValue{
    return [[_controllerPrefs objectForKey:@"ControllerAlphaValue"] doubleValue];
}


-(IBAction)prefOKButton:(id)sender{
    [self setPrefsWithDictionary:[NSDictionary dictionaryWithObjectsAndKeys:
        [NSNumber numberWithBool:[_autoPowerCheck state]==NSOnState],@"AutoPower",
        [NSNumber numberWithBool:[_rememberVolumeCheck state]==NSOnState],@"RememberVolume",
        //[NSNumber numberWithBool:[_sbItemShowAtLaunchCheck state]==NSOnState],@"StatusBarItemShowAtLaunch",
        nil]
    ];
    [self setControllerPrefsWithDictionary:[NSDictionary dictionaryWithObjectsAndKeys:
        [NSNumber numberWithBool:[_controllerTopLevelCheck state]==NSOnState],@"TopLevel",
        [NSNumber numberWithBool:[_controllerShowaAtLaunchCheck state]==NSOnState],@"ShowAtLaunch",
        [NSNumber numberWithDouble:[_controllerAlphaSlider doubleValue]],@"ControllerAlphaValue",
        nil]
    ];
	
	[_recoder setPlayWhileRecording:[playWhileRecCheck_ state] == NSOnState];
    [_prefPanel orderOut:self];
}

-(void)dealloc{
    [_prefs release];
    [_controllerPrefs release];

    [super dealloc];
}

-(id)_vh7pc{
    return _vh7pc;
}

- (IBAction) changeRecordDest:(id) sender {
    NSOpenPanel *opFile=[NSOpenPanel openPanel];
    int tmp;

	[opFile setCanChooseFiles:NO];
	[opFile setCanChooseDirectories:YES];
    tmp=[opFile runModalForTypes:[NSArray arrayWithObject:@""]];
    if(tmp==NSOKButton){
		//[recordDestField_ setStringValue:recordDir_];
    }
}

@end
