//
//  CycleCommand.m
//  VH7PC_Controller
//
//  Created by nya on Sat Aug 02 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "CycleCommand.h"


@implementation CycleCommand

+(id)cycleWithOutlet:(id)d{
    return [[[CycleCommand alloc] initWithOutlet:d] autorelease];
}

-(id)initWithOutlet:(id)direct{
    [super init];
    
    _hotkeyCtrl=direct;
    _iterator=0;
    _num=0;
    _reg=[[NSMutableArray alloc] initWithCapacity:2]; 
    
    return self;
}

-(void)addWithNum:(int)n selector:(SEL)s{
    _selector[_num++]=s;
    [_reg addObject:[NSNumber numberWithInt:n]];
}

-(void)removeWithNum:(int)n selector:(SEL)s{
    int i;
    
    for(i=0;i<_num;i++){
        if(_selector[i]==s){
            int j;
            for(j=i;j+1<_num;j++) _selector[j]=_selector[j+1];
            _num--;
        }
    }
    [_reg removeObject:[NSNumber numberWithInt:n]];
}

-(void)cycleSelector{
    [_hotkeyCtrl performSelector:_selector[_iterator++]];
    if(_iterator>=_num) _iterator=0;
}

-(BOOL)contain:(int)n{
    NSEnumerator *enu=[_reg objectEnumerator];
    id obj;
    
    while(obj=[enu nextObject]) if([obj intValue]==n) return YES;
    return NO;
}

-(void)dealloc{
    [_reg release];
    [super dealloc];
}

@end
