//
//  DirectController.m
//  VH7PC_Controller
//
//  Created by NYA on Wed Jul 09 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "DirectController.h"
#import "VH7PC.h"
#import "MainController.h"
#import "Preferences.h"
#import "ControllerController.h"


@implementation DirectController

-(id)init{
    int i;
    [super init];
    
    _controllerShowed=NO;
    for(i=0;i<6;i++) _inputVolume[i]=-1;
    
    return self;
}

-(BOOL)controllerShowed{
    return _controllerShowed;
}

-(NSDictionary *)prefs{
    return [NSDictionary dictionaryWithObjectsAndKeys:
            [NSArray arrayWithObjects:
                [NSNumber numberWithInt:_inputVolume[0]],
                [NSNumber numberWithInt:_inputVolume[1]],
                [NSNumber numberWithInt:_inputVolume[2]],
                [NSNumber numberWithInt:_inputVolume[3]],
                [NSNumber numberWithInt:_inputVolume[4]],
                [NSNumber numberWithInt:_inputVolume[5]],
            nil],@"InputVolumeArray",
        nil];
}

-(void)setPrefsWithDictionary:(NSDictionary *)d{
    int i;
    id tmp;
    
    if(tmp=[d objectForKey:@"InputVolumeArray"])
        for(i=0;i<6;i++) _inputVolume[i]=[[tmp objectAtIndex:i] intValue];
}

-(IBAction)power:(id)sender{
    [_vh7pc getStatus];
    [_vh7pc sendCommand:([_vh7pc statusRef]->powerOn)?POWEROFF:POWERON];
    [_mainCtrl setMenuImage:![_vh7pc statusRef]->powerOn];
}

-(IBAction)changeInput:(id)sender{
    if([_prefs rememberVolume]){
        [_vh7pc getStatus];
        _inputVolume[[_vh7pc statusRef]->inputMode]=[_vh7pc statusRef]->volume;
    }
    switch([sender tag]){
        case usbM:	[_vh7pc sendCommand:SEL_USB];	break;
        case amM:
            [_vh7pc sendCommand:SEL_TUNER];
            [_vh7pc getStatus];
            if([_vh7pc statusRef]->inputMode!=AM) [_vh7pc sendCommand:BAND];
            break;
        case fmM:
            [_vh7pc sendCommand:SEL_TUNER];
            [_vh7pc getStatus];
            if([_vh7pc statusRef]->inputMode!=FM) [_vh7pc sendCommand:BAND];
            break;
        case cdM:	[_vh7pc sendCommand:SEL_CD];	break;
        case mdM:	[_vh7pc sendCommand:SEL_MD];	break;
        case tapeM:	[_vh7pc sendCommand:SEL_TAPE];	break;
    }
    if([_prefs rememberVolume]){
        int vol;
        [_vh7pc getStatus];
        if((vol=_inputVolume[[_vh7pc statusRef]->inputMode])>-1) [_vh7pc changeVol:vol];
    }
}

-(IBAction)changeVolume:(id)sender{
    int vol;
    
    [_vh7pc getStatus];
    //NSLog(@"%d,%d",(int)([_vh7pc statusRef]->volume),[sender tag]);
    vol=[sender tag]+[_vh7pc statusRef]->volume;
    if(vol>80) vol=80;
    if(vol<0) vol=0;
    [_vh7pc changeVol:vol];
}

-(IBAction)mute:(id)sender{
    [_vh7pc sendCommand:MUTE];
}

-(IBAction)tone:(id)sender{
    [_vh7pc sendCommand:N_B];
}

-(IBAction)band:(id)sender{
    switch([sender tag]){
        case bandM:	[_vh7pc sendCommand:BAND];	break;
        case autoM:	[_vh7pc sendCommand:AUTO_MONO];	break;
        case upM:	[_vh7pc sendCommand:P_CL_UP];	break;
        case downM:	[_vh7pc sendCommand:P_CL_DN];	break;
        case phsearchM:	[_vh7pc sendCommand:PH_SEARCH];	break;
    }
}

-(IBAction)cd:(id)sender{
    switch([sender tag]){
        case playcdM:	[_vh7pc sendCommand:CD_PLAY];	break;
        case stopcdM:	[_vh7pc sendCommand:CD_STOP];	break;
        case nextcdM:	[_vh7pc sendCommand:CD_SK_UP];	break;
        case prevcdM:	[_vh7pc sendCommand:CD_SK_DN];	break;
        case repcdM:	[_vh7pc sendCommand:CD_REPEAT];	break;
        case randcdM:	[_vh7pc sendCommand:CD_RANDOM];	break;
        case ejectcdM:	[_vh7pc sendCommand:CD_EJECT];	break;
        case searchcdM:	[_vh7pc sendCommand:CD_SEARCH];	break;
        case ffcdM:	[_vh7pc sendCommand:CD_FF];	break;
        case fbcdM:	[_vh7pc sendCommand:CD_FB];	break;
    }
}

-(IBAction)md:(id)sender{
    switch([sender tag]){
        case playmdM:	[_vh7pc sendCommand:MD_PLAY];	break;
        case stopmdM:	[_vh7pc sendCommand:MD_STOP];	break;
        case nextmdM:	[_vh7pc sendCommand:MD_SK_UP];	break;
        case prevmdM:	[_vh7pc sendCommand:MD_SK_DN];	break;
        case repmdM:	[_vh7pc sendCommand:MD_REPEAT];	break;
        case randmdM:	[_vh7pc sendCommand:MD_RANDOM];	break;
        case ejectmdM:	[_vh7pc sendCommand:MD_EJECT];	break;
    }
}

-(IBAction)tape:(id)sender{
    switch([sender tag]){
        case fwdplayM:	[_vh7pc sendCommand:TAPE_FWD];	break;
        case revplayM:	[_vh7pc sendCommand:TAPE_REV];	break;
        case stoptpM:	[_vh7pc sendCommand:TAPE_STOP];	break;
        case ffM:	[_vh7pc sendCommand:TAPE_FF];	break;
        case frM:	[_vh7pc sendCommand:TAPE_FB];	break;
        case playtpM:	[_vh7pc sendCommand:CONTINUE];	break;
    }
}

-(IBAction)triggerController:(id)sender{
    if(_controllerShowed){
        [_controllerController endTimer];
        [_controllerPanel orderOut:sender];
        _controllerShowed=NO;
    }else{
        [_controllerController startTimer];
        [_controllerController displayStatus];
        [_controllerPanel orderFront:sender];
        [_controllerPanel makeKeyWindow];
        [_controllerPanel setViewsNeedDisplay:YES];
        _controllerShowed=YES;
    }
}

@end
