//
//  HotkeyItem.m
//  VH7PC_Controller
//
//  Created by nya on 04/10/10.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import "HotkeyItem.h"


@implementation HotkeyItem

+ (id) itemWithDictionary:(NSDictionary *)dic {
	return [[[HotkeyItem alloc] initWithDictionary:dic] autorelease];
}

- (id) initWithDictionary:(NSDictionary *)dic {
	self = [super init];
	if (!self) return nil;
	
	[self setDictionary:dic];
	
	return self;
}

- (NSDictionary *) dictionary {
	if(keycon_.sat){
		NSDictionary *tmp=[NSDictionary dictionaryWithObjectsAndKeys:
			[NSNumber numberWithUnsignedShort:keycon_.keyCode],@"KeyCode",
			keycon_.keyStr,@"KeyStr",
			[NSNumber numberWithBool:keycon_.shift],@"Shift",
			[NSNumber numberWithBool:keycon_.command],@"Command",
			[NSNumber numberWithBool:keycon_.option],@"Option",
			[NSNumber numberWithBool:keycon_.control],@"Control",
			nil];
		return tmp;
	} else {
		return nil;
	}
}

- (void) setDictionary:(NSDictionary *)dic {
	keycon_.keyCode=[[dic objectForKey:@"KeyCode"] unsignedShortValue];
	keycon_.keyStr=[[dic objectForKey:@"KeyStr"] copy];
	keycon_.shift=[[dic objectForKey:@"Shift"] boolValue];
	keycon_.command=[[dic objectForKey:@"Command"] boolValue];
	keycon_.option=[[dic objectForKey:@"Option"] boolValue];
	keycon_.control=[[dic objectForKey:@"Control"] boolValue];
}


@end
