/* Hotkey */

#import <Carbon/Carbon.h>
#import <Cocoa/Cocoa.h>

typedef struct{
    unsigned short keyCode;
    NSString *keyStr;
    BOOL shift;
    BOOL command;
    BOOL option;
    BOOL control;
    BOOL sat;
} keyCombination;

@interface Hotkey : NSObject
{
    IBOutlet id _settingPanel;
    IBOutlet id _hotkeyPanel;
    
    IBOutlet id _shiftCheck;
    IBOutlet id _ctrlCheck;
    IBOutlet id _cmdCheck;
    IBOutlet id _optCheck;

    id *_fld;
    
    EventHotKeyRef *_hotkey;
    SEL *_hotkeyMethod;
    keyCombination *_keyCombination;
    
    NSMutableArray *_cycle;
    int _hotkeyNum;
}

-(id)initWithNum:(int)n;

-(void)regHotkey:(int)ht keyCombination:(keyCombination)kc;
-(void)unregHotKey:(int)ht;

-(NSDictionary *)hotkeyDictionary;
-(void)regWithDictionary:(NSDictionary *)dic;
-(NSArray *)sameKeyCombinationArray:(keyCombination *)kc;

-(IBAction)delBtn:(id)sender;
-(IBAction)cancelBtn:(id)sender;
-(IBAction)setBtn:(id)sender;
-(void)sheetDidEnd:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo;

@end
