//
//  VH7PC.h
//  VH7PC_Controller
//
//  Created by NYA on Wed Jul 09 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#define VENDER 2856
#define PRODUCT 4097


#define COMMAND_PERIOD 0.2

typedef enum{
    NONE,NB1,NB2,TONE
} VH7PC_tone;

typedef enum{
    PC_USB,FM,AM,CD,MD,TAPE
} VH7PC_inputmode;

typedef enum{
    RAND,REP,RAll,REPRAND,PLAIN
} VH7PC_repinfo;


typedef struct{
    BOOL powerOn;
    BOOL mute;
    VH7PC_tone tone;
    VH7PC_inputmode inputMode;
    int rPresetNum;
    int rStationNum_U;
    int rStationNum_D;
    int cdTracknum;
    int cdMin;
    int cdSec;
    int cdMaxTrack;
    VH7PC_repinfo repInfo;
    int volume;
    BOOL atAuto;
} VH7PC_stat;


#define COMMAND_NUM 52
typedef enum{
    POWERON,
    POWEROFF,
    SEL_TUNER,
    SEL_CD,
    SEL_MD,
    SEL_TAPE,
    SEL_USB,
    VOLUME,
    MUTE,
    N_B ,
    IN_LV_UP,
    IN_LV_DN,
    CD_PLAY,
    CD_STOP,
    CD_SK_UP,
    CD_SK_DN,
    CD_SEARCH,
    CD_FF,
    CD_FB,
    CD_REPEAT,
    CD_RANDOM,
    CD_EJECT,
    BAND,
    AUTO_MONO,
    P_CL_UP,
    P_CL_DN,
    PH_SEARCH,
    MD_PLAY,
    MD_STOP,
    MD_PAUSE,
    MD_REC,
    MD_OTE,
    MD_SK_UP,
    MD_SK_DN,
    MD_SEARCH,
    MD_FF,
    MD_FB,
    MD_ALL_E,
    MD_TRCK_E,
    MD_DIVIDE,
    MD_COMBIN,
    MD_REPEAT,
    MD_RANDOM,
    MD_EJECT,
    TAPE_FWD,
    TAPE_REV,
    TAPE_STOP,
    TAPE_FF,
    TAPE_FB,
    CONTINUE,
    STS_REQ,
    
    GET_STATUS
} VH7PC_cmd;

int notifireInit();
int grabDevice();
int releaseDevice();
void sleepNotifireInit();
void allowPowerChange();


@interface VH7PC : NSObject {
    VH7PC_stat _status;
    NSTimer *_periodTimer;
    NSMutableArray *_commandQueue; 
    BOOL _connected;
}

-(BOOL)getStatus;
-(void)sendCommand:(VH7PC_cmd)cmd;
-(void)changeVol:(int)val;
-(int)sendCommand:(VH7PC_cmd)cmd andValue:(int)val;
-(void)sendCommandByNotification:(NSNotification *)nc;

-(void)setStatus;
-(void)setConnedted:(BOOL)b;

//-(void)stopTimer;

-(VH7PC_stat *)statusRef;
-(NSDictionary*)statusDictionary;
-(BOOL)connected;

@end
