/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "msvcrt.h"


/******************************************************************************
*                                                                             *
* 黻                                                                        *
*                                                                             *
******************************************************************************/
static int msvcrt_adjust_fdiv=0;


static unsigned int msvcrt_clearfp(void)
{
	g_debug("_clearfp");
	return 0;
}


/******************************************************************************
*                                                                             *
*                                                                           *
*                                                                             *
******************************************************************************/
static void *msvcrt_dllonexit(void *arg1,void *arg2,void *arg3)
{
	g_debug("__dllonexit");
	return NULL;
}


static int msvcrt_initterm(void **arg1,void **arg2)
{
	BOOL (*initterm_func)(void);

	g_debug("initterm");
	while (arg1<arg2) {
		if ((initterm_func=(BOOL(*)(void))*arg1))
			initterm_func();
		arg1++;
	}
	return 0;
}


static void *msvcrt_onexit(void *arg1)
{
	g_debug("_onexit");
	return NULL;
}


/******************************************************************************
*                                                                             *
*                                                                       *
*                                                                             *
******************************************************************************/
static void *msvcrt_malloc(size_t size)
{
	g_debug("malloc");
	return g_malloc(size);
}


static void msvcrt_free(void *memblock)
{
	g_debug("free");
	g_free(memblock);
}


static void *msvcrt_new(size_t size)
{
	g_debug("new");
	return msvcrt_malloc(size);
}


static void msvcrt_delete(void *memblock)
{
	g_debug("delete");
	msvcrt_free(memblock);
}


/******************************************************************************
*                                                                             *
* ʸ                                                                      *
*                                                                             *
******************************************************************************/
static double msvcrt_atof(const char *string)
{
	g_debug("atof");
	return atof(string);
}


static int msvcrt_isalnum(int c)
{
	g_debug("isalnum");
	return g_ascii_isalnum(c);
}


static char *msvcrt_strchr(const char *string,int c)
{
	g_debug("strchr");
	return g_strchr(string,c);
}


static int msvcrt_strcmpi(const char *string1,const char *string2)
{
	g_debug("_strcmpi");
	return g_strcasecmp(string1,string2);
}


static char *msvcrt_strrchr(const char *string,int c)
{
	g_debug("strrchr");
	return g_strrchr(string,c);
}


static int msvcrt_toupper(int c)
{
	g_debug("toupper");
	return g_ascii_toupper(c);
}

static wchar_t *msvcrt_wcscpy(wchar_t *string1,const wchar_t *string2)
{
	gint i=0;

	g_debug("wcscpy");
	do
		string1[i]=string2[i];
	while (string2[i++]!=0);
	return string1;
}


/******************************************************************************
*                                                                             *
*                                                                         *
*                                                                             *
******************************************************************************/
static int msvcrt_rand(void)
{
	g_debug("rand");
	return rand();
}


static void msvcrt_srand(unsigned int seed)
{
	g_debug("srand");
	return srand(seed);
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in msvcrt called");
}


static SymbolInfo symbol_infos[]={
	{"_adjust_fdiv",&msvcrt_adjust_fdiv},
	{"_clearfp",msvcrt_clearfp},

	{"__dllonexit",msvcrt_dllonexit},
	{"_initterm",msvcrt_initterm},
	{"_onexit",msvcrt_onexit},

	{"malloc",msvcrt_malloc},
	{"free",msvcrt_free},
	{"??2@YAPAXI@Z",msvcrt_new},
	{"??3@YAXPAX@Z",msvcrt_delete},

	{"atof",msvcrt_atof},
	{"isalnum",msvcrt_isalnum},
	{"strchr",msvcrt_strchr},
	{"_strcmpi",msvcrt_strcmpi},
	{"strrchr",msvcrt_strrchr},
	{"toupper",msvcrt_toupper},
	{"wcscpy",msvcrt_wcscpy},

	{"rand",msvcrt_rand},
	{"srand",msvcrt_srand},
	{NULL,UnknownSymbol}
};


SymbolInfo *msvcrt_get_export_symbols(void)
{
	return symbol_infos;
}
