/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "user32.h"
#include <gdk/gdkkeysyms.h>
#include "iso10646.h"
#include "resource.h"
#include "winuser.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* å                                                                  *
*                                                                             *
******************************************************************************/
static LRESULT WINAPI SendMessageA(HWND hWnd,
										UINT Msg,WPARAM wParam,LPARAM lParam)
{
	g_debug("SendMessageA");
	return hWnd!=NULL?
			((WindowExtraData *)gtk_object_get_user_data(GTK_OBJECT(hWnd)))->
										lpfnWndProc(hWnd,Msg,wParam,lParam):0;
}


/******************************************************************************
*                                                                             *
* ɥ                                                                  *
*                                                                             *
******************************************************************************/
#define GWL_USERDATA	(-21)
#define GWL_EXSTYLE		(-20)
#define GWL_STYLE		(-16)
#define GWL_ID			(-12)
#define GWL_HWNDPARENT	(-8)
#define GWL_HINSTANCE	(-6)
#define GWL_WNDPROC		(-4)
#define DWL_MSGRESULT	0
#define DWL_DLGPROC		4
#define DWL_USER		8
/* ShowWindow() codes */
#define SW_HIDE				0
#define SW_SHOWNORMAL		1
#define SW_NORMAL			1
#define SW_SHOWMINIMIZED	2
#define SW_SHOWMAXIMIZED	3
#define SW_MAXIMIZE			3
#define SW_SHOWNOACTIVATE	4
#define SW_SHOW				5
#define SW_MINIMIZE			6
#define SW_SHOWMINNOACTIVE	7
#define SW_SHOWNA			8
#define SW_RESTORE			9
#define SW_SHOWDEFAULT		10
#define SW_FORCEMINIMIZE	11
#define SW_MAX				11
#define SW_NORMALNA			0xCC	/* undoc. flag in MinMaximize */


typedef BOOL CALLBACK (*WNDENUMPROC)(HWND,LPARAM);


static LRESULT WINAPI DefWindowProcA(HWND hWnd,UINT Msg,
												WPARAM wParam,LPARAM lParam)
{
	g_debug("DefWindowProcA");
	return DefWindowProc(hWnd,Msg,wParam,lParam);
}


static BOOL WINAPI DestroyWindow(HWND hWnd)
{
	g_debug("DestroyWindow");
	if (hWnd==NULL)
		return FALSE;
	gtk_widget_destroy(GTK_WIDGET(hWnd));
	return TRUE;
}


static BOOL WINAPI EnableWindow(HWND hWnd,BOOL bEnable)
{
	g_debug("EnableWindow");
	if (hWnd==NULL)
		return FALSE;
	SendMessageA(hWnd,WM_ENABLE,bEnable,0);
	return TRUE;
}


static BOOL WINAPI EnumThreadWindows(DWORD dwThreadId,
												WNDENUMPROC lpfn,LPARAM lParam)
{
	g_debug("EnumThreadWindows");
	return TRUE;
}


static HWND WINAPI GetDesktopWindow(VOID)
{
	g_debug("GetDesktopWindow");
	return NULL;
}


static HWND WINAPI GetFocus(VOID)
{
	g_debug("GetFocus");
	return NULL;
}


static LONG WINAPI GetWindowLongA(HWND hWnd,INT nIndex)
{
	WindowExtraData *wed;

	g_debug("GetWindowLongA");
	if ((wed=gtk_object_get_user_data(GTK_OBJECT(hWnd)))!=NULL)
		switch (nIndex) {
			case GWL_USERDATA:	return wed->dwUserData;
			case GWL_EXSTYLE:	return wed->dwExStyle;
			case GWL_STYLE:		return wed->dwStyle;
			case GWL_ID:		return wed->wID;
			case GWL_HWNDPARENT:return (LONG)wed->hWndParent;
			case GWL_HINSTANCE:	return (LONG)wed->hInstance;
			case GWL_WNDPROC:	return (LONG)wed->lpfnWndProc;
			case DWL_MSGRESULT:	return wed->lResult;
			case DWL_DLGPROC:	return (LONG)wed->lpDialogFunc;
			case DWL_USER:		return wed->dwUser;
		}
	return 0;
}


static INT WINAPI GetWindowTextA(HWND hWnd,LPSTR lpString,INT nMaxCount)
{
	g_debug("GetWindowTextA");
	return SendMessageA(hWnd,WM_GETTEXT,nMaxCount,(LPARAM)lpString);
}


static HWND WINAPI SetFocus(HWND hWnd)
{
	g_debug("SetFocus");
	gtk_widget_grab_focus(GTK_WIDGET(hWnd));
	return hWnd;
}


static LONG WINAPI SetWindowLongA(HWND hWnd,INT nIndex,LONG dwNewLong)
{
	LONG dwOldLong=0;
	WindowExtraData *wed;

	g_debug("SetWindowLongA");
	if ((wed=gtk_object_get_user_data(GTK_OBJECT(hWnd)))!=NULL)
		switch (nIndex) {
			case GWL_USERDATA:
				dwOldLong=wed->dwUserData;
				wed->dwUserData=dwNewLong;
				break;
			case GWL_EXSTYLE:
				dwOldLong=wed->dwExStyle;
				wed->dwExStyle=dwNewLong;
				break;
			case GWL_STYLE:
				dwOldLong=wed->dwStyle;
				wed->dwStyle=dwNewLong;
				break;
			case GWL_ID:
				dwOldLong=wed->wID;
				wed->wID=dwNewLong;
				break;
			case GWL_HWNDPARENT:
				dwOldLong=(DWORD)wed->hWndParent;
				wed->hWndParent=(HWND)dwNewLong;
				break;
			case GWL_HINSTANCE:
				dwOldLong=(DWORD)wed->hInstance;
				wed->hInstance=(HINSTANCE)dwNewLong;
				break;
			case GWL_WNDPROC:
				dwOldLong=(DWORD)wed->lpfnWndProc;
				wed->lpfnWndProc=(WNDPROC)dwNewLong;
				break;
			case DWL_MSGRESULT:
				dwOldLong=wed->lResult;
				wed->lResult=dwNewLong;
				break;
			case DWL_DLGPROC:
				dwOldLong=(DWORD)wed->lpDialogFunc;
				wed->lpDialogFunc=(DLGPROC)dwNewLong;
				break;
			case DWL_USER:
				dwOldLong=wed->dwUser;
				wed->dwUser=dwNewLong;
		}
	return dwOldLong;
}


static BOOL WINAPI SetWindowTextA(HWND hWnd,LPCSTR lpString)
{
	g_debug("SetWindowTextA");
	return SendMessageA(hWnd,WM_SETTEXT,0,(LPARAM)lpString);
}


static BOOL WINAPI ShowWindow(HWND hWnd,INT nCmdShow)
{
	g_debug("ShowWindow");
	if (hWnd==NULL)
		return FALSE;
	SendMessageA(hWnd,WM_SHOWWINDOW,nCmdShow!=SW_HIDE,0);
	return TRUE;
}


/******************************************************************************
*                                                                             *
* /ɸ                                                                   *
*                                                                             *
******************************************************************************/
static BOOL WINAPI GetClientRect(HWND hWnd,LPRECT lpRect)
{
	gint width,height;

	g_debug("GetClientRect");
	if (GTK_IS_WINDOW(hWnd))
		gdk_window_get_size(GTK_BIN(hWnd)->child->window,&width,&height);
	else
		gdk_window_get_size(GTK_WIDGET(hWnd)->window,&width,&height);
	lpRect->left=0;
	lpRect->top=0;
	lpRect->right=width;
	lpRect->bottom=height;
	return TRUE;
}


static BOOL WINAPI GetWindowRect(HWND hWnd,LPRECT lpRect)
{
	gint x,y,width,height;

	g_debug("GetWindowRect");
	if (hWnd==NULL)
		return FALSE;
	gdk_window_get_root_origin(GTK_WIDGET(hWnd)->window,&x,&y);
	gdk_window_get_size(GTK_WIDGET(hWnd)->window,&width,&height);
	lpRect->left=x;
	lpRect->top=y;
	lpRect->right=x+width;
	lpRect->bottom=y+height;
	return TRUE;
}


static BOOL WINAPI IsRectEmpty(CONST RECT *lprc)
{
	return lprc->left<lprc->right && lprc->top<lprc->bottom;
}


static INT WINAPI MapWindowPoints(HWND hWndFrom,HWND hWndTo,
												LPPOINT lpPoints,UINT cPoints)
{
	gint i,cx,cy,dx,dy,sx,sy;

	g_debug("MapWindowPoints");
	gdk_window_get_root_origin(GTK_WIDGET(hWndFrom)->window,&sx,&sy);
	gdk_window_get_root_origin(GTK_WIDGET(hWndTo)->window,&dx,&dy);
	cx=sx-dx;
	cy=sy-dy;
	for (i=0;i<cPoints;i++) {
		lpPoints[i].x+=cx;
		lpPoints[i].y+=cy;
	}
	return MAKELONG(cx,cy);
}


static BOOL WINAPI MoveWindow(HWND hWnd,INT X,INT Y,INT nWidth,INT nHeight,
																BOOL bRepaint)
{
	g_debug("MoveWindow");
	return FALSE;
}


static BOOL WINAPI OffsetRect(LPRECT lprc,INT dx,INT dy)
{
	g_debug("OffsetRect");
	lprc->left+=dx;
	lprc->top+=dy;
	lprc->right+=dx;
	lprc->bottom+=dy;
	return TRUE;
}


static BOOL WINAPI ScreenToClient(HWND hWnd,LPPOINT lpPoint)
{
	g_debug("ScreenToClient");
	return FALSE;
}


static BOOL WINAPI SetWindowPos(HWND hWnd,HWND hWndInsertAfter,
										INT X,INT Y,INT cx,INT cy,UINT uFlags)
{
	g_debug("SetWindowPos");
	return FALSE;
}


/******************************************************************************
*                                                                             *
* ǥХƥ                                                        *
*                                                                             *
******************************************************************************/
static HDC WINAPI BeginPaint(HWND hWnd,LPPAINTSTRUCT lpPaint)
{
	g_debug("BeginPaint");
	return NULL;
}


static BOOL WINAPI EndPaint(HWND hWnd,LPPAINTSTRUCT lpPaint)
{
	g_debug("EndPaint");
	return FALSE;
}


static HDC WINAPI GetDC(HWND hWnd)
{
	g_debug("GetDC");
	return NULL;
}


static BOOL WINAPI InvalidateRect(HWND hWnd,CONST RECT *lpRect,BOOL bErase)
{
	GdkRectangle rc;

	g_debug("InvalidateRect");
	if (hWnd==NULL)
		return FALSE;
	if (lpRect!=NULL) {
		rc.x=lpRect->left;
		rc.y=lpRect->top;
		rc.width=lpRect->right-lpRect->left;
		rc.height=lpRect->bottom-lpRect->top;
		gtk_widget_draw(GTK_WIDGET(hWnd),&rc);
	} else {
		gtk_widget_draw(GTK_WIDGET(hWnd),NULL);
	}
	return TRUE;
}


static INT WINAPI ReleaseDC(HWND hWnd,HDC hDC)
{
	g_debug("ReleaseDC");
	return 0;
}


/******************************************************************************
*                                                                             *
* ꥽                                                                    *
*                                                                             *
******************************************************************************/
/* Predefined resource types */
#define RT_CURSOR		1
#define RT_BITMAP		2
#define RT_ICON			3
#define RT_MENU			4
#define RT_DIALOG		5
#define RT_STRING		6
#define RT_FONTDIR		7
#define RT_FONT			8
#define RT_ACCELERATOR	9
#define RT_RCDATA		10
#define RT_MESSAGETABLE	11
#define RT_GROUP_CURSOR	12
#define RT_GROUP_ICON	14
#define RT_VERSION		16
#define RT_DLGINCLUDE	17
#define RT_PLUGPLAY		19
#define RT_VXD			20
#define RT_ANICURSOR	21
#define RT_ANIICON		22
#define RT_HTML			23


static HRSRC WINAPI user32_FindResourceExA(HMODULE hModule,
									LPCSTR lpType,LPCSTR lpName,WORD wLanguage)
{
	g_debug("FindResourceExA");
	return FindResourceExA(hModule,lpType,lpName,wLanguage);
}


static HRSRC WINAPI user32_FindResourceA(HMODULE hModule,
												LPCSTR lpName,LPCSTR lpType)
{
	g_debug("FindResourceA");
	return FindResourceA(hModule,lpName,lpType);
}


static BOOL WINAPI user32_FreeResource(HGLOBAL hResData)
{
	g_debug("FreeResource");
	return FreeResource(hResData);
}


static HBITMAP WINAPI user32_LoadBitmapA(HINSTANCE hInstance,
														LPCSTR lpBitmapName)
{
	g_debug("LoadBitmapA");
	return LoadBitmapA(hInstance,lpBitmapName);
}


static HGLOBAL WINAPI user32_LoadResource(HMODULE hModule,HRSRC hResInfo)
{
	g_debug("LoadResource");
	return LoadResource(hModule,hResInfo);
}


static INT WINAPI user32_LoadStringA(HINSTANCE hInstance,UINT uID,
												LPSTR lpBuffer,INT nBufferMax)
{
	g_debug("LoadStringA");
	return LoadStringA(hInstance,uID,lpBuffer,nBufferMax);
}


static INT WINAPI user32_LoadStringW(HINSTANCE hInstance,UINT uID,
												LPWSTR lpBuffer,INT nBufferMax)
{
	g_debug("LoadStringW");
	return LoadStringW(hInstance,uID,lpBuffer,nBufferMax);
}


static LPVOID WINAPI user32_LockResource(HGLOBAL hResData)
{
	g_debug("LockResource");
	return LockResource(hResData);
}


static DWORD WINAPI user32_SizeofResource(HMODULE hModule,HRSRC hResInfo)
{
	g_debug("SizeofResource");
	return SizeofResource(hModule,hResInfo);
}


/******************************************************************************
*                                                                             *
*                                                                   *
*                                                                             *
******************************************************************************/
#include "pshpack2.h"
/* FIXME: use this instead of LPCVOID for CreateDialogIndirectParam
   and DialogBoxIndirectParam */
typedef struct tagDLGTEMPLATE {
	DWORD style;
	DWORD exstyle;
	WORD cdit;
	SHORT x;
	SHORT y;
	SHORT cx;
	SHORT cy;
} DLGTEMPLATE,*PDLGTEMPLATE,*LPDLGTEMPLATE;
typedef CONST DLGTEMPLATE *PCDLGTEMPLATE,*LPCDLGTEMPLATE;

typedef struct tagDLGITEMTEMPLATE {
	DWORD style;
	DWORD exstyle;
	SHORT x;
	SHORT y;
	SHORT cx;
	SHORT cy;
	WORD ID;
} DLGITEMTEMPLATE,*PDLGITEMTEMPLATE,*LPDLGITEMTEMPLATE;
typedef CONST DLGITEMTEMPLATE *PCDLGITEMTEMPLATE,*LCPDLGITEMTEMPLATE;

typedef struct tagDLGTEMPLATEEX {
	WORD dlgVer;
	WORD signature;
	DWORD helpID;
	DWORD exstyle;
	DWORD style;
	WORD cdit;
	SHORT x;
	SHORT y;
	SHORT cx;
	SHORT cy;
} DLGTEMPLATEEX,*PDLGTEMPLATEEX,*LPDLGTEMPLATEEX;
typedef CONST DLGTEMPLATEEX *PCDLGTEMPLATEEX,*LPCDLGTEMPLATEEX;

typedef struct tagDLGITEMTEMPLATEEX {
	DWORD helpID;
	DWORD exstyle;
	DWORD style;
	SHORT x;
	SHORT y;
	SHORT cx;
	SHORT cy;
	WORD ID;
} DLGITEMTEMPLATEEX,*PDLGITEMTEMPLATEEX,*LPDLGITEMTEMPLATEEX;
#include "poppack.h"


/* ܥ󤬲줿Ȥ */
#define dialog_button_toggled dialog_button_clicked
static void dialog_button_clicked(GtkWidget *widget,gpointer user_data)
{
	WindowExtraData *wed;

	wed=gtk_object_get_user_data(GTK_OBJECT(widget));
	wed->lpDialogFunc(wed->hWndParent,WM_COMMAND,
							MAKEWPARAM(wed->wID,BN_CLICKED),(LPARAM)widget);
}


/* Ĥܥ󤬲줿 */
static gboolean dialog_delete(GtkWidget *widget,
										GdkEvent *event,WindowExtraData *wed)
{
	wed->lpDialogFunc(widget,WM_COMMAND,
								MAKEWPARAM(IDCANCEL,BN_CLICKED),(LPARAM)NULL);
	return TRUE;
}


/* ESC줿 */
static gboolean dialog_key_press(GtkWidget *widget,
									GdkEventKey *event,WindowExtraData *wed)
{
	if (event->keyval==GDK_Escape)
		wed->lpDialogFunc(widget,WM_COMMAND,
								MAKEWPARAM(IDCANCEL,BN_CLICKED),(LPARAM)NULL);
	return FALSE;
}


/* ˴ */
static void dialog_widget_destroy(GtkWidget *widget,gpointer user_data)
{
	WindowExtraData *wed;

	wed=gtk_object_get_user_data(GTK_OBJECT(widget));
	g_free(wed->child);
	g_free(wed->sister);
	g_free(wed);
}


static guint16 *dlg_string_next(guint16 *data)
{
	if (*data==0xffff) {
		data+=2;
	} else {
		while (*data!=0)
			data++;
		data++;
	}
	return data;
}
#define DLG_STRING_NEXT(data) ((data)=dlg_string_next(data))


static INT WINAPI DialogBoxIndirectParam(HINSTANCE hInstance,
					LPCDLGTEMPLATE lpDialogTemplate,
					HWND hWndParent,DLGPROC lpDialogFunc,LPARAM dwInitParam)
{
	gboolean extended;
	gchar *title;
	gint i,j,leng,w,width=0,h,height=0,cdit=0;
	guint key=GDK_VoidSymbol;
	guint16 *data,atom;
	GtkAccelGroup *accel;
	GtkStyle *style;
	GtkWidget *dialog,*fixed,*widget,*focus=NULL;
	INT nResult;
	DLGTEMPLATE DialogTemplate;
	DLGITEMTEMPLATE DialogItem;
	WindowExtraData *dlg,*wed;

	g_debug("DialogBoxIndirectParam");
	if (lpDialogTemplate==NULL || lpDialogFunc==NULL)
		return -1;

	if (((LPCDLGTEMPLATEEX)lpDialogTemplate)->dlgVer==1
				&& ((LPCDLGTEMPLATEEX)lpDialogTemplate)->signature==0xffff) {
		extended=TRUE;
		DialogTemplate.style=((LPCDLGTEMPLATEEX)lpDialogTemplate)->style;
		DialogTemplate.exstyle=((LPCDLGTEMPLATEEX)lpDialogTemplate)->exstyle;
		DialogTemplate.cdit=((LPCDLGTEMPLATEEX)lpDialogTemplate)->cdit;
		DialogTemplate.x=((LPCDLGTEMPLATEEX)lpDialogTemplate)->x;
		DialogTemplate.y=((LPCDLGTEMPLATEEX)lpDialogTemplate)->y;
		DialogTemplate.cx=((LPCDLGTEMPLATEEX)lpDialogTemplate)->cx;
		DialogTemplate.cy=((LPCDLGTEMPLATEEX)lpDialogTemplate)->cy;
		data=(guint16 *)((LPCDLGTEMPLATEEX)lpDialogTemplate+1);
	} else {
		extended=FALSE;
		g_memmove(&DialogTemplate,lpDialogTemplate,sizeof(DLGTEMPLATE));
		data=(guint16 *)(lpDialogTemplate+1);
	}
	/* Menu name */
	DLG_STRING_NEXT(data);
	/* Class name */
	DLG_STRING_NEXT(data);
	/* Dialog Title */
	if (*data==0xffff) {
		title=NULL;
	} else {
		leng=iso10646_widechar_to_multibyte(data,-1,NULL,-1);
		title=g_malloc(leng*sizeof(gchar));
		iso10646_widechar_to_multibyte(data,-1,title,leng);
	}
	DLG_STRING_NEXT(data);
	if ((DialogTemplate.style&DS_SETFONT)!=0) {
		/* Font Point Weight Italic Charset */
		data+=extended?3:1;
		/* Font Face */
		DLG_STRING_NEXT(data);
	}

	dlg=g_malloc(sizeof(WindowExtraData));
	dlg->dwStyle=DialogTemplate.style;
	dlg->dwExStyle=DialogTemplate.exstyle;
	dlg->lpfnWndProc=DefWindowProc;
	dlg->hInstance=hInstance;
	dlg->hWndParent=hWndParent;
	dlg->wID=0;
	dlg->dwUserData=0;
	dlg->lpDialogFunc=lpDialogFunc;
	dlg->lResult=-1;
	dlg->dwUser=0;
	dlg->child=g_malloc((DialogTemplate.cdit+1)*sizeof(GtkWidget *));
	dlg->sister=NULL;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	if (title!=NULL) {
		gtk_window_set_title(GTK_WINDOW(dialog),title);
		g_free(title);
	}
	gtk_signal_connect(GTK_OBJECT(dialog),"key-press-event",
										GTK_SIGNAL_FUNC(dialog_key_press),dlg);
	gtk_signal_connect(GTK_OBJECT(dialog),"delete-event",
										GTK_SIGNAL_FUNC(dialog_delete),dlg);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	gtk_widget_realize(dialog);
	gtk_object_set_user_data(GTK_OBJECT(dialog),dlg);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ե */
	style=gtk_widget_get_style(GTK_WIDGET(dialog));
	for (i=0;i<256;i++)
		if (g_ascii_isalnum(i)) {
			w=gdk_char_width(style->font,i);
			if (width<w)
				width=w;
			h=gdk_char_height(style->font,i);
			if (height<h)
				height=h;
		}
	width=MIN((height+1)/2,width);
	/* ե */
	fixed=gtk_fixed_new();
	gtk_widget_set_usize(fixed,
						DialogTemplate.cx*width/4,DialogTemplate.cy*height/8);
	gtk_container_add(GTK_CONTAINER(dialog),fixed);

	for (i=0;i<DialogTemplate.cdit;i++) {
		widget=NULL;

		/* Dialog Item */
		data=(guint16 *)((((DWORD)data-(DWORD)lpDialogTemplate+3)/4)*4
													+(DWORD)lpDialogTemplate);
		if (extended) {
			DialogItem.style=((LPDLGITEMTEMPLATEEX)data)->style;
			DialogItem.exstyle=((LPDLGITEMTEMPLATEEX)data)->exstyle;
			DialogItem.x=((LPDLGITEMTEMPLATEEX)data)->x;
			DialogItem.y=((LPDLGITEMTEMPLATEEX)data)->y;
			DialogItem.cx=((LPDLGITEMTEMPLATEEX)data)->cx;
			DialogItem.cy=((LPDLGITEMTEMPLATEEX)data)->cy;
			DialogItem.ID=((LPDLGITEMTEMPLATEEX)data)->ID;
			data=(guint16 *)((LPDLGITEMTEMPLATEEX)data+1);
			data=(guint16 *)((((DWORD)data-(DWORD)lpDialogTemplate+3)/4)*4
													+(DWORD)lpDialogTemplate);
		} else {
			g_memmove(&DialogItem,data,sizeof(DLGITEMTEMPLATE));
			data=(guint16 *)((LPDLGITEMTEMPLATE)data+1);
		}
		/* Class name */
		atom=*data==0xffff?data[1]:0;
		DLG_STRING_NEXT(data);
		/* Dialog Title */
		if (*data==0xffff) {
			title=NULL;
		} else {
			leng=iso10646_widechar_to_multibyte(data,-1,NULL,-1);
			title=g_malloc(leng*sizeof(gchar));
			iso10646_widechar_to_multibyte(data,-1,title,leng);
		}
		DLG_STRING_NEXT(data);
		/* Creation Data */
		(guint8 *)data+=*data+sizeof(guint16);

		wed=g_malloc(sizeof(WindowExtraData));
		wed->dwStyle=DialogItem.style;
		wed->dwExStyle=DialogItem.exstyle;
		wed->lpfnWndProc=DefWindowProc;
		wed->hInstance=hInstance;
		wed->hWndParent=dialog;
		wed->wID=DialogItem.ID;
		wed->dwUserData=0;
		wed->lpDialogFunc=lpDialogFunc;
		wed->lResult=-1;
		wed->dwUser=0;
		wed->child=NULL;
		wed->sister=NULL;

		switch (atom) {
		case 0x0080:/* ܥ */
			switch (DialogItem.style&0xf) {
			case BS_PUSHBUTTON:
			case BS_DEFPUSHBUTTON:
				widget=gtk_button_new_with_label(NULL);
				gtk_signal_connect(GTK_OBJECT(widget),"clicked",
												dialog_button_clicked,NULL);
				break;
			case BS_AUTOCHECKBOX:
				widget=gtk_check_button_new_with_label(NULL);
				gtk_signal_connect(GTK_OBJECT(widget),"toggled",
												dialog_button_toggled,NULL);
				break;
			default:
				g_print("Unsupported Dialog Item Button.\n");
			}
			if (widget!=NULL) {
				if (title!=NULL)
					for (j=0;title[j]!='\0';j++)
						if (title[j]=='&')
							title[j]='_';
				key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(widget)->child),
												title!=NULL?title:"Button");
				if (key!=GDK_VoidSymbol) {
					gtk_widget_add_accelerator(widget,"clicked",
													accel,key,GDK_MOD1_MASK,0);
					key=GDK_VoidSymbol;
				}
				switch (DialogItem.style&0x00000300L) {
				case BS_LEFT:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(widget)->child),
															GTK_JUSTIFY_LEFT);
					break;
				case BS_RIGHT:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(widget)->child),
															GTK_JUSTIFY_RIGHT);
					break;
				case BS_CENTER:
					gtk_label_set_justify(GTK_LABEL(GTK_BIN(widget)->child),
														GTK_JUSTIFY_CENTER);
				}
				gtk_widget_set_usize(widget,
								DialogItem.cx*width/4,DialogItem.cy*height/8);
				if (focus==NULL)
					focus=widget;
			}
			break;
		case 0x0081:/* ǥ */
			g_print("Unsupported Dialog Item Edit.\n");
			break;
		case 0x0082:/* ƥå */
			switch (DialogItem.style&0x1F) {
			case SS_LEFT:
			case SS_CENTER:
			case SS_RIGHT:
			case SS_LEFTNOWORDWRAP:
				if ((DialogItem.style&SS_NOPREFIX)!=0 || title==NULL) {
					widget=gtk_label_new(title!=NULL?title:"Static");
					key=GDK_VoidSymbol;
				} else {
					widget=gtk_label_new(NULL);
					for (j=0;title[j]!='\0';j++)
						if (title[j]=='&')
							title[j]='_';
					key=gtk_label_parse_uline(GTK_LABEL(widget),title);
				}
				switch (DialogItem.style&0x1F) {
				case SS_CENTER:
					gtk_label_set_justify(GTK_LABEL(widget),
														GTK_JUSTIFY_CENTER);
					break;
				case SS_RIGHT:
					gtk_label_set_justify(GTK_LABEL(widget),GTK_JUSTIFY_RIGHT);
					break;
				default:gtk_label_set_justify(GTK_LABEL(widget),
															GTK_JUSTIFY_LEFT);
				}
				break;
			default:
				g_print("Unsupported Dialog Item Static.\n");
			}
			if (widget!=NULL)
				gtk_widget_set_usize(widget,
								DialogItem.cx*width/4,DialogItem.cy*height/8);
			break;
		case 0x0083:/* ꥹȥܥå */
			g_print("Unsupported Dialog Item ListBox.\n");
			break;
		case 0x0084:/* С */
			g_print("Unsupported Dialog Item ScrollBar.\n");
			break;
		case 0x0085:/* ܥܥå */
			widget=gtk_combo_new();
			gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(widget)->entry),
									(DialogItem.style&0xf)!=CBS_DROPDOWNLIST);
			if (key!=GDK_VoidSymbol) {
				gtk_widget_add_accelerator(GTK_COMBO(widget)->entry,
									"grab-focus",accel,key,GDK_MOD1_MASK,0);
				key=GDK_VoidSymbol;
			}
			if (focus==NULL)
				focus=widget;
			break;
		case 0x0000:/* 桼 */
			g_print("User-defined Dialog Item.\n");
			break;
		default:
			g_print("Unknown Dialog Item.\n");
		}
		g_free(title);
		if (widget==NULL) {
			g_free(wed);
		} else {
			gtk_signal_connect_after(GTK_OBJECT(widget),"destroy",
												dialog_widget_destroy,NULL);
			gtk_object_set_user_data(GTK_OBJECT(widget),wed);
			gtk_fixed_put(GTK_FIXED(fixed),widget,
								DialogItem.x*width/4,DialogItem.y*height/8);
			if ((DialogItem.style&WS_DISABLED)!=0)
				gtk_widget_set_sensitive(widget,FALSE);
			if ((DialogItem.style&WS_VISIBLE)!=0)
				gtk_widget_show(widget);
			if (wed->sister!=NULL)
				for (j=0;wed->sister[j]!=NULL;j++) {
					if ((DialogItem.style&WS_DISABLED)!=0)
						gtk_widget_set_sensitive(wed->sister[j],FALSE);
					if ((DialogItem.style&WS_VISIBLE)!=0)
						gtk_widget_show(wed->sister[j]);
				}
			dlg->child[cdit++]=widget;
		}
	}
	if (dlg->child!=NULL)
		dlg->child[cdit]=NULL;

	/* ɽ */
	if (focus!=NULL)
		gtk_widget_grab_focus(focus);
	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,FALSE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show(fixed);
	gtk_widget_show(dialog);
	lpDialogFunc(dialog,WM_INITDIALOG,(WPARAM)focus,dwInitParam);
	gtk_main();

	nResult=dlg->lResult;
	g_free(dlg->child);
	g_free(dlg);
	return nResult;
}


static INT WINAPI DialogBoxParamA(HINSTANCE hInstance,LPCSTR lpTemplateName,
					HWND hWndParent,DLGPROC lpDialogFunc,LPARAM dwInitParam)
{
	LPCDLGTEMPLATE lpDialogTemplate;
	HRSRC hRsrc;

	g_debug("DialogBoxParamA");
	return (hRsrc=FindResourceA(hInstance,
									lpTemplateName,(LPCSTR)RT_DIALOG))!=NULL
					&& (lpDialogTemplate=LoadResource(hInstance,hRsrc))!=NULL
		?DialogBoxIndirectParam(hInstance,lpDialogTemplate,
									hWndParent,lpDialogFunc,dwInitParam):-1;
}


static HWND WINAPI GetDlgItem(HWND hDlg,INT nIDDlgItem)
{
	gint i;
	WindowExtraData *dlg,*wed;

	g_debug("GetDlgItem");
	if (hDlg!=NULL && (dlg=gtk_object_get_user_data(GTK_OBJECT(hDlg)))!=NULL)
		for (i=0;dlg->child[i]!=NULL;i++)
			if ((wed=gtk_object_get_user_data(GTK_OBJECT(dlg->child[i])))!=NULL
												&& wed->wID==(WORD)nIDDlgItem)
				return dlg->child[i];
	return NULL;
}


static BOOL WINAPI CheckDlgButton(HWND hDlg,INT nIDButton,UINT uCheck)
{
	GtkWidget *widget;

	g_debug("CheckDlgButton");
	if (uCheck!=BST_INDETERMINATE
								&& (widget=GetDlgItem(hDlg,nIDButton))!=NULL) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),
														uCheck==BST_CHECKED);
		return TRUE;
	}
	return FALSE;
}


static BOOL WINAPI CheckRadioButton(HWND hDlg,
					INT nIDFirstButton,INT nIDLastButton,INT nIDCheckButton)
{
	gint i;
	GtkWidget *widget;

	g_debug("CheckRadioButton");
	for (i=nIDFirstButton;i<=nIDLastButton;i++)
		if ((widget=GetDlgItem(hDlg,i))!=NULL)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),
															i==nIDCheckButton);
	return TRUE;
}


static BOOL WINAPI EndDialog(HWND hDlg,INT nResult)
{
	WindowExtraData *wed;

	g_debug("EndDialog");
	if (hDlg!=NULL && (wed=gtk_object_get_user_data(GTK_OBJECT(hDlg)))!=NULL) {
		wed->lResult=nResult;
		gtk_widget_destroy(GTK_WIDGET(hDlg));
		return TRUE;
	}
	return FALSE;
}


static INT WINAPI GetDlgCtrlID(HWND hWndCtl)
{
	WindowExtraData *wed;

	g_debug("GetDlgCtrlID");
	return hWndCtl!=NULL
				&& (wed=gtk_object_get_user_data(GTK_OBJECT(hWndCtl)))!=NULL
																?wed->wID:0;
}


static UINT WINAPI GetDlgItemInt(HWND hDlg,INT nIDDlgItem,
											BOOL *lpTranslated,BOOL bSigned)
{
	gboolean result=FALSE;
	gchar *text=NULL;
	gint value=0;
	GtkWidget *widget;

	g_debug("GetDlgItemInt");
	if ((widget=GetDlgItem(hDlg,nIDDlgItem))!=NULL) {
		if (GTK_IS_BUTTON(widget) || GTK_IS_CHECK_BUTTON(widget)
												|| GTK_IS_RADIO_BUTTON(widget))
			gtk_label_get(GTK_LABEL(GTK_BIN(widget)->child),&text);
		else if (GTK_IS_LABEL(widget))
			gtk_label_get(GTK_LABEL(widget),&text);
	}
	if (text!=NULL)
		result=misc_str_to_val(&value,text,10,bSigned);
	if (lpTranslated!=NULL)
		*lpTranslated=result;
	return value;
}


static UINT WINAPI IsDlgButtonChecked(HWND hDlg,INT nIDButton)
{
	g_debug("IsDlgButtonChecked");
	return SendMessageA(GetDlgItem(hDlg,nIDButton),BM_GETCHECK,0,0);
}


static LONG WINAPI SendDlgItemMessageA(HWND hDlg,INT nIDDlgItem,
										UINT Msg,WPARAM wParam,LPARAM lParam)
{
	g_debug("SendDlgItemMessageA");
	return SendMessageA(GetDlgItem(hDlg,nIDDlgItem),Msg,wParam,lParam);
}


static BOOL WINAPI SetDlgItemInt(HWND hDlg,INT nIDDlgItem,
													UINT uValue,BOOL bSigned)
{
	gchar *text;
	BOOL fResult;

	g_debug("SetDlgItemInt");
	text=misc_str_from_val(uValue,10,0,bSigned);
	fResult=SendDlgItemMessageA(hDlg,nIDDlgItem,WM_SETTEXT,0,(LPARAM)text);
	g_free(text);
	return fResult;
}


static BOOL WINAPI SetDlgItemTextA(HWND hDlg,INT nIDDlgItem,LPCSTR lpString)
{
	g_debug("SetDlgItemTextA");
	return SendDlgItemMessageA(hDlg,nIDDlgItem,WM_SETTEXT,0,(LPARAM)lpString);
}


/******************************************************************************
*                                                                             *
* åܥå                                                          *
*                                                                             *
******************************************************************************/
#define MB_OK				0x00000000
#define MB_OKCANCEL			0x00000001
#define MB_ABORTRETRYIGNORE	0x00000002
#define MB_YESNOCANCEL		0x00000003
#define MB_YESNO			0x00000004
#define MB_RETRYCANCEL		0x00000005
#define MB_TYPEMASK			0x0000000F
#define MB_DEFBUTTON1		0x00000000
#define MB_DEFBUTTON2		0x00000100
#define MB_DEFBUTTON3		0x00000200
#define MB_DEFBUTTON4		0x00000300
#define MB_DEFMASK			0x00000F00


static BOOL WINAPI MessageBeep(UINT uType)
{
	g_debug("MessageBeep");
	return TRUE;
}


static INT WINAPI MessageBoxA(HWND hWnd,
									LPCSTR lpText,LPCSTR lpCaption,UINT uType)
{
	gint def;

	g_debug("MessageBoxA");
	switch (uType&MB_DEFMASK) {
		case MB_DEFBUTTON2:def=1;break;
		case MB_DEFBUTTON3:def=2;break;
		case MB_DEFBUTTON4:def=3;break;
		default:def=0;
	}
	switch (uType&MB_TYPEMASK) {
		case MB_ABORTRETRYIGNORE:
			switch (misc_message_box(lpCaption,lpText,def,
										"_Abort","_Retry","_Ignore",NULL)) {
				case  1:return IDRETRY;
				case  2:return IDIGNORE;
			}
			return IDABORT;
		case MB_OK:
			misc_message_box(lpCaption,lpText,def,"OK",NULL);
			return IDOK;
		case MB_OKCANCEL:
			return misc_message_box(lpCaption,lpText,def,"OK","Cancel",NULL)>=0
																?IDOK:IDCANCEL;
		case MB_RETRYCANCEL:
			return misc_message_box(lpCaption,lpText,
							def,"_Retry","Cancel",NULL)>=0?IDRETRY:IDCANCEL;
		case MB_YESNO:
			return misc_message_box(lpCaption,lpText,def,"_Yes","_No",NULL)>=0
																?IDYES:IDNO;
		case MB_YESNOCANCEL:
			switch (misc_message_box(lpCaption,lpText,
											def,"_Yes","_No","Cancel",NULL)) {
				case  0:return IDYES;
				case  1:return IDNO;
			}
			return IDCANCEL;
	}
	return IDCANCEL;
}


static INT WINAPI MessageBoxW(HWND hWnd,
								LPCWSTR lpText,LPCWSTR lpCaption,UINT uType)
{
	gchar *text=NULL,*caption=NULL;
	gint leng;
	INT nResult;

	g_debug("MessageBoxW");

	if (lpText!=NULL) {
		leng=iso10646_widechar_to_multibyte(lpText,-1,NULL,-1);
		text=g_malloc(leng*sizeof(gchar));
		iso10646_widechar_to_multibyte(lpText,-1,text,leng);
	}
	if (lpCaption!=NULL) {
		leng=iso10646_widechar_to_multibyte(lpCaption,-1,NULL,-1);
		caption=g_malloc(leng*sizeof(gchar));
		iso10646_widechar_to_multibyte(lpCaption,-1,caption,leng);
	}
	nResult=MessageBoxA(hWnd,text,caption,uType);
	g_free(text);
	g_free(caption);
	return nResult;
}

/******************************************************************************
*                                                                             *
* ʸ                                                                      *
*                                                                             *
******************************************************************************/
static INT WINAPI wsprintfA(LPSTR lpOut,LPCSTR lpFmt,...)
{
	va_list va;

	g_debug("wsprintfA");
	va_start(va,lpFmt);
	vsprintf(lpOut,lpFmt,va);
	va_end(va);
	return g_strlen(lpOut);
}


static INT WINAPI wvsprintfA(LPSTR lpOutput,LPCSTR lpFormat,va_list arglist)
{
	g_debug("wvsprintfA");
	return vsprintf(lpOutput,lpFormat,arglist);
}


/******************************************************************************
*                                                                             *
* Ķ                                                                        *
*                                                                             *
******************************************************************************/
static INT WINAPI GetKeyboardType(INT nTypeFlag)
{
	g_debug("GetKeyboardType");
	return 0;
}


static INT WINAPI GetSystemMetrics(INT nIndex)
{
	g_debug("GetSystemMetrics");
	return 0;
}


/******************************************************************************
*                                                                             *
* إ                                                                      *
*                                                                             *
******************************************************************************/
static BOOL WINAPI WinHelpA(HWND hWndMain,
									LPCSTR lpszHelp,UINT uCommand,DWORD dwData)
{
	g_debug("WinHelpA");
	return FALSE;
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in user32 called");
}


static SymbolInfo symbol_infos[]={
	{"PostMessageA",SendMessageA},
	{"SendMessageA",SendMessageA},

	{"DefWindowProcA",DefWindowProcA},
	{"DestroyWindow",DestroyWindow},
	{"EnableWindow",EnableWindow},
	{"EnumThreadWindows",EnumThreadWindows},
	{"GetFocus",GetFocus},
	{"GetDesktopWindow",GetDesktopWindow},
	{"GetWindowLongA",GetWindowLongA},
	{"GetWindowTextA",GetWindowTextA},
	{"SetFocus",SetFocus},
	{"SetWindowLongA",SetWindowLongA},
	{"SetWindowTextA",SetWindowTextA},
	{"ShowWindow",ShowWindow},

	{"GetClientRect",GetClientRect},
	{"GetWindowRect",GetWindowRect},
	{"IsRectEmpty",IsRectEmpty},
	{"MapWindowPoints",MapWindowPoints},
	{"MoveWindow",MoveWindow},
	{"OffsetRect",OffsetRect},
	{"ScreenToClient",ScreenToClient},
	{"SetWindowPos",SetWindowPos},

	{"BeginPaint",BeginPaint},
	{"EndPaint",EndPaint},
	{"GetDC",GetDC},
	{"InvalidateRect",InvalidateRect},
	{"ReleaseDC",ReleaseDC},

	{"FindResourceExA",user32_FindResourceExA},
	{"FindResourceA",user32_FindResourceA},
	{"FreeResource",user32_FreeResource},
	{"LoadBitmapA",	user32_LoadBitmapA},
	{"LoadResource",user32_LoadResource},
	{"LoadStringA",user32_LoadStringA},
	{"LoadStringW",user32_LoadStringW},
	{"LockResource",user32_LockResource},
	{"SizeofResource",user32_SizeofResource},

	{"CheckDlgButton",CheckDlgButton},
	{"CheckRadioButton",CheckRadioButton},
	{"CreateDialogIndirectParam",DialogBoxIndirectParam},
	{"CreateDialogParamA",DialogBoxParamA},
	{"DialogBoxIndirectParam",DialogBoxIndirectParam},
	{"DialogBoxParamA",DialogBoxParamA},
	{"EndDialog",EndDialog},
	{"GetDlgCtrlID",GetDlgCtrlID},
	{"GetDlgItem",GetDlgItem},
	{"GetDlgItemInt",GetDlgItemInt},
	{"IsDlgButtonChecked",IsDlgButtonChecked},
	{"SendDlgItemMessageA",SendDlgItemMessageA},
	{"SetDlgItemInt",SetDlgItemInt},
	{"SetDlgItemTextA",SetDlgItemTextA},

	{"MessageBeep",MessageBeep},
	{"MessageBoxA",MessageBoxA},
	{"MessageBoxW",MessageBoxW},

	{"wsprintfA",wsprintfA},
	{"wvsprintfA",wvsprintfA},

	{"GetSystemMetrics",GetSystemMetrics},
	{"GetKeyboardType",GetKeyboardType},

	{"WinHelpA",WinHelpA},

	{NULL,UnknownSymbol}
};


SymbolInfo *user32_get_export_symbols(void)
{
	return symbol_infos;
}
