/*
    dllloader
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "winmm.h"
#include <time.h>
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ޥǥ                                                              *
*                                                                             *
******************************************************************************/
static DWORD WINAPI timeGetTime(VOID)
{
	g_debug("timeGetTime");
	return time(NULL)*1000;
}


/******************************************************************************
*                                                                             *
* ɥ饤                                                                    *
*                                                                             *
******************************************************************************/
#define DRV_LOAD			0x0001
#define DRV_ENABLE			0x0002
#define DRV_OPEN			0x0003
#define DRV_CLOSE			0x0004
#define DRV_DISABLE			0x0005
#define DRV_FREE			0x0006
#define DRV_CONFIGURE		0x0007
#define DRV_QUERYCONFIGURE	0x0008
#define DRV_INSTALL			0x0009
#define DRV_REMOVE			0x000A
#define DRV_EXITSESSION		0x000B
#define DRV_EXITAPPLICATION	0x000C
#define DRV_POWER			0x000F
#define DRV_RESERVED		0x0800
#define DRV_USER			0x4000
#define DRVCNF_CANCEL		0x0000
#define DRVCNF_OK			0x0001
#define DRVCNF_RESTART 		0x0002
#define DRVEA_NORMALEXIT  	0x0001
#define DRVEA_ABNORMALEXIT 	0x0002
#define DRV_SUCCESS			0x0001
#define DRV_FAILURE			0x0000


typedef HANDLE HDRVR;


static LONG WINAPI DefDriverProc(DWORD dwDriverId,HDRVR hDrvr,
											UINT msg,LONG lParam1,LONG lParam2)
{
	g_debug("DefDriverProc");
	switch(msg) {
		case DRV_LOAD:
		case DRV_FREE:
		case DRV_ENABLE:
		case DRV_DISABLE:
			return 1;
		case DRV_OPEN:
		case DRV_CLOSE:
		case DRV_QUERYCONFIGURE:
			return 0;
		case DRV_CONFIGURE:
			misc_message_box("Wine Driver","Driver isn't configurable !",
																0,"OK",NULL);
			return 0;
		case DRV_INSTALL:
		case DRV_REMOVE:
			return DRV_SUCCESS;
	}
	return 0;
}


HMODULE GetDriverModuleHandle(HDRVR hdrvr)
{
	g_debug("GetDriverModuleHandle");
	return hdrvr;
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in winmm called");
}


static SymbolInfo symbol_infos[]={
	{"timeGetTime",timeGetTime},
	{"DefDriverProc",DefDriverProc},
	{"GetDriverModuleHandle",GetDriverModuleHandle},
	{NULL,UnknownSymbol}
};


SymbolInfo *winmm_get_export_symbols(void)
{
	return symbol_infos;
}
