/*
    misc
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_H__
#define __MISC_H__


#include "common.h"


#define misc_iskanji(ch) (((ch)&0x80)!=0)


#ifdef __cplusplus
extern "C" {
#endif


/*	åܥåɽ
	title,ȥ
	 text,ʸ
	  def,ǥեȤΥܥ
	  ...,ܥΥ٥
	  RET,줿ܥ(-1:󥻥)										*/
gint misc_message_box(const gchar *title,const gchar *text,const gint def,...);


/*	ե¸߳ǧ
	file,ե̾
	 RET,TRUE:¸ߤ,FALSE:¸ߤʤ										*/
gboolean misc_isfile(const gchar *file);


/*	եΥեѥ
	file,ե̾
	 RET,եѥ															*/
gchar *misc_get_full_path(const gchar *file);


/*	Сꤹ
	   scroll,륦å
	     func,ʥؿ
	func_data,ǡ
	      min,Ǿ
	      max,
	     page,ڡ
	      pos,															*/
void misc_set_scroll_bar(GtkWidget *scroll,
				GtkSignalFunc func,gpointer func_data,
				const gint min,const gint max,const gint page,const gint pos);


/*	WindowƤ򥹥뤹
	widget,å
	    dx,Xΰư
	    dy,Yΰư
	     x,뤹ϰϤαXɸ
	     y,뤹ϰϤαYɸ
	 width,뤹ϰϤ
	height,뤹ϰϤι⤵											*/
void misc_scroll_window(GtkWidget *widget,const gint dx,const gint dy,
				const gint x,const gint y,const gint width,const gint height);


/*	͢ʸ
	value,
	radix,
	 wide,
	 flag,TRUE:椢,FALSE:ʤ
	  RET,ʸ															*/
gchar *misc_str_from_val(const gint value,const gint radix,const gint wide,
														const gboolean flag);


/*	ʸ󢪿
	value,
	  str,ʸ
	radix,
	 flag,TRUE:椢,FALSE:ʤ
	  RET,TRUE:ｪλ,FALSE:顼										*/
gboolean misc_str_to_val(gint *value,const gchar *str,const gint radix,
														const gboolean flag);


/*	͢ʸ
	 value,
	divide,
	   RET,ʸ															*/
gchar *misc_str_from_float(const gint value,const gint divide);


/*	ʸ󢪿
	 value,
	divide,
	  text,ʸ
	   RET,TRUE:ｪλ,FALSE:顼										*/
gboolean misc_str_to_float(gint *value,gint *divide,const gchar *text);


/*	ʸ
	array,
	 size,Хȿ
	radix,
	 wide,
	 flag,TRUE:椢,FALSE:ʤ
	  RET,ʸ															*/
gchar *misc_str_from_array(const guint8 *array,const gint size,
						const gint radix,const gint wide,const gboolean flag);


/*	ʸ󢪿
	 size,Хȿ
	 text,ʸ
	radix,
	 flag,TRUE:椢,FALSE:ʤ
	  RET,															*/
guint8 *misc_str_to_array(gint *size,const gchar *text,
										const gint radix,const gboolean flag);


#ifdef __cplusplus
}
#endif
#endif
