/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "version.h"
#include "misc/license.h"
#include <gdk/gdkkeysyms.h>


/******************************************************************************
*                                                                             *
* Сؿ                                                        *
*                                                                             *
******************************************************************************/
#ifdef USE_GTK2
/* ĥ꡼ӥ塼˴ */
static void
version_dialog_changed (GtkTreeSelection *select, GtkWidget *button)
{
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeView *tview;
	IcmObject *icm_object = NULL;

	if (gtk_tree_selection_get_selected (select, &model, &iter))
		gtk_tree_model_get (model, &iter, 2, &icm_object, -1);
	tview = gtk_tree_selection_get_tree_view (select);
	g_object_set_data (G_OBJECT (tview), "user_data", icm_object);
	gtk_widget_set_sensitive (button, icm_object != NULL);
}


static void
version_dialog_row_deleted (GtkTreeModel *model, GtkTreePath *path,
															gpointer user_data)
{
	GtkTreeIter iter;
	IcmObject *icm_object;

	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, 2, &icm_object, NULL);
	if (icm_object != NULL)
		icm_close (icm_object);
}


#else /* not USE_GTK2 */
/* ĥ꡼ */
static void version_dialog_tree_select_row(GtkCTree *ctree,
							GtkCTreeNode *node,gint column,GtkWidget *button)
{
	IcmObject *icm_object;

	icm_object=gtk_ctree_node_get_row_data(ctree,node);
	gtk_object_set_user_data(GTK_OBJECT(ctree),icm_object);
	gtk_widget_set_sensitive(button,icm_object!=NULL);
}


/* ĥ꡼ */
static void version_dialog_tree_unselect_row(GtkCTree *ctree,
							GtkCTreeNode *node,gint column,GtkWidget *button)
{
	gtk_object_set_user_data(GTK_OBJECT(ctree),NULL);
	gtk_widget_set_sensitive(button,FALSE);
}


/* ĥ꡼˴ */
static void version_dialog_destroy(GtkWidget *widget,gpointer user_data)
{
	gint i;
	GtkCTreeNode *node;
	IcmObject *icm_object;

	for (i=0;(node=gtk_ctree_node_nth(GTK_CTREE(widget),i))!=NULL;i++)
		if ((icm_object=gtk_ctree_node_get_row_data(GTK_CTREE(widget),
																node))!=NULL)
			icm_close(icm_object);
}
#endif /* not USE_GTK2 */


/* Aboutܥ󤬲줿 */
static void version_dialog_clicked(GtkWidget *widget,GtkWidget *ctree)
{
	icm_dialog_about(gtk_object_get_user_data(GTK_OBJECT(ctree)));
}


/* 饸ܥѹ줿 */
static void
version_dialog_toggled (GtkWidget *widget, GtkWidget *widgets[])
{
	gtk_widget_show (widgets[0]);
	gtk_widget_hide (widgets[1]);
	gtk_widget_hide (widgets[2]);
}


/* ESC줿 */
static gboolean version_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


void version_dialog(void)
{
	gchar *str[2];
	gint i,length;
	guint key;
	GList *glist;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkAccelGroup *accel;
	GtkWidget *button0, *button1, *ctree, *text0, *text1;
	GtkWidget *radio0, *radio1, *radio2;
	GtkWidget *dialog, *scroll0, *scroll1, *scroll2, *hbox0, *hbox1, *vbox;
	GtkWidget *widget0[3], *widget1[3], *widget2[3];
#ifdef USE_GTK2
	GtkTextBuffer *buffer;
	GtkTreeIter iter,iter_parent;
	GtkTreeSelection *select;
	GtkTreeStore *store;
	GtkTreeViewColumn *column;
#else /* not USE_GTK2 */
	GtkCTreeNode *parent,*node;
#endif /* not USE_GTK2 */
	IcmObject *icm_object;
	IcmInfo icm_info;
const static gchar *authors =
"Main Program :\n"
"    Kazuki IWAMOTO\n"
"Native Codec Program :\n"
"    midori\n"
"Document :\n"
"\n"
"Logo :\n"
"\n"
"Translate :\n"
"\n"
"dllloader :\n"
"    Hiroshi Takekawa\n"
"Special Thanks :\n"
"    Takuro Ashie\n"
"    ryoma\n"
"    And all Video maid users";
/* XPM */
static gchar *vmaid_xpm[] = {
"32 32 16 1",
" 	c None",
".	c #000000",
"+	c #800000",
"@	c #008000",
"#	c #808000",
"$	c #000080",
"%	c #800080",
"&	c #008080",
"*	c #808080",
"=	c #C0C0C0",
"-	c #FF0000",
";	c #00FF00",
">	c #FFFF00",
",	c #0000FF",
"'	c #FF00FF",
")	c #00FFFF",
"                                ",
"                                ",
"++++++++++++++++++++++++++++++++",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
"++++++++++++++++++++++++++++++++",
". . + . . . . . . . . . . .+. . ",
" . .+. . . . . ' . . . . . + . .",
". . + . . . . ''  . . . . .+. . ",
" . .+. . . . ''' . . . . . + . .",
". . + . . .  '''      . . .+. . ",
" . .+. . -  '''',,,,,, . . + . .",
". . + .  ---'''',,,,, . . .+. . ",
" . .+. .  ----'',,,) . . . + . .",
". . + . . -----',)))  . . .+. . ",
" . .+. . . --->;)))))  . . + . .",
". . + . .  ->>>;;)))) . . .+. . ",
" . .+. .  >>>>>;;;;))) . . + . .",
". . + .  >>>>>>;;;;  )  . .+. . ",
" . .+. .       ;;; .   . . + . .",
". . + . . . .  ;;;  . . . .+. . ",
" . .+. . . . . ;;  . . . . + . .",
". . + . . . .  ;  . . . . .+. . ",
" . .+. . . . .   . . . . . + . .",
"++++++++++++++++++++++++++++++++",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
"++++++++++++++++++++++++++++++++",
"                                ",
"                                "};

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),_("About Video maid"));
	gtk_window_set_default_size (GTK_WINDOW (dialog),
					gdk_screen_width () * 2 / 3, gdk_screen_height () * 2 / 3);
	gtk_signal_connect(GTK_OBJECT(dialog),"key-press-event",
							GTK_SIGNAL_FUNC(version_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(dialog),accel);
	/* ܥ */
	button0=gtk_button_new_with_label("");
	button1=gtk_button_new_with_label(_("OK"));
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button0)->child),
															_("_About..."));
	gtk_widget_add_accelerator(button0,"clicked",accel,key,GDK_MOD1_MASK,0);
	/* 륦ɥ */
	scroll0 = gtk_scrolled_window_new (NULL, NULL);
	scroll1 = gtk_scrolled_window_new (NULL, NULL);
	scroll2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll0),
								GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll1),
								GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll2),
								GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#ifdef USE_GTK2
	/* ƥ */
	text0 = gtk_text_view_new ();
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text0));
	gtk_text_buffer_set_text (buffer, gnu_gpl, -1);
	gtk_text_view_set_editable (GTK_TEXT_VIEW (text0), FALSE);
	text1 = gtk_text_view_new ();
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text1));
	gtk_text_buffer_set_text (buffer, authors, -1);
	gtk_text_view_set_editable (GTK_TEXT_VIEW (text1), FALSE);
	/* ĥ꡼ӥ塼 */
	store = gtk_tree_store_new (3,
								G_TYPE_STRING,
								G_TYPE_STRING,
								G_TYPE_POINTER);
	gtk_tree_store_append (store, &iter_parent, NULL);
	gtk_tree_store_set (store, &iter_parent,	0, _("Video Compressor"),
												1, NULL,
												2, NULL,
												-1);
	glist = icm_get_handler_list ();
	if (glist != NULL)
	  {
		length = g_list_length (glist);
		for (i = 0; i < length; i++)
		  {
			icm_object = icm_open ((guint32)g_list_nth_data (glist, i),
															ICM_MODE_QUERY);
			if (icm_object != NULL)
			  {
				if (icm_get_info (icm_object, &icm_info))
				  {
					switch (icm_info.attribute)
					  {
						case ICM_ATTR_NATIVE:
							str[1] = _("Video maid Native");
							break;
						case ICM_ATTR_WIN32:
							str[1] = _("Win32 Emulation");
							break;
						default:
							str[1] = _("Unknown");
					  }
					gtk_tree_store_append (store, &iter, &iter_parent);
					gtk_tree_store_set (store, &iter,	0, icm_info.name,
														1, str[1],
														2, NULL,
														-1);
					g_free (icm_info.name);
					if (icm_is_dialog_about (icm_object))
						gtk_tree_store_set (store, &iter, 2, icm_object, -1);
					else
						icm_close (icm_object);
				  }
				else
				  {
					icm_close (icm_object);
				  }
			  }
		  }
		g_list_free (glist);
	  }
	ctree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
	str[0] = _("Name");
	str[1] = _("Attribute");
	for (i = 0; i < 2; i++)
	  {
		column = gtk_tree_view_column_new_with_attributes (str[i],
							gtk_cell_renderer_text_new (), "text", 0, NULL);
		gtk_tree_view_column_set_resizable (column, TRUE);
		gtk_tree_view_append_column (GTK_TREE_VIEW (ctree), column);
	  }
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ctree));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
								G_CALLBACK (version_dialog_changed), button0);
	g_signal_connect (G_OBJECT (store), "row-deleted",
								G_CALLBACK (version_dialog_row_deleted), NULL);
	g_object_unref (G_OBJECT (store));
#else /* not USE_GTK2 */
	/* ƥ */
  	text0 = gtk_text_new (gtk_scrolled_window_get_hadjustment
											(GTK_SCROLLED_WINDOW (scroll0)),
							gtk_scrolled_window_get_vadjustment
											(GTK_SCROLLED_WINDOW (scroll0)));
	gtk_text_freeze (GTK_TEXT (text0));
	gtk_text_insert (GTK_TEXT (text0),
								NULL, NULL, NULL, gnu_gpl, g_strlen (gnu_gpl));
	gtk_text_thaw (GTK_TEXT (text0));
  	text1 = gtk_text_new (gtk_scrolled_window_get_hadjustment
											(GTK_SCROLLED_WINDOW (scroll1)),
							gtk_scrolled_window_get_vadjustment
											(GTK_SCROLLED_WINDOW (scroll1)));
	gtk_text_freeze (GTK_TEXT (text1));
	gtk_text_insert (GTK_TEXT (text1),
								NULL, NULL, NULL, authors, g_strlen (authors));
	gtk_text_thaw (GTK_TEXT (text1));
	/* ĥ꡼ */
	str[0] = _("Name");
	str[1] = _("Attribute");
	ctree = gtk_ctree_new_with_titles (2, 0, str);
	gtk_clist_column_titles_show(GTK_CLIST(ctree));
	gtk_clist_column_titles_passive(GTK_CLIST(ctree));
	str[0] = _("Video Compressor");
	str[1] = "";
	parent = gtk_ctree_insert_node (GTK_CTREE (ctree), NULL, NULL,
								str, 0, NULL, NULL, NULL, NULL, FALSE, TRUE);
	if ((glist=icm_get_handler_list())!=NULL) {
		length=g_list_length(glist);
		for (i=0;i<length;i++)
			if ((icm_object=icm_open((guint32)g_list_nth_data(glist,i),
													ICM_MODE_QUERY))!=NULL) {
				if (icm_get_info(icm_object,&icm_info)) {
					str[0] = icm_info.name;
					switch (icm_info.attribute) {
						case ICM_ATTR_NATIVE:
							str[1] = _("Video maid Native");
							break;
						case ICM_ATTR_WIN32:
							str[1] = _("Win32 Emulation");
							break;
						default:
							str[1] = _("Unknown");
					}
					node = gtk_ctree_insert_node (GTK_CTREE (ctree),
								parent, NULL,
								str, 0, NULL, NULL, NULL, NULL, TRUE, FALSE);
					g_free(icm_info.name);
					if (icm_is_dialog_about(icm_object))
						gtk_ctree_node_set_row_data(GTK_CTREE(ctree),node,
																icm_object);
					else
						icm_close(icm_object);
				} else {
					icm_close(icm_object);
				}
			}
		g_list_free(glist);
	}
	gtk_clist_columns_autosize(GTK_CLIST(ctree));
	gtk_signal_connect(GTK_OBJECT(ctree),"tree-select-row",
					GTK_SIGNAL_FUNC(version_dialog_tree_select_row),button0);
	gtk_signal_connect(GTK_OBJECT(ctree),"tree-unselect-row",
					GTK_SIGNAL_FUNC(version_dialog_tree_unselect_row),button0);
	gtk_signal_connect(GTK_OBJECT(ctree),"destroy",
								GTK_SIGNAL_FUNC(version_dialog_destroy),NULL);
	gtk_object_set_user_data(GTK_OBJECT(ctree),NULL);
#endif /* not USE_GTK2 */
	/* ܥ */
	gtk_signal_connect (GTK_OBJECT (button0), "clicked",
							GTK_SIGNAL_FUNC (version_dialog_clicked), ctree);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
					GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(dialog));
	gtk_widget_set_sensitive(button0,FALSE);
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* 륦ɥ */
	gtk_container_add (GTK_CONTAINER (scroll0), text0);
	gtk_container_add (GTK_CONTAINER (scroll1), text1);
	gtk_container_add (GTK_CONTAINER (scroll2), ctree);
	/* 饸ܥ */
	vbox = gtk_vbox_new (FALSE, SPACING);
	gtk_box_pack_start (GTK_BOX (vbox), scroll2, TRUE, TRUE, 0);
	hbox0 = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_end (GTK_BOX (hbox0), button0, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
	widget0[0] = widget1[2] = widget2[1] = scroll0;
	widget0[1] = widget1[0] = widget2[2] = scroll1;
	widget0[2] = widget1[1] = widget2[0] = vbox;
	radio0 = gtk_radio_button_new_with_label (NULL, "");
	radio1 = gtk_radio_button_new_with_label_from_widget
											(GTK_RADIO_BUTTON (radio0), "");
	radio2 = gtk_radio_button_new_with_label_from_widget
											(GTK_RADIO_BUTTON (radio1), "");
	key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (radio0)->child),
																_("_License"));
	gtk_widget_add_accelerator (radio0, "clicked", accel, key,
															GDK_MOD1_MASK, 0);
	key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (radio1)->child),
																_("_Authors"));
	gtk_widget_add_accelerator (radio1, "clicked", accel, key,
															GDK_MOD1_MASK, 0);
	key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (radio2)->child),
																_("_Codecs"));
	gtk_widget_add_accelerator (radio2, "clicked", accel, key,
															GDK_MOD1_MASK, 0);
	gtk_signal_connect (GTK_OBJECT (radio0), "toggled",
							GTK_SIGNAL_FUNC (version_dialog_toggled), widget0);
	gtk_signal_connect (GTK_OBJECT (radio1), "toggled",
							GTK_SIGNAL_FUNC (version_dialog_toggled), widget1);
	gtk_signal_connect (GTK_OBJECT (radio2), "toggled",
							GTK_SIGNAL_FUNC (version_dialog_toggled), widget2);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio0), TRUE);
	/* ԥޥå */
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&mask,NULL,vmaid_xpm);

	/* ե졼ȥܥå */
	vbox = gtk_vbox_new (FALSE, SPACING);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
	hbox0 = gtk_hbox_new (FALSE, SPACING);
#ifdef USE_GTK2
	gtk_box_pack_start (GTK_BOX (hbox0),
					gtk_image_new_from_pixmap (pixmap, mask), FALSE, FALSE, 0);
#else /* not USE_GTK2 */
	gtk_box_pack_start (GTK_BOX (hbox0),
							gtk_pixmap_new (pixmap, mask), FALSE, FALSE, 0);
#endif /* not USE_GTK2 */
	gtk_box_pack_start (GTK_BOX (hbox0),
				gtk_label_new (VMAID_VERSION_NOTICE"\n"VMAID_COPYRIGHT_NOTICE),
															FALSE, FALSE, 0);
	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox1), hbox0, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox1, FALSE, FALSE, 0);
	hbox0 = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox0), widget0[0], TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hbox0), widget0[1], TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hbox0), widget0[2], TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox0, TRUE, TRUE, 0);
	hbox0 = gtk_hbox_new (FALSE, SPACING);
	gtk_box_pack_start (GTK_BOX (hbox0), radio0, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox0), radio1, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox0), radio2, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (hbox0), button1, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (dialog), vbox);

	/* ɽ */
	gtk_widget_grab_focus(button1);

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_widget_hide (widget0[1]);
	gtk_widget_hide (widget0[2]);
	gtk_main();
}
