/*
    avicore
    copyright (c) 2000-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "avibase.h"
#include "avifmt.h"
#include "misc/fileio.h"


/******************************************************************************
*                                                                             *
* ¸ؿ()                                                            *
*                                                                             *
******************************************************************************/
#define AVI_HEADERSIZE 2048
#define AVI_ALIGNSIZE (AVI_HEADERSIZE * 8)
#define AVI_RIFFSIZE (1024 * 1024 * 1024)


/*	¸ѤΥץ
	avi_save,ץ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_save_free(AviSave *avi_save)
{
	gint i;

	if (avi_save==NULL)
		return FALSE;
	if (avi_save->avi_opt!=NULL) {
		for (i=0;avi_save->avi_opt[i].type!=0;i++) {
			g_free(avi_save->avi_opt[i].param);
			g_free(avi_save->avi_opt[i].bmih);
			g_free(avi_save->avi_opt[i].wfx);
		}
		g_free(avi_save->avi_opt);
	}
	g_free(avi_save);
	return TRUE;
}


typedef struct AviSaveAviStream_Tag {
	gboolean active;		/* TRUE:on,FALSE:off */
	gsize size;				/* ̤줿Ȥκ祵 */
	gsize max;				/* 񤭹󥯤κ祵 */
	gpointer fmt;			/* ȥ꡼Υإå */
	gsize fmt_size;			/* ȥ꡼ΥإåΥ */
	gint pos;				/* ȥ꡼θ߰ */
	gchar *name;			/* ȥ꡼̾ؤΥݥ */
	guint32 fourcc;			/* 4ʸ */
	AviFrame *avi_frame;
	IcmObject *icm_object;
	AviSuperIndexEntry super[(AVI_ALIGNSIZE - sizeof (guint32) * 2 - ASI_SIZE)
																/ ASE_SIZE];
	AviBaseIndexEntry *base;
	gint entries;			/* AviBaseIndexEntryο */
	gint samples;			/* RIFFΥץ */
} AviSaveAviStream;


/*	ե˽񤭹
	      fio,եݥ
	     data,ǡ
	   length,dataΥХȿ
	  samples,ץ
	key_frame,0:ե졼,1:󥭡ե졼,2:ǥ
	    index,AviIndexEntry¤
	  entries,AviIndexEntry¤Το
	     riff,ߤRIFFΥեå
	     movi,ߤmoviΥեå
	   stream,ȥ꡼Υǡ
	  streams,ȥ꡼ο
	  current,ǡ°륹ȥ꡼
	      RET,TRUE:ｪλ,FALSE:顼									*/
static gboolean
avi_save_avi_write (FileIO *fio, gpointer data, gsize length, gint samples,
						gint key_frame, AviIndexEntry **index, gint *entries,
						goffset *riff, goffset *movi,
						AviSaveAviStream *stream, gint streams, gint current)
{
	gint i, j, s, size = -1;
	guint8 *p, *dummy;
	guint32 fcc, cb, type;
	goffset offset;
	AviBaseIndex abi;
	static guint8 dmy = 0;

	if (fio == NULL || index == NULL || riff == NULL || movi == NULL
											|| stream == NULL || streams <= 0)
		return FALSE;
	offset = fileio_seek (fio, 0, FILEIO_SEEK_CUR);
	if (offset == -1)
		return FALSE;
	if (length > 0 && data != NULL)
	  {
		if (current < 0 || streams <current || samples <= 0)
			return FALSE;
		/* 񤭹߸θߤRIFFΥǡ׻ */
		size = offset - *riff - sizeof (guint32) * 2		/* ¸ǡ */
				+ sizeof (guint32)							/* FOURCC */
				+ sizeof (guint32)							/*  */
				+ ((length + 1) & ~1);						/* ǡ */
		/* ƥȥ꡼AviBaseIndexä */
		for (i = 0; i < streams; i++)
			if (stream[i].entries > 0 || i == current)
			  {
				s = sizeof (guint32) * 2 + ABI_SIZE
												+ stream[i].entries * ABE_SIZE;
				if (i == current)
					s += ABE_SIZE;
				if (s % AVI_ALIGNSIZE != 0)
					s = (s / AVI_ALIGNSIZE + 1) * AVI_ALIGNSIZE;
				size += s;
			  }
		/* ǽRIFFʤidx1󥯤ä */
		if (*riff <= 0)
			size += sizeof (guint32) * 2 + (*entries + 1) * AIE_SIZE;
	  }
	if (size < 0 || AVI_RIFFSIZE <= size)
	  {	/* RIFF򹹿 */
		if (*riff <= 0)
		  {	/* ǽRIFF */
			/* ٤ƤΥȥ꡼ϽϤƤ */
			for (i = 0; i < streams; i++)
				if (stream[i].entries <= 0)
					return FALSE;
		  }
		else
		  {
			/* Ǥ1ĤΥȥ꡼ϽϤƤ */
			for (i = 0; i < streams; i++)
				if (stream[i].entries > 0)
					break;
			if (i >= streams)
				return FALSE;
		  }
		/* ix??ν */
		for (i = 0; i < streams; i++)
			if (stream[i].entries > 0)
			  {
				s = stream[i].entries * ABE_SIZE;
				size = sizeof (guint32) * 2 + ABI_SIZE + s;
				if (size % AVI_ALIGNSIZE != 0)
					size = (size / AVI_ALIGNSIZE + 1) * AVI_ALIGNSIZE;
				/* AviSuperIndexEntry */
				for (j = 0, p = (guint8 *)stream[i].super;
						j < (AVI_ALIGNSIZE - sizeof (guint32) * 2 - ASI_SIZE)
												/ ASE_SIZE; j++, p += ASE_SIZE)
					if (ase_get_size (p) == 0)
						break;
				if (j >= (AVI_ALIGNSIZE - sizeof (guint32) * 2 - ASI_SIZE)
																	/ ASE_SIZE)
					return FALSE;
				ase_set_offset (p, offset);
				ase_set_size (p, size);
				ase_set_duration (p, stream[i].samples);
				stream[i].samples = 0;
				/* AviBaseIndex */
				offset += size;
				size -= sizeof (guint32) * 2;
				fcc = GUINT32_TO_LE (make4cc ('i', 'x',
												i / 10 + '0', i % 10 + '0'));
				cb = GUINT32_TO_LE (size);
				abi_set_longs (&abi, 2);
				abi_set_sub_type (&abi, AVI_IDX_SUB_DEFAULT);
				abi_set_type (&abi, AVI_IDX_OF_CHUNKS);
				abi_set_entries (&abi, stream[i].entries);
				abi_set_ckid (&abi, stream[i].fourcc);
				abi_set_offset (&abi, *movi);
				abi_set_reserve (&abi, 0);
				if (fileio_write (fio, &fcc, sizeof (guint32))
															!= sizeof (guint32)
					|| fileio_write (fio, &cb, sizeof (guint32))
															!= sizeof (guint32)
					|| fileio_write (fio, &abi, ABI_SIZE) != ABI_SIZE
					|| fileio_write (fio, stream[i].base, s) != s)
					return FALSE;
				/* ߡ */
				size -= ABI_SIZE + s;
				if (size > 0)
				  {
					dummy = g_malloc0 (size);
					if (fileio_write (fio, dummy, size) != size)
					  {
						g_free (dummy);
						return FALSE;
					  }
					g_free (dummy);
				  }
				stream[i].entries = 0;
			  }
		/* moviΥ */
		cb = GUINT32_TO_LE (offset - *movi - sizeof (guint32) * 2);
		if (fileio_seek (fio, *movi + sizeof (guint32), SEEK_SET) == -1
			|| fileio_write (fio, &cb, sizeof (guint32)) != sizeof (guint32))
			return FALSE;
		if (*riff <= 0)
		  {	/* ǽRIFF */
			/* ǥå */
			s = *entries * AIE_SIZE;
			fcc = GUINT32_TO_LE (CK_ID_AVINEWINDEX);
			cb = GUINT32_TO_LE (s);
			if (*index == NULL || *entries < 0
								|| fileio_seek (fio, 0, FILEIO_SEEK_END) == -1
								|| fileio_write (fio, &fcc, sizeof (guint32))
															!= sizeof (guint32)
								|| fileio_write (fio, &cb, sizeof (guint32))
															!= sizeof (guint32)
								|| fileio_write (fio, *index, s) != s)
				return FALSE;
			offset += sizeof (guint32) * 2 + s;
			g_free (*index);
			*index = NULL;
			*entries = 0;
		  }
		/* RIFFΥ */
		cb = GUINT32_TO_LE (offset - *riff - sizeof (guint32) * 2);
		if (fileio_seek (fio, *riff + sizeof (guint32), SEEK_SET) == -1
			|| fileio_write (fio, &cb, sizeof (guint32)) != sizeof (guint32)
								|| fileio_seek (fio, 0, FILEIO_SEEK_END) == -1)
			return FALSE;
		/* RIFF */
		if (length > 0 && data != NULL)
		  {
			*riff = offset;
			fcc = GUINT32_TO_LE (CK_DEF_RIFF);
			type = GUINT32_TO_LE (CK_FORM_AVIX);
			if (fileio_write (fio, &fcc, sizeof (guint32)) != sizeof (guint32)
				|| fileio_seek (fio, sizeof (guint32), FILEIO_SEEK_CUR) == -1
				|| fileio_write (fio, &type, sizeof (guint32))
														!= sizeof (guint32))
				return FALSE;
			offset += sizeof (guint32) * 3;
			if ((offset + sizeof (guint32) * 3) % AVI_HEADERSIZE != 0)
			  {	/* JUNK */
				size = ((offset + sizeof (guint32) * 5) / AVI_HEADERSIZE + 1)
							* AVI_HEADERSIZE - (offset + sizeof (guint32) * 5);
				fcc = GUINT32_TO_LE (CK_ID_AVIPADDING);
				cb = GUINT32_TO_LE (size);
				dummy = g_malloc0 (size);
				if (fileio_write (fio, &fcc, sizeof (guint32))
															!= sizeof (guint32)
								|| fileio_write (fio, &cb, sizeof (guint32))
															!= sizeof (guint32)
									|| fileio_write (fio, dummy, size) != size)
				  {
					g_free (dummy);
					return FALSE;
				  }
				g_free (dummy);
				offset += sizeof (guint32) * 2 + size;
			  }
			*movi = offset;
			fcc = GUINT32_TO_LE (CK_DEF_LIST);
			type = GUINT32_TO_LE (CK_LIST_AVIMOVIE);
			if (fileio_write (fio, &fcc, sizeof (guint32)) != sizeof (guint32)
				|| fileio_seek (fio, sizeof (guint32), FILEIO_SEEK_CUR) == -1
				|| fileio_write (fio, &type, sizeof (guint32))
														!= sizeof (guint32))
				return FALSE;
			offset += sizeof (guint32) * 3;
		  }
	  }
	/* ǡ񤭲ä */
	if (length >= 0 && data != NULL)
	  {
		/* AviBaseIndexEntry */
		stream[current].base = g_realloc (stream[current].base,
									(stream[current].entries + 1) * ABE_SIZE);
		p = (guint8 *)stream[current].base
										+ stream[current].entries++ * ABE_SIZE;
		abe_set_offset (p, offset + sizeof (guint32) * 2 - *movi);
		abe_set_size (p, length | (key_frame == 1 ? 1 << 31 : 0));
		if (*riff <= 0)
		  {	/* ǽRIFF */
			/* ǥå */
			*index = g_realloc (*index, (*entries + 1) * AIE_SIZE);
			p = (guint8 *)*index + (*entries)++ * AIE_SIZE;
			aie_set_type (p, stream[current].fourcc);
			aie_set_flags (p, key_frame == 0 ? AVI_IF_KEYFRAME : 0);
			aie_set_offset (p, offset - *movi - sizeof (guint32) * 2);
			aie_set_length (p, length);
		  }
		/* ǡ */
		fcc = GUINT32_TO_LE (stream[current].fourcc);
		cb = GUINT32_TO_LE ((length + 1) & ~1);
		if (fileio_write (fio, &fcc, sizeof (guint32)) != sizeof (guint32)
			|| fileio_write (fio, &cb, sizeof (guint32)) != sizeof (guint32)
			|| fileio_write (fio, data, length) != length
			|| (length % 2 != 0
			&& fileio_write (fio, &dmy, sizeof (guint8)) != sizeof (guint8)))
			return FALSE;
		stream[current].samples += samples;
		if (stream[current].max < length)
			stream[current].max = length;
	  }
	return TRUE;
}


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	  avi_opt,ץ
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_save_avi (AviEdit *avi_edit[], const gchar *file, AviOptions *avi_opt,
						gboolean (*func)(gint, gpointer), gpointer user_data)
{
	FileIO *fio;
	gboolean key_frame;		/* TRUE:ե졼,FALSE:󥭡ե졼 */
	gboolean recompress;	/* TRUE:ư,FALSE:ư̤ʤ */
	gint current;			/* Ǥ1ô֤Υե졼ʤȥ꡼ */
	gint longer = 0;		/* Ǥ֤Ĺȥ꡼ */
	gint times;				/* Ǥ1ô֤Υե졼ʤȥ꡼λ */
	gint timer = 0;			/* currentλν񤭹ߤδȤʤ */
	gint streams;			/* ȥ꡼ο */
	gint head;				/* 饤Ȥ줿إåΥ */
	gint header;			/* إåΥ */
	gint i, j, length, samples, audio = 1, video = 1;
	guint8 *p, *q, *data = NULL;
	AviIndexEntry *index = NULL;
	gint entries = 0;		/* AviIndexEntry¤Το */
	BitmapInfoHeader *bmih;
	goffset riff = 0;		/* RIFFΥեå */
	goffset movi;			/* moviΥեå */
	AviSaveAviStream *stream;
	static guint32 fcc0 = GUINT32_TO_LE (CK_DEF_RIFF);
	static guint32 type0 = GUINT32_TO_LE (CK_FORM_AVI);
	static guint32 fcc1 = GUINT32_TO_LE (CK_DEF_LIST);
	static guint32 type1 = GUINT32_TO_LE (CK_LIST_AVIMOVIE);

	if (avi_edit == NULL || file == NULL)
		return FALSE;
	for (streams = 0; avi_edit[streams] != NULL; streams++);
	if (streams <= 0)
		return FALSE;
	if (streams == 1 && avi_type (avi_edit[0]) == AVI_STREAM_AUDIO)
		return avi_save_wave (avi_edit[0], file, func, user_data);
	stream = g_malloc0 (streams * sizeof (AviSaveAviStream));

	/* ȥ꡼̾ */
	for (i = 0; i < streams; i++)
		switch (avi_type (avi_edit[i]))
		  {
			case AVI_STREAM_VIDEO:
				stream[i].name = avi_get_name (avi_edit[i]) !=NULL
										? g_strdup (avi_get_name (avi_edit[i]))
										: g_strdup_printf ("Video #%d", video);
				video++;
				break;
			case AVI_STREAM_AUDIO:
				stream[i].name = avi_get_name (avi_edit[i]) !=NULL
										? g_strdup (avi_get_name (avi_edit[i]))
										: g_strdup_printf ("Audio #%d", audio);
				audio++;
				break;
			default:
				while (i > 0)
					g_free (stream[--i].name);
				g_free (stream);
				return FALSE;
		}

	/* إå׻ */
	header = sizeof (guint32)									/* 'RIFF' */
			+ sizeof (guint32)									/*  */
			+ sizeof (guint32)									/* 'AVI ' */
				+ sizeof (guint32)								/* 'LIST' */
				+ sizeof (guint32)								/*  */
				+ sizeof (guint32)								/* 'hdrl' */
					+ sizeof (guint32)							/* 'avih' */
					+ sizeof (guint32)							/*  */
					+ ((AMH_SIZE + 1) & ~1)						/* ¤ */
					+ sizeof (guint32)							/* 'LIST' */
					+ sizeof (guint32)							/*  */
					+ sizeof (guint32)							/* 'odml' */
						+ sizeof (guint32)						/* 'odmh' */
						+ sizeof (guint32)						/*  */
						+ DML_SIZE								/* ¤ */
				+ sizeof (guint32)								/* 'LIST' */
				+ sizeof (guint32)								/*  */
				+ sizeof (guint32);								/* 'movi' */
	for (i = 0; i < streams; i++)
	  {
		switch (avi_type (avi_edit[i]))
		  {
			case AVI_STREAM_VIDEO:/* ӥǥ */
				if (avi_opt != NULL && avi_opt[i].handler != 0
					&& (stream[i].icm_object = icm_open (avi_opt[i].handler,
													ICM_MODE_COMPRESS)) != NULL
					&& (avi_opt[i].param_size <= 0
							|| icm_set_state (stream[i].icm_object,
									avi_opt[i].param, avi_opt[i].param_size))
					&& icm_compress_frames_info (stream[i].icm_object,
										avi_edit[i]->bmih,
										avi_opt[i].bmih, avi_opt[i].bmih_size,
										avi_opt[i].key_frame,
										avi_opt[i].quality,
										avi_opt[i].data_rate,
										avi_get_rate (avi_edit[i]),
										avi_get_scale (avi_edit[i]))
					&& (stream[i].fmt_size = icm_compress_get_format_size
											(stream[i].icm_object,
											avi_edit[i]->bmih)) >= BMIH_SIZE)
				  {
					/*  */
					stream[i].fmt = g_malloc (stream[i].fmt_size);
					if (!icm_compress_get_format (stream[i].icm_object,
											avi_edit[i]->bmih, stream[i].fmt))
					  {
						g_free (stream[i].fmt);
						stream[i].fmt = NULL;
					  }
					stream[i].fourcc = make4cc (i / 10 + '0',
													i % 10 + '0', 'd', 'c');
				  }
				if (stream[i].fmt == NULL)
				  {
					/* ̤ */
					if (stream[i].icm_object != NULL)
					  {
						icm_close (stream[i].icm_object);
						stream[i].icm_object = NULL;
					  }
					stream[i].fmt_size = bx_header_bytes
										(avi_get_width (avi_edit[i]),
										avi_get_height (avi_edit[i]),
										avi_get_bit_count (avi_edit[i]),
										avi_get_compression (avi_edit[i]), 0);
					stream[i].fmt = g_malloc (stream[i].fmt_size);
					g_memmove (stream[i].fmt, avi_edit[i]->bmih, BMIH_SIZE);
					bmih_set_color_used (stream[i].fmt, 0);
					bmih_set_color_important (stream[i].fmt, 0);
					switch (bmih_get_bit_count (stream[i].fmt))
					  {
						case 1:g_memmove ((guint8 *)stream[i].fmt + BMIH_SIZE,
											rgb2, RGBQUAD_SIZE * 2); break;
						case 4:g_memmove ((guint8 *)stream[i].fmt + BMIH_SIZE,
											rgb16, RGBQUAD_SIZE * 16); break;
						case 8:g_memmove ((guint8 *)stream[i].fmt + BMIH_SIZE,
											rgb256, RGBQUAD_SIZE * 256);
					  }
					stream[i].fourcc = make4cc (i / 10 + '0',
													i % 10 + '0', 'd', 'b');
				  }
				break;
			case AVI_STREAM_AUDIO:/* ǥ */
				stream[i].fmt_size = wf_header_bytes (avi_edit[i]->wfx);
				stream[i].fmt
							= g_memdup (avi_edit[i]->wfx, stream[i].fmt_size);
				stream[i].fourcc = make4cc (i / 10 + '0',
													i % 10 + '0', 'w', 'b');
		  }
		header += sizeof (guint32)								/* 'LIST' */
				+ sizeof (guint32)								/*  */
				+ sizeof (guint32)								/* 'strl' */
					+ sizeof (guint32) 							/* 'strh' */
					+ sizeof (guint32)							/*  */
					+ ((ASH_SIZE + 1) & ~1)						/* ¤ */
					+ sizeof (guint32) 							/* 'strf' */
					+ sizeof (guint32)							/*  */
					+ ((stream[i].fmt_size + 1) & ~1)			/* ¤ */
					+ sizeof (guint32) 							/* 'strn' */
					+ sizeof (guint32)							/*  */
					+ ((g_strlen (stream[i].name) + 2) & ~1)	/* ʸ */
					+ sizeof (guint32) 							/* 'indx' */
					+ sizeof (guint32)							/*  */
					+ AVI_ALIGNSIZE - sizeof (guint32) * 2;		/*  */
	  }
	head = header % AVI_HEADERSIZE != 0
						? ((header + sizeof(guint32) * 2) / AVI_HEADERSIZE + 1)
													* AVI_HEADERSIZE : header;
	movi = head - sizeof (guint32) * 3;

	/* ե򳫤 */
	fio = fileio_open (file, FILEIO_ACCESS_ALL,
									FILEIO_SHARE_READ, FILEIO_MODE_CREATE_NEW);
	if (fio == NULL
		|| fileio_write (fio, &fcc0, sizeof (guint32)) != sizeof (guint32)
		|| fileio_seek (fio, sizeof (guint32), FILEIO_SEEK_CUR) == -1
		|| fileio_write (fio, &type0, sizeof (guint32)) != sizeof (guint32)
		|| fileio_seek (fio, head - sizeof (guint32) * 3,
														FILEIO_SEEK_SET) == -1
		|| fileio_write (fio, &fcc1, sizeof (guint32)) != sizeof (guint32)
		|| fileio_seek (fio, sizeof (guint32), FILEIO_SEEK_CUR) == -1
		|| fileio_write (fio, &type1, sizeof (guint32)) != sizeof (guint32))
	  {
		fileio_close (fio);
		for (i = 0; i < streams; i++)
		  {
			g_free (stream[i].name);
			g_free (stream[i].fmt);
			if (stream[i].icm_object != NULL)
				icm_close (stream[i].icm_object);
		  }
		g_free (stream);
		return FALSE;
	  }

	/* Ǥ1ô֤Υե졼ʤȥ꡼õ */
	for (current = 0; current < streams; current++)
		if (avi_type (avi_edit[current]) == AVI_STREAM_VIDEO)
			break;
	if (current >= streams)
	  {
		/* ӥǥȥ꡼बʤȤ */
		current = -1;
		times = 1000;
	  }
	else
	  {
		for (i = 0; i < streams; i++)
			if (avi_type (avi_edit[i]) == AVI_STREAM_VIDEO
#ifdef G_HAVE_GINT64
					&& (gint64)avi_get_rate (avi_edit[i])
											* avi_get_scale (avi_edit[current])
							< (gint64)avi_get_rate (avi_edit[current])
												* avi_get_scale (avi_edit[i]))
#else /* not G_HAVE_GINT64 */
					&& avi_get_rate (avi_edit[i])
											* avi_get_scale (avi_edit[current])
							< avi_get_rate (avi_edit[current])
												* avi_get_scale (avi_edit[i]))
#endif /* not G_HAVE_GINT64 */
				current = i;
		times = avi_length_time (avi_edit[current])
											/ avi_length (avi_edit[current]);
	  }
	/* Ǥ֤Ĺȥ꡼õ */
	for (i = 1; i < streams; i++)
		if (avi_length_time (avi_edit[longer]) < avi_length_time (avi_edit[i]))
			longer = i;
	/* ե졼 */
	for (i = 0; i < streams; i++)
		if (avi_type (avi_edit[i]) == AVI_STREAM_VIDEO
					&& (stream[i].avi_frame = avi_get_frame_open (avi_edit[i]))
																	== NULL)
		  {
			while (i > 0)
				if (stream[--i].avi_frame != NULL)
					avi_get_frame_close (stream[i].avi_frame);
			fileio_close (fio);
			for (i = 0; i < streams; i++)
			  {
				g_free (stream[i].name);
				g_free (stream[i].fmt);
				if (stream[i].icm_object != NULL)
					icm_close (stream[i].icm_object);
			  }
			g_free (stream);
			return FALSE;
		  }
	while (TRUE)
	  {
		/* ǥå */
		if (func != NULL && !func (stream[longer].pos * 100
								/ avi_length (avi_edit[longer]), user_data))
			break;
		/* ٤ƽϤ齪λ */
		for (i = 0; i < streams; i++)
			if (stream[i].pos < avi_length (avi_edit[i]))
				break;
		if (i >= streams)
			break;
		for (i = 0; i < streams; i++)
		  {
			if (avi_length (avi_edit[i]) <= stream[i].pos)
				continue;
			/* ϥץ׻ */
			samples = MIN (current >= 0
					? i == current ? 1 : avi_time_to_sample (avi_edit[i],
									avi_sample_to_time (avi_edit[current],
									stream[current].pos + 1)) - stream[i].pos
					: avi_time_to_sample (avi_edit[i], timer) - stream[i].pos,
									avi_length (avi_edit[i]) - stream[i].pos);
			if (samples <= 0)
				continue;
			if (avi_type (avi_edit[i]) == AVI_STREAM_VIDEO)
			  {	/* ӥǥ */
				for (j = 0; j < samples; j++)
				  {
					if (stream[i].icm_object == NULL)
					  {
						/* ̤ */
						bmih = avi_get_frame (stream[i].avi_frame,
										stream[i].pos + j,
										bmih_get_width (stream[i].fmt),
										bmih_get_height (stream[i].fmt),
										bmih_get_bit_count (stream[i].fmt));
						if (bmih == NULL)
						  {
							fileio_close (fio);
							for (i = 0; i < streams; i++)
							  {
								g_free (stream[i].name);
								g_free (stream[i].fmt);
								g_free (stream[i].base);
								if (stream[i].active)
									icm_compress_end (stream[i].icm_object);
								if (stream[i].icm_object != NULL)
									icm_close (stream[i].icm_object);
								if (stream[i].avi_frame != NULL)
									avi_get_frame_close (stream[i].avi_frame);
							  }
							g_free (stream);
							g_free (data);
							g_free (index);
							return FALSE;
						  }
						if (!avi_save_avi_write (fio,
									(guint8 *)bmih + bm_header_bytes (bmih),
									bm_image_bytes (bmih), 1, 0,
									&index, &entries, &riff, &movi,
														stream, streams, i))
						  {
							fileio_close (fio);
							for (i = 0; i < streams; i++)
							  {
								g_free (stream[i].name);
								g_free (stream[i].fmt);
								g_free (stream[i].base);
								if (stream[i].active)
									icm_compress_end (stream[i].icm_object);
								if (stream[i].icm_object != NULL)
									icm_close (stream[i].icm_object);
								if (stream[i].avi_frame != NULL)
									avi_get_frame_close (stream[i].avi_frame);
							  }
							g_free (stream);
							g_free (data);
							g_free (index);
							return FALSE;
						  }
					  }
					else
					  {
						/*  */
						recompress = avi_opt[i].recompress;
						key_frame = avi_is_keyframe (avi_edit[i],
															stream[i].pos + j);
						if (!recompress)
						  {
							/* AVIե */
							avi_get_file (avi_edit[i],stream[i].pos + j);
							recompress =
								avi_edit[i]->file->handler
														!= avi_opt[i].handler
								|| bmih_get_size (avi_edit[i]->file->bmih)
										!= bmih_get_size (stream[i].fmt)
								|| bmih_get_width (avi_edit[i]->file->bmih)
										!= bmih_get_width (stream[i].fmt)
								|| bmih_get_height (avi_edit[i]->file->bmih)
										!= bmih_get_height (stream[i].fmt)
								|| bmih_get_planes (avi_edit[i]->file->bmih)
										!= bmih_get_planes (stream[i].fmt)
								|| bmih_get_bit_count (avi_edit[i]->file->bmih)
										!= bmih_get_bit_count (stream[i].fmt)
								|| bmih_get_compression
													(avi_edit[i]->file->bmih)
										!= bmih_get_compression (stream[i].fmt)
								|| (avi_edit[i]->offset == stream[i].pos + j
																&& !key_frame);
						  }
						if (recompress)
						  {
								/* ư */
							if (!stream[i].active)
							  {
								icm_compress_begin (stream[i].icm_object);
								stream[i].active = TRUE;
								stream[i].size = icm_compress_get_size
														(stream[i].icm_object);
							  }
							data = g_realloc (data, stream[i].size);
							if ((bmih = avi_get_frame
									(stream[i].avi_frame,
									stream[i].pos + j,
									avi_get_width (avi_edit[i]),
									avi_get_height (avi_edit[i]),
									avi_get_bit_count (avi_edit[i]))) == NULL
								|| (length = icm_compress
										(stream[i].icm_object,
										&key_frame,
										(guint8 *)bmih + bm_header_bytes(bmih),
										data)) <= 0)
							  {
								fileio_close (fio);
								for (i = 0; i < streams; i++)
								  {
									g_free (stream[i].name);
									g_free (stream[i].fmt);
									g_free (stream[i].base);
									if (stream[i].active)
										icm_compress_end
														(stream[i].icm_object);
									if (stream[i].icm_object != NULL)
										icm_close (stream[i].icm_object);
									if (stream[i].avi_frame != NULL)
										avi_get_frame_close
														(stream[i].avi_frame);
								  }
								g_free (stream);
								g_free (data);
								g_free (index);
								return FALSE;
							  }
						  }
						else
						  {
							/* ư̤ʤ */
							if (stream[i].active)
							  {
								icm_compress_end (stream[i].icm_object);
								stream[i].active = FALSE;
							  }
							length = avi_sample_size (avi_edit[i],
														stream[i].pos + j, 1);
							data = g_realloc (data, length);
							avi_read (avi_edit[i], stream[i].pos, 1, data);
						  }
						if (!avi_save_avi_write (fio, data, length, 1,
												key_frame ? 0 : 1,
												&index, &entries, &riff, &movi,
														stream, streams, i))
						  {
							fileio_close (fio);
							for (i = 0; i < streams; i++)
							  {
								g_free (stream[i].name);
								g_free (stream[i].fmt);
								g_free (stream[i].base);
								if (stream[i].active)
									icm_compress_end (stream[i].icm_object);
								if (stream[i].icm_object != NULL)
									icm_close (stream[i].icm_object);
								if (stream[i].avi_frame != NULL)
									avi_get_frame_close (stream[i].avi_frame);
							  }
							g_free (stream);
							g_free (data);
							g_free (index);
							return FALSE;
						  }
					  }
				  }
			  }
			else
			  {	/* ǥ */
				length = avi_sample_size (avi_edit[i], stream[i].pos, samples);
				data = g_realloc (data, length);
				avi_read (avi_edit[i], stream[i].pos, samples, data);
				if (!avi_save_avi_write (fio, data, length, samples, 2,
												&index, &entries, &riff, &movi,
														stream, streams, i))
				  {
					fileio_close (fio);
					for (i = 0; i < streams; i++)
					  {
						g_free (stream[i].name);
						g_free (stream[i].fmt);
						g_free (stream[i].base);
						if (stream[i].active)
							icm_compress_end (stream[i].icm_object);
						if (stream[i].icm_object != NULL)
							icm_close (stream[i].icm_object);
						if (stream[i].avi_frame != NULL)
							avi_get_frame_close (stream[i].avi_frame);
					  }
					g_free (stream);
					g_free (data);
					g_free (index);
					return FALSE;
				  }
			  }
			if (i != current)
				stream[i].pos += samples;
		  }
		if (current >= 0)
		  {
			stream[current].pos++;
			if (avi_length (avi_edit[current]) <= stream[current].pos)
			  {
				timer = avi_length_time (avi_edit[current]);
				current = -1;
			  }
		  }
		else
		  {
			timer += times;
		  }
	  }
	g_free (data);
	/* ե졼/ */
	for (i = 0; i < streams; i++)
		if ((stream[i].active && !icm_compress_end (stream[i].icm_object))
				| (stream[i].icm_object != NULL
										&& !icm_close (stream[i].icm_object))
				| (stream[i].avi_frame != NULL
								&& !avi_get_frame_close (stream[i].avi_frame)))
		  {
			fileio_close (fio);
			while (++i < streams)
			  {
				if (stream[i].active)
					icm_compress_end (stream[i].icm_object);
				if (stream[i].icm_object != NULL)
					icm_close (stream[i].icm_object);
				if (stream[i].avi_frame != NULL)
					avi_get_frame_close (stream[i].avi_frame);
			  }
			for (i = 0; i < streams; i++)
			  {
				g_free (stream[i].name);
				g_free (stream[i].fmt);
				g_free (stream[i].base);
			  }
			g_free (stream);
			g_free (index);
			return FALSE;
		  }
	/* եʥ饤 */
	if (!avi_save_avi_write (fio, NULL, 0, 0, -1,
						&index, &entries, &riff, &movi, stream, streams, -1))
	  {
		fileio_close (fio);
		for (i = 0; i < streams; i++)
		  {
			g_free (stream[i].name);
			g_free (stream[i].fmt);
			g_free (stream[i].base);
		  }
		g_free (stream);
		g_free (index);
		return FALSE;
	  }
	/* ǤĹӥǥȥ꡼ */
	current = -1;
	for (i = 0;i < streams; i++)
		if (avi_type (avi_edit[i]) == AVI_STREAM_VIDEO
					&& (current == -1 || stream[i].pos > stream[current].pos))
		current = i;
	if (current < 0)
	  {
		fileio_close (fio);
		for (i = 0; i < streams; i++)
		  {
			g_free (stream[i].name);
			g_free (stream[i].fmt);
			g_free (stream[i].base);
		  }
		g_free (stream);
	  }

	/* إåꤹ */
	data = g_malloc0 (head - sizeof (guint32) * 6);
	p = data;

	*(guint32 *)p = GUINT32_TO_LE (CK_DEF_LIST);
	((guint32 *)p)++;											/* 'LIST' */
	*(guint32 *)p = GUINT32_TO_LE (sizeof (guint32)				/* 'hdrl' */
									+ sizeof (guint32)			/* 'avih' */
									+ sizeof (guint32)			/*  */
									+ AMH_SIZE					/* ¤ */
									+ sizeof (guint32)			/* 'LIST' */
									+ sizeof (guint32)			/*  */
									+ sizeof (guint32)			/* 'odml' */
										+ sizeof (guint32)		/* 'odmh' */
										+ sizeof (guint32)		/*  */
										+ DML_SIZE);			/* ¤ */
	for (i = 0; i < streams; i++)
		*(guint32 *)p += GUINT32_TO_LE
				(sizeof (guint32)								/* 'LIST' */
				+ sizeof (guint32)								/*  */
				+ sizeof (guint32)								/* 'strl' */
					+ sizeof (guint32) 							/* 'strh' */
					+ sizeof (guint32)							/*  */
					+ ASH_SIZE									/* ¤ */
					+ sizeof (guint32) 							/* 'strf' */
					+ sizeof (guint32)							/*  */
					+ ((stream[i].fmt_size + 1) & ~1)			/* ¤ */
					+ sizeof (guint32) 							/* 'strn' */
					+ sizeof (guint32)							/*  */
					+ ((g_strlen (stream[i].name) + 2) & ~1)	/* ʸ */
					+ sizeof (guint32) 							/* 'indx' */
					+ sizeof (guint32)							/*  */
					+ AVI_ALIGNSIZE - sizeof (guint32) * 2);	/*  */
	((guint32 *)p)++;											/*  */
	*(guint32 *)p = GUINT32_TO_LE (CK_LIST_AVIHEADER);
	((guint32 *)p)++;											/* 'hdrl' */
	*(guint32 *)p = GUINT32_TO_LE (CK_ID_AVIMAINHDR);
	((guint32 *)p)++;											/* 'avih' */
	*(guint32 *)p = GUINT32_TO_LE (AMH_SIZE);
	((guint32 *)p)++;											/*  */
	amh_set_micro_sec_per_frame (p,0);
	amh_set_padding_granularity (p, AVI_HEADERSIZE);
	amh_set_flags (p, AVI_FILE_HASINDEX | AVI_FILE_MUSTUSEINDEX);
	amh_set_total_frames (p, stream[current].pos);
	for (i = 0; i < streams; i++)
		if (stream[i].pos > 0)
			amh_set_streams (p, amh_get_streams (p) + 1);
	amh_set_width (p, bmih_get_width (stream[current].fmt));
	amh_set_height (p, bmih_get_height (stream[current].fmt));
	p += AMH_SIZE;												/* ¤ */

	for (i = 0; i < streams; i++)
	  {
		if (stream[i].pos > 0)
		  {
			*(guint32 *)p = GUINT32_TO_LE (CK_DEF_LIST);
			((guint32 *)p)++;									/* 'LIST' */
			*(guint32 *)p = GUINT32_TO_LE
				(sizeof (guint32)								/* 'strl' */
					+ sizeof (guint32) 							/* 'strh' */
					+ sizeof (guint32)							/*  */
					+ ASH_SIZE									/* ¤ */
					+ sizeof (guint32) 							/* 'strf' */
					+ sizeof (guint32)							/*  */
					+ ((stream[i].fmt_size + 1) & ~1)			/* ¤ */
					+ sizeof(guint32) 							/* 'strn' */
					+ sizeof(guint32)							/*  */
					+ ((g_strlen (stream[i].name) + 2) & ~1)	/* ʸ */
					+ sizeof (guint32) 							/* 'indx' */
					+ sizeof (guint32)							/*  */
					+ AVI_ALIGNSIZE - sizeof (guint32) * 2);	/*  */
			((guint32 *)p)++;									/*  */
			*(guint32 *)p = GUINT32_TO_LE (CK_LIST_STREAMHEADER);
			((guint32 *)p)++;									/* 'strl' */

			*(guint32 *)p = GUINT32_TO_LE (CK_ID_STREAMHEADER);
			((guint32 *)p)++;									/* 'strh' */
			*(guint32 *)p = GUINT32_TO_LE (ASH_SIZE);
			((guint32 *)p)++;									/*  */
			ash_set_type (p, avi_type (avi_edit[i]));
			if (avi_type (avi_edit[i]) == AVI_STREAM_VIDEO)
				ash_set_handler (p, avi_opt == NULL || avi_opt[i].handler == 0
												|| stream[i].icm_object == NULL
								? AVI_STREAM_COMP_DIB : avi_opt[i].handler);
			ash_set_priority (p, avi_get_priority (avi_edit[i]));
			ash_set_language (p, avi_get_language (avi_edit[i]));
			ash_set_scale (p, avi_get_scale (avi_edit[i]));
			ash_set_rate (p, avi_get_rate (avi_edit[i]));
			ash_set_length (p, stream[i].pos);
			ash_set_suggested_buffer_size (p, stream[i].max);
			ash_set_quality (p, -1);
			if (avi_type (avi_edit[i]) == AVI_STREAM_VIDEO)
			  {
				ash_set_frame_right (p, avi_get_width (avi_edit[i]));
				ash_set_frame_bottom (p, avi_get_height (avi_edit[i]));
			  }
			p += ASH_SIZE;										/* ¤ */

			*(guint32 *)p = GUINT32_TO_LE (CK_ID_STREAMFORMAT);
			((guint32 *)p)++;									/* 'strf' */
			*(guint32 *)p = GUINT32_TO_LE ((stream[i].fmt_size + 1) & ~1);
			((guint32 *)p)++;									/*  */
			g_memmove (p, stream[i].fmt,stream[i].fmt_size);
			p += (stream[i].fmt_size + 1) & ~1;					/* ¤ */

			*(guint32 *)p = GUINT32_TO_LE (CK_ID_STREAMNAME);
			((guint32 *)p)++;									/* 'strn' */
			*(guint32 *)p
						= GUINT32_TO_LE ((g_strlen (stream[i].name) + 2) & ~1);
			((guint32 *)p)++;									/*  */
			g_memmove (p, stream[i].name, g_strlen (stream[i].name));
			p += (g_strlen (stream[i].name) + 2) & ~1;			/* ʸ */

			*(guint32 *)p = GUINT32_TO_LE (CK_ID_AVISUPERINDEX);
			((guint32 *)p)++;									/* 'indx' */
			*(guint32 *)p = AVI_ALIGNSIZE - sizeof (guint32) * 2;
			((guint32 *)p)++;									/*  */
			for (j = 0, q = (guint8 *)stream[i].super;
						j < (AVI_ALIGNSIZE - sizeof (guint32) * 2 - ASI_SIZE)
												/ ASE_SIZE; j++, q += ASE_SIZE)
				if (ase_get_size (q) == 0)
					break;
			asi_set_longs (p, 4);
			asi_set_sub_type (p, 0);
			asi_set_type (p, AVI_IDX_OF_INDEXES);
			asi_set_entries (p, j);
			asi_set_ckid (p, stream[i].fourcc);
			p += ASI_SIZE;
			g_memmove (p, stream[i].super,
				((AVI_ALIGNSIZE - sizeof (guint32) * 2 - ASI_SIZE) / ASE_SIZE)
																* ASE_SIZE);
			p += AVI_ALIGNSIZE - sizeof (guint32) * 2 - ASI_SIZE;/*  */
		}
		g_free (stream[i].name);
		g_free (stream[i].fmt);
	  }
	*(guint32 *)p = GUINT32_TO_LE (CK_DEF_LIST);
	((guint32 *)p)++;											/* 'LIST' */
	*(guint32 *)p = GUINT32_TO_LE (sizeof (guint32)				/* 'odml' */
									+ sizeof (guint32)			/* 'odmh' */
									+ sizeof (guint32)			/*  */
									+ DML_SIZE);				/* ¤ */
	((guint32 *)p)++;											/*  */
	*(guint32 *)p = GUINT32_TO_LE (CK_LIST_OPENDML);
	((guint32 *)p)++;											/* 'odml' */

	*(guint32 *)p = GUINT32_TO_LE (CK_ID_OPENDML);
	((guint32 *)p)++;											/* 'dmlh' */
	*(guint32 *)p = GUINT32_TO_LE (DML_SIZE);
	((guint32 *)p)++;											/*  */
	dml_set_total_frames (p, stream[current].pos);
	p += DML_SIZE;												/* ¤ */
	g_free (stream);

	if (head - header > 0)
	  {
		*(guint32 *)p = GUINT32_TO_LE (CK_ID_AVIPADDING);
		((guint32 *)p)++;										/* 'JUNK' */
		*(guint32 *)p = GUINT32_TO_LE (head - header - sizeof (guint32) * 2);
	  }															/*  */

	if (fileio_seek (fio, sizeof (guint32) * 3, FILEIO_SEEK_SET) == -1
					|| fileio_write (fio, data, head - sizeof (guint32) * 6)
												!= head - sizeof (guint32) * 6)
	  {
		fileio_close (fio);
		g_free (data);
	  }
	g_free (data);
	return fileio_close (fio);
}


/*	ӥåȥޥåץե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	    start,ǽΥե졼
	      end,ǸΥե졼
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_save_bitmap (AviEdit *avi_edit,
						const gchar *file, const gint start, const gint end,
						gboolean (*func)(gint, gpointer), gpointer user_data)
{
	FileIO *fio;
	gboolean result = TRUE;
	gchar *format, *dir, *name, *ext;
	gint i, s, length;
	AviFrame *avi_frame;
	BitmapFileHeader bmfh;
	BitmapInfoHeader *bmih;

	if (avi_edit == NULL || file == NULL)
		return FALSE;
	dir = g_dirname (file);
	name = g_strdup (g_basename (file));
	for (i = g_strlen (name) - 1; i >= 0; i--)
		if (name[i] == '.')
			break;
	if (i >= 0)
	  {
		ext = g_strdup (name + i);
		name[i] = '\0';
	  }
	else
	  {
		ext = g_strdup ("");
	  }
	for (i = 0, s = end; s != 0; s /= 10)
		i++;
	format = g_strdup_printf ("%s/%s%%0%dd%s", dir, name, i, ext);
	g_free (dir);
	g_free (name);
	g_free (ext);

	g_memset (&bmfh, 0, BMFH_SIZE);
	bmfh_set_type (&bmfh ,0x4d42);
	bmfh_set_size (&bmfh, bm_all_bytes (avi_edit->bmih) + BMFH_SIZE);
	bmfh_set_off_bits (&bmfh, bm_header_bytes (avi_edit->bmih) + BMFH_SIZE);

	if ((avi_frame = avi_get_frame_open (avi_edit)) == NULL)
	  {
		g_free (format);
		return FALSE;
	  }
	for (i = start; i <= end; i++)
	  {
		/* ǥå */
		if (func != NULL
					&& !func ((i - start) * 100/(end - start + 1), user_data))
			break;

		if ((bmih = avi_get_frame (avi_frame, i, avi_get_width (avi_edit),
										avi_get_height (avi_edit),
										avi_get_bit_count (avi_edit))) == NULL)
		  {
			result = FALSE;
			break;
		  }
		bmih_set_x_pixels_per_meter (bmih,
										avi_get_x_pixels_per_meter (avi_edit));
		bmih_set_y_pixels_per_meter (bmih,
										avi_get_y_pixels_per_meter (avi_edit));
		length = bm_all_bytes (bmih);

		name = start == end ? g_strdup (file) : g_strdup_printf (format, i);
		/* ե򳫤 */
		fio = fileio_open (name, FILEIO_ACCESS_ALL,
									FILEIO_SHARE_READ, FILEIO_MODE_CREATE_NEW);
		g_free (name);
		if (fio == NULL)
		  {
			result = FALSE;
			break;
		  }
		if (fileio_write (fio, &bmfh, BMFH_SIZE) != BMFH_SIZE
								|| fileio_write (fio, bmih, length) != length)
		  {
			fileio_close (fio);
			result = FALSE;
			break;
		  }
		if (!fileio_close (fio))
		  {
			result = FALSE;
			break;
		  }
	}
	g_free (format);
	return avi_get_frame_close (avi_frame) && result;
}


/*	WAVEե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_save_wave (AviEdit *avi_edit, const gchar *file,
						gboolean (*func)(gint, gpointer), gpointer user_data)
{
	FileIO *fio;
	gint length, pos = 0, samples, written = 0, header;
	guint8 *p, *data;

	if (avi_edit == NULL || file == NULL)
		return FALSE;
	/* إå׻ */
	header=	sizeof (guint32)									/* 'RIFF' */
			+sizeof (guint32)									/*  */
			+sizeof (guint32)									/* 'WAVE' */
			+sizeof (guint32)									/* 'fmt ' */
			+sizeof (guint32)									/*  */
			+((wf_header_bytes (avi_edit->wfx) + 1) & ~1)		/* ¤ */
			+sizeof (guint32)									/* 'data' */
			+sizeof (guint32);									/*  */
	/* ե򳫤 */
	fio = fileio_open (file, FILEIO_ACCESS_ALL,
									FILEIO_SHARE_READ, FILEIO_MODE_CREATE_NEW);
	if (fio == NULL)
		return FALSE;
	if (fileio_seek (fio, header, FILEIO_SEEK_SET) == -1)
	  {
		fileio_close (fio);
		return FALSE;
	  }
	/* ǡ */
	length = avi_sample_size (avi_edit, 0, 1);
	if (length < 65536)
	  {
		samples = 65536 / length;
		length *= samples;
	  }
	else
	  {
		samples = 1;
	  }
	data = g_malloc (length);
	while (pos < avi_length (avi_edit))
	  {
		/* ǥå */
		if (func != NULL
					&& !func (pos * 100 / avi_length (avi_edit), user_data))
			break;
		if (avi_length (avi_edit) < pos + samples)
		  {
			samples = avi_length (avi_edit) - pos;
			length = avi_sample_size (avi_edit, pos, samples);
		  }
		avi_read (avi_edit, pos, samples, data);
		pos += samples;
		if (fileio_write (fio, data, length) != length)
		  {
			fileio_close (fio);
			g_free (data);
			return FALSE;
		  }
		written += length;
	  }
	if ((written & 1) != 0)
	  {
		data[0] = 0;
		if (fileio_write (fio, data, 1) != 1)
		  {
			fileio_close (fio);
			g_free (data);
			return FALSE;
		  }
	  }
	/* إåꤹ */
	p = data = g_realloc (data, header);
	*(guint32 *)p = GUINT32_TO_LE (CK_DEF_RIFF);
	((guint32 *)p)++;											/* 'RIFF' */
	*(guint32 *)p = GUINT32_TO_LE (header - sizeof (guint32) * 2
													+ ((written + 1) & ~1));
	((guint32 *)p)++;											/*  */
	*(guint32 *)p = GUINT32_TO_LE (CK_FORM_WAVE);
	((guint32 *)p)++;											/* 'WAVE' */
	*(guint32 *)p = GUINT32_TO_LE (CK_ID_WAVEFORMAT);
	((guint32 *)p)++;											/* 'fmt ' */
	*(guint32 *)p = GUINT32_TO_LE (wf_header_bytes (avi_edit->wfx));
	((guint32 *)p)++;											/*  */
	g_memmove (p, avi_edit->wfx, wf_header_bytes (avi_edit->wfx));
	if ((wf_header_bytes (avi_edit->wfx) & 1) != 0)
		p[wf_header_bytes (avi_edit->wfx)] = 0;
	p += (wf_header_bytes (avi_edit->wfx) + 1) & ~1;
	*(guint32 *)p = GUINT32_TO_LE (CK_ID_WAVEDATA);
	((guint32 *)p)++;											/* 'data' */
	*(guint32 *)p = GUINT32_TO_LE (written);					/*  */
	if (fileio_seek (fio, 0 , FILEIO_SEEK_SET) == -1
								|| fileio_write (fio, data, header) != header)
	  {
		fileio_close (fio);
		g_free (data);
		return FALSE;
	  }
	g_free (data);
	return fileio_close (fio);
}


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	 avi_save,ץ
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean
avi_save_with_options (AviEdit *avi_edit[], const gchar *file,
	AviSave *avi_save, gboolean (*func)(gint, gpointer), gpointer user_data)
{
	FileIO *fio;
	gboolean result = FALSE;
	gchar *scenario;
	gint length;

	switch (avi_save->type)
	  {
		case AVI_TYPE_AVI:
			result = avi_save_avi (avi_edit, file,
										avi_save->avi_opt, func, user_data);
			break;
		case AVI_TYPE_BITMAP:
			result = avi_save_bitmap (avi_edit[avi_save->stream], file,
							avi_save->start, avi_save->end, func, user_data);
			break;
		case AVI_TYPE_WAVE:
			result = avi_save_wave(avi_edit[avi_save->stream], file,
															func, user_data);
			break;
		default:
			if ((scenario = avi_to_scenario (avi_edit, FALSE)) != NULL
				&& (fio = fileio_open (file, FILEIO_ACCESS_ALL,
						FILEIO_SHARE_READ, FILEIO_MODE_CREATE_NEW)) != NULL)
			  {
				length = g_strlen (scenario);
				result = (fileio_write (fio, scenario, length) == length)
														& fileio_close (fio);
			  }
			g_free (scenario);
	  }
	return result;
}
