/*
    avicore
    copyright (c) 2000-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __AVIBASE_H__
#define __AVIBASE_H__


#include "avicore.h"


#ifdef __cplusplus
extern "C" {
#endif


/******************************************************************************
*                                                                             *
* Avi                                                                     *
*                                                                             *
******************************************************************************/
extern const guint8 rgb2[8];
extern const guint8 rgb16[64];
extern const guint8 rgb256[1024];


/*	AVIե
	avi_edit,AVIԽϥɥ
	     pos,ץֹ													*/
void avi_get_file(AviEdit *avi_edit,const gint pos);


/*	AVIեʬΥ
	avi_edit,AVIԽϥɥ
	     pos,ץֹ													*/
void avi_split_file(AviEdit *avi_edit,const gint pos);


/******************************************************************************
*                                                                             *
* AVIե빽¤δؿ                                                       *
*                                                                             *
******************************************************************************/
/*	AVIAVIե빽¤Τ
	    file,ե̾
	   param,ȥ꡼ֹ
	    type,streamtypeAUDIO/streamtypeVIDEO
	    rate,졼
	   scale,
	priority,ͥ
	language,
	    name,̾
	     RET,AVIե빽¤,NULL:顼									*/
AviFile *
avi_open_file (const gchar *file, const gint param,
						guint32 *type, guint32 *rate, guint32 *scale,
						guint16 *priority, guint16 *language, gchar **name);


/*	AVIե빽¤Τ
	avi_file,AVIե빽¤
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_release_file(AviFile *avi_file);


#ifdef __cplusplus
}
#endif
#endif
