/*
    avicore
    copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __ICM_H__
#define __ICM_H__


#include "common.h"
#include "bitmap.h"
#include "chunk.h"
#if defined(W32CODECDIR) || defined(USE_CODEC)
# include "dllloader/pe_image.h"
#endif


#ifdef __cplusplus
extern "C" {
#endif

#if defined(W32CODECDIR) || defined(USE_CODEC)

#define DRV_LOAD					0x0001
#define DRV_ENABLE					0x0002
#define DRV_OPEN					0x0003
#define DRV_CLOSE					0x0004
#define DRV_DISABLE					0x0005
#define DRV_FREE					0x0006
#define DRV_CONFIGURE				0x0007
#define DRV_QUERYCONFIGURE			0x0008
#define DRV_INSTALL					0x0009
#define DRV_REMOVE					0x000A
#define DRV_EXITSESSION				0x000B
#define DRV_EXITAPPLICATION			0x000C
#define DRV_POWER					0x000F
#define DRV_RESERVED				0x0800
#define DRV_USER					0x4000

#define DRVCNF_CANCEL				0x0000
#define DRVCNF_OK					0x0001
#define DRVCNF_RESTART				0x0002

#define DRVEA_NORMALEXIT			0x0001
#define DRVEA_ABNORMALEXIT			0x0002

#define DRV_SUCCESS					0x0001
#define DRV_FAILURE					0x0000

#define ICTYPE_VIDEO				make4cc('v','i','d','c')
#define ICTYPE_AUDIO				make4cc('a','u','d','c')

/* error return codes */
#define ICERR_OK					0
#define ICERR_DONTDRAW				1
#define ICERR_NEWPALETTE			2
#define ICERR_GOTOKEYFRAME			3
#define ICERR_STOPDRAWING			4

#define ICERR_UNSUPPORTED			-1
#define ICERR_BADFORMAT				-2
#define ICERR_MEMORY				-3
#define ICERR_INTERNAL				-4
#define ICERR_BADFLAGS				-5
#define ICERR_BADPARAM				-6
#define ICERR_BADSIZE				-7
#define ICERR_BADHANDLE				-8
#define ICERR_CANTUPDATE			-9
#define ICERR_ABORT					-10
#define ICERR_ERROR					-100
#define ICERR_BADBITDEPTH			-200
#define ICERR_BADIMAGESIZE			-201

#define ICERR_CUSTOM				-400

/* ICM Messages */
#define ICM_USER					(DRV_USER+0x0000)

/* ICM driver message range */
#define ICM_RESERVED_LOW			(DRV_USER+0x1000)
#define ICM_RESERVED_HIGH			(DRV_USER+0x2000)
#define ICM_RESERVED				ICM_RESERVED_LOW
#define ICM_GETSTATE				(ICM_RESERVED+0)
#define ICM_SETSTATE				(ICM_RESERVED+1)
#define ICM_GETINFO					(ICM_RESERVED+2)
#define ICM_CONFIGURE				(ICM_RESERVED+10)
#define ICM_ABOUT					(ICM_RESERVED+11)
/* */
#define ICM_GETDEFAULTQUALITY		(ICM_RESERVED+30)
#define ICM_GETQUALITY				(ICM_RESERVED+31)
#define ICM_SETQUALITY				(ICM_RESERVED+32)
#define ICM_SET						(ICM_RESERVED+40)
#define ICM_GET						(ICM_RESERVED+41)

/* 2 constant FOURCC codes */
#define ICM_FRAMERATE				make4cc('F','r','m','R')
#define ICM_KEYFRAMERATE			make4cc('K','e','y','R')
#define ICM_COMPRESS_GET_FORMAT		(ICM_USER+4)
#define ICM_COMPRESS_GET_SIZE		(ICM_USER+5)
#define ICM_COMPRESS_QUERY			(ICM_USER+6)
#define ICM_COMPRESS_BEGIN			(ICM_USER+7)
#define ICM_COMPRESS				(ICM_USER+8)
#define ICM_COMPRESS_END			(ICM_USER+9)
#define ICM_DECOMPRESS_GET_FORMAT	(ICM_USER+10)
#define ICM_DECOMPRESS_QUERY		(ICM_USER+11)
#define ICM_DECOMPRESS_BEGIN		(ICM_USER+12)
#define ICM_DECOMPRESS				(ICM_USER+13)
#define ICM_DECOMPRESS_END			(ICM_USER+14)
#define ICM_DECOMPRESS_SET_PALETTE	(ICM_USER+29)
#define ICM_DECOMPRESS_GET_PALETTE	(ICM_USER+30)
#define ICM_DRAW_QUERY				(ICM_USER+31)
#define ICM_DRAW_BEGIN				(ICM_USER+15)
#define ICM_DRAW_GET_PALETTE		(ICM_USER+16)
#define ICM_DRAW_START				(ICM_USER+18)
#define ICM_DRAW_STOP				(ICM_USER+19)
#define ICM_DRAW_END				(ICM_USER+21)
#define ICM_DRAW_GETTIME			(ICM_USER+32)
#define ICM_DRAW					(ICM_USER+33)
#define ICM_DRAW_WINDOW				(ICM_USER+34)
#define ICM_DRAW_SETTIME			(ICM_USER+35)
#define ICM_DRAW_REALIZE			(ICM_USER+36)
#define ICM_DRAW_FLUSH				(ICM_USER+37)
#define ICM_DRAW_RENDERBUFFER		(ICM_USER+38)
#define ICM_DRAW_START_PLAY			(ICM_USER+39)
#define ICM_DRAW_STOP_PLAY			(ICM_USER+40)
#define ICM_DRAW_SUGGESTFORMAT		(ICM_USER+50)
#define ICM_DRAW_CHANGEPALETTE		(ICM_USER+51)
#define ICM_GETBUFFERSWANTED		(ICM_USER+41)
#define ICM_GETDEFAULTKEYFRAMERATE	(ICM_USER+42)
#define ICM_DECOMPRESSEX_BEGIN		(ICM_USER+60)
#define ICM_DECOMPRESSEX_QUERY		(ICM_USER+61)
#define ICM_DECOMPRESSEX			(ICM_USER+62)
#define ICM_DECOMPRESSEX_END		(ICM_USER+63)
#define ICM_COMPRESS_FRAMES_INFO	(ICM_USER+70)
#define ICM_SET_STATUS_PROC			(ICM_USER+72)

/* Values for wMode of ICOpen() */
#define ICMODE_COMPRESS				1
#define ICMODE_DECOMPRESS			2
#define ICMODE_FASTDECOMPRESS		3
#define ICMODE_QUERY				4
#define ICMODE_FASTCOMPRESS			5
#define ICMODE_DRAW					8

/* quality flags */
#define ICQUALITY_LOW				0
#define ICQUALITY_HIGH				10000
#define ICQUALITY_DEFAULT			-1

/* ICINFO.dwFlags */
#define VIDCF_QUALITY				0x0001	/* supports quality */
#define VIDCF_CRUNCH				0x0002	/* supports crunching to a frame size */
#define VIDCF_TEMPORAL				0x0004	/* supports inter-frame compress */
#define VIDCF_COMPRESSFRAMES		0x0008	/* wants the compress all frames message */
#define VIDCF_DRAW					0x0010	/* supports drawing */
#define VIDCF_FASTTEMPORALC			0x0020	/* does not need prev frame on compress */
#define VIDCF_FASTTEMPORALD			0x0080	/* does not need prev frame on decompress */
#define VIDCF_QUALITYTIME			0x0040	/* supports temporal quality */

/* Compression stuff */
#define ICCOMPRESS_KEYFRAME			0x00000001

/* Decompression stuff */
#define ICDECOMPRESS_HURRYUP		0x80000000	/* don't draw just buffer (hurry up!) */
#define ICDECOMPRESS_UPDATE			0x40000000	/* don't draw just update screen */
#define ICDECOMPRESS_PREROLL		0x20000000	/* this frame is before real start */
#define ICDECOMPRESS_NULLFRAME		0x10000000	/* repeat last frame */
#define ICDECOMPRESS_NOTKEYFRAME	0x08000000	/* this frame is not a key frame */

typedef BitmapInfoHeader *LPBITMAPINFOHEADER;
#include "dllloader/pshpack1.h"
typedef struct {
	DWORD	dwSize;			/* 00: size */
	DWORD	fccType;		/* 04: type 'vidc' usually */
	DWORD	fccHandler;		/* 08: */
	DWORD	dwVersion;		/* 0c: version of compman opening you */
	DWORD	dwFlags;		/* 10: LOWORD is type specific */
	LRESULT	dwError;		/* 14: */
	LPVOID	pV1Reserved;	/* 18: */
	LPVOID	pV2Reserved;	/* 1c: */
	DWORD	dnDevNode;		/* 20: */
							/* 24: */
} ICOPEN,*PICOPEN,*LPICOPEN;
typedef struct {
	DWORD	dwSize;			/* 00: */
	DWORD	fccType;		/* 04:compressor type     'vidc' 'audc' */
	DWORD	fccHandler;		/* 08:compressor sub-type 'rle ' 'jpeg' 'pcm '*/
	DWORD	dwFlags;		/* 0c:flags LOWORD is type specific */
	DWORD	dwVersion;		/* 10:version of the driver */
	DWORD	dwVersionICM;	/* 14:version of the ICM used */
	/*
	 * under Win32, the driver always returns UNICODE strings.
	 */
	WCHAR	szName[16];			/* 18:short name */
	WCHAR	szDescription[128];	/* 38:long name */
	WCHAR	szDriver[128];		/* 138:driver that contains compressor*/
								/* 238: */
} ICINFO,*PICINFO,*LPICINFO;
typedef struct {
	DWORD				dwFlags;
	LPBITMAPINFOHEADER	lpbiOutput;
	LPARAM				lOutput;
	LPBITMAPINFOHEADER	lpbiInput;
	LPARAM				lInput;
	LONG				lStartFrame;
	LONG				lFrameCount;
	LONG				lQuality;
	LONG				lDataRate;
	LONG				lKeyRate;
	DWORD				dwRate;
	DWORD				dwScale;
	DWORD				dwOverheadPerFrame;
	DWORD				dwReserved2;
	LONG (CALLBACK *GetData)(LPARAM lInput,LONG lFrame,LPVOID lpBits,LONG len);
	LONG (CALLBACK *PutData)(LPARAM lOutput,LONG lFrame,LPVOID lpBits,LONG len);
} ICCOMPRESSFRAMES,*PICCOMPRESSFRAMES,*LPICCOMPRESSFRAMES;
typedef struct {
	DWORD				dwFlags;
	LPBITMAPINFOHEADER	lpbiOutput;
	LPVOID				lpOutput;
	LPBITMAPINFOHEADER	lpbiInput;
	LPVOID				lpInput;
	LPDWORD				lpckid;
	LPDWORD				lpdwFlags;
	LONG				lFrameNum;
	DWORD				dwFrameSize;
	DWORD				dwQuality;
	LPBITMAPINFOHEADER	lpbiPrev;
	LPVOID			lpPrev;
} ICCOMPRESS,*PICCOMPRESS,*LPICCOMPRESS;
typedef struct {
	DWORD				dwFlags;	/* flags (from AVI index...) */
	LPBITMAPINFOHEADER	lpbiInput;	/* BITMAPINFO of compressed data */
	LPVOID				lpInput;	/* compressed data */
	LPBITMAPINFOHEADER	lpbiOutput;	/* DIB to decompress to */
	LPVOID				lpOutput;
	DWORD				ckid;		/* ckid from AVI file */
} ICDECOMPRESS,*PICDECOMPRESS,*LPICDECOMPRESS;
#include "dllloader/poppack.h"


#endif


#define ICM_ATTR_NATIVE				0
#define ICM_ATTR_WIN32				1

#define ICM_FLAG_QUALITY			0x0001
#define ICM_FLAG_CRUNCH				0x0002
#define ICM_FLAG_TEMPORAL			0x0004
#define ICM_FLAG_COMPRESSFRAMES		0x0008
#define ICM_FLAG_DRAW				0x0010
#define ICM_FLAG_FASTTEMPORALC		0x0020
#define ICM_FLAG_FASTTEMPORALD		0x0080
#define ICM_FLAG_QUALITYTIME		0x0040

#define ICM_MODE_COMPRESS			1
#define ICM_MODE_DECOMPRESS			2
#define ICM_MODE_FASTDECOMPRESS		3
#define ICM_MODE_QUERY				4
#define ICM_MODE_FASTCOMPRESS		5
#define ICM_MODE_DRAW				8

#define ICM_DECOMPRESS_HURRYUP		0x80000000
#define ICM_DECOMPRESS_UPDATE		0x40000000
#define ICM_DECOMPRESS_PREROLL		0x20000000
#define ICM_DECOMPRESS_NULLFRAME	0x10000000
#define ICM_DECOMPRESS_NOTKEYFRAME	0x08000000


typedef struct IcmDriver_Tag {
#if defined(W32CODECDIR) || defined(USE_CODEC)
	PE_image *pe;
	LONG WINAPI (*DriverProc)(DWORD dwDriverId,HANDLE hdrvr,
										UINT msg,LONG lParam1,LONG lParam2);
#else
	guint8 dummy;
#endif
} IcmDriver;


typedef struct IcmObject_Tag {
	gint counter;
	guint32 handler;
	gint mode;
	BitmapInfoHeader *bmih_in;
	BitmapInfoHeader *bmih_out;
	gint frame;
	gsize size;
	gint quality;
	gpointer prev;
	gsize prev_size;
	IcmDriver *icm_driver;
#if defined(W32CODECDIR) || defined(USE_CODEC)
	DWORD dwDriverId;
#endif
} IcmObject;


typedef struct IcmInfo_Tag {
	gchar *name;
	guint32 handler;
	guint32	flags;
	guint32 attribute;
} IcmInfo;


/******************************************************************************
*                                                                             *
* ICMޥ                                                                   *
*                                                                             *
******************************************************************************/
/*	Codecλȿ䤹
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
#define icm_ref(icm_object)													\
		((icm_object)!=NULL?((icm_object)->icm_object->counter++,TRUE):FALSE)


/*	Codecλȿ򸺤餹
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
#define icm_unref(icm_object) icm_close(icm_object)


/*	Codec򥳥ԡ
	icm_object,IcmObject
	       RET,IcmObject,NULL:顼										*/
#define icm_dup(icm_object) ((icm_object)!=NULL								\
					?icm_open((icm_object)->handler,(icm_object)->mode):NULL)


/*	Codec4ʸɤ
	icm_object,IcmObject
	       RET,4ʸ,0:顼											*/
#define icm_get_handler(icm_object)											\
								((icm_object)!=NULL?(icm_object)->handler:0)


/******************************************************************************
*                                                                             *
* ICM                                                                   *
*                                                                             *
******************************************************************************/
/*	ICM
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean icm_init(void);


/*	ICMλ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean icm_exit(void);


/******************************************************************************
*                                                                             *
* ICM                                                                     *
*                                                                             *
******************************************************************************/
/*	ϿƤ4ʸɤ
	RET,4ʸɤΥꥹ,NULL:Ͽʤ									*/
GList *icm_get_handler_list(void);


/*	Codec򳫤
	handler,4ʸ
	   mode,⡼
	    RET,IcmObject,NULL:顼											*/
IcmObject *icm_open(const guint32 handler,const gint mode);


/*	CodecĤ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_close(IcmObject *icm_object);


/*	Codecξ
	icm_object,IcmObject
	  icm_info,
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_get_info(IcmObject *icm_object,IcmInfo *icm_info);


/*	ѥ᡼Υ
	icm_object,IcmObject
	       RET,														*/
gsize icm_get_state_size(IcmObject *icm_object);


/*	ѥ᡼
	icm_object,IcmObject
	     param,ѥ᡼
	param_size,ѥ᡼Υ
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_get_state(IcmObject *icm_object,gpointer param,gsize param_size);


/*	ѥ᡼ꤹ
	icm_object,IcmObject
	     param,ѥ᡼
	param_size,ѥ᡼Υ
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_set_state(IcmObject *icm_object,gpointer param,gsize param_size);


/******************************************************************************
*                                                                             *
* ICM                                                               *
*                                                                             *
******************************************************************************/
/*	AboutΥݡȤǧ
	icm_object,IcmObject
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_is_dialog_about(IcmObject *icm_object);


/*	Aboutɽ
	icm_object,IcmObject													*/
void icm_dialog_about(IcmObject *icm_object);


/*	ΥݡȤǧ
	icm_object,IcmObject
	       RET,TRUE:ͭ,FALSE:̵											*/
gboolean icm_is_dialog_configure(IcmObject *icm_object);


/*	ɽ
	icm_object,IcmObject													*/
void icm_dialog_configure(IcmObject *icm_object);


/******************************************************************************
*                                                                             *
* ICM Compress                                                                *
*                                                                             *
******************************************************************************/
/*	̲ǽǧ
	icm_object,IcmObject
	      bmih,̤ӥåȥޥåפΥإå
	       RET,TRUE:ǽ,FALSE:Բǽ										*/
gboolean icm_compress_query(IcmObject *icm_object,
												const BitmapInfoHeader *bmih);


/*	̤ΥǥեȤμ
	icm_object,IcmObject
	       RET,ǥե(0:̤б)											*/
gint icm_compress_get_default_key_frame(IcmObject *icm_object);


/*	̤ΥǥեȤʼ
	icm_object,IcmObject
	       RET,ǥե(-1:̤б)										*/
gint icm_compress_get_default_quality(IcmObject *icm_object);


/*	̸ΥեޥåȤΥ
	icm_object,IcmObject
	      bmih,̤ӥåȥޥåפΥإå
	       RET,Хȿ,0:顼											*/
gsize icm_compress_get_format_size(IcmObject *icm_object,
												const BitmapInfoHeader *bmih);


/*	̸ΥեޥåȤ
	icm_object,IcmObject
	   bmih_in,̤ӥåȥޥåפΥإå
	  bmih_out,̤줿ӥåȥޥåפΥإå
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_compress_get_format(IcmObject *icm_object,
				const BitmapInfoHeader *bmih_in,BitmapInfoHeader *bmih_out);


/*	̸Υǡκ祵
	icm_object,IcmObject
	       RET,Хȿ,0:顼											*/
gsize icm_compress_get_size(IcmObject *icm_object);


/*	̤ꤹ
	icm_object,IcmObject
	   bmih_in,̤ӥåȥޥåפΥإå
	  bmih_out,̤줿ӥåȥޥåפΥإå
	 bmih_size,̤줿ӥåȥޥåפΥإåΥ
	 key_frame,(0:٤ƥե졼)
	   quality,ʼ010000,-1:ǥե
     data_rate,1ô֤Υ(0:̵)
	      rate,졼
	     scale,
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_compress_frames_info(IcmObject *icm_object,
				const BitmapInfoHeader *bmih_in,
				const BitmapInfoHeader *bmih_out,const gsize bmih_size,
				const gint key_frame,const gint quality,const gsize data_rate,
									const guint32 rate,const guint32 scale);


/*	̤򳫻Ϥ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_compress_begin(IcmObject *icm_object);


/*	Ÿλ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_compress_end(IcmObject *icm_object);


/*	̤
	icm_object,IcmObject
	 key_frame,TRUE:ե졼,FALSE:󥭡ե졼
	     input,̤ǡ
	    output,̤줿ǡ
	       RET,ե졼Υ,0:顼									*/
gsize icm_compress(IcmObject *icm_object,
						gboolean *key_frame,gpointer input,gpointer output);


/******************************************************************************
*                                                                             *
* ICM Decompress                                                              *
*                                                                             *
******************************************************************************/
/*	Ÿǽǧ
	icm_object,IcmObject
	     bmih,̤줿ӥåȥޥåפΥإå
	      RET,TRUE:ǽ,FALSE:Բǽ										*/
gboolean icm_decompress_query(IcmObject *icm_object,
												const BitmapInfoHeader *bmih);


/*	ŸΥեޥåȤΥ
	icm_object,IcmObject
	      bmih,̤줿ӥåȥޥåפΥإå
	       RET,Хȿ,0:顼											*/
gsize icm_decompress_get_format_size(IcmObject *icm_object,
												const BitmapInfoHeader *bmih);


/*	ŸΥեޥåȤ
	icm_object,IcmObject
	   bmih_in,̤줿ӥåȥޥåפΥإå
	  bmih_out,Ÿ줿ӥåȥޥåפΥإå
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_get_format(IcmObject *icm_object,
				const BitmapInfoHeader *bmih_in,BitmapInfoHeader *bmih_out);


/*	Ÿ򳫻Ϥ
	icm_object,IcmObject
	      bmih,̤줿ӥåȥޥåפΥإå
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_begin(IcmObject *icm_object,
												const BitmapInfoHeader *bmih);


/*	Ÿλ
	icm_object,IcmObject
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress_end(IcmObject *icm_object);


/*	Ÿ
	icm_object,IcmObject
	     flags,ե饰
	     input,̤줿ǡ
	    output,Ÿ줿ǡ
	       RET,TRUE:ｪλ,FALSE:顼									*/
gboolean icm_decompress(IcmObject *icm_object,
							const guint flags,gpointer input,gpointer output);


#ifdef __cplusplus
}
#endif
#endif
