/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "size.h"
#include <gdk/gdkkeysyms.h>


/******************************************************************************
*                                                                             *
* サイズ変更関数群                                                            *
*                                                                             *
******************************************************************************/
/*  フレームサイズの設定
          view,設定値
         width,幅
        height,高さ
     def_width,デフォルトの幅
    def_height,デフォルトの高さ                                             */
void size_set_scale(const gint view,gint *width,gint *height,
                                    const gint def_width,const gint def_height)
{
    switch (def_width<=0 || def_height<=0?view|4:view) {
        case 0:*width=def_width;  *height=def_height;break;
        case 1:*width=def_width/2;*height=def_height/2;break;
        case 2:*width=def_width/4;*height=def_height/4;break;
        case 3:*width=def_width/8;*height=def_height/8;break;
        case 4:*width=320;        *height=240;return;
        case 5:*width=160;        *height=120;return;
        case 6:*width=80;         *height=60;return;
        case 7:*width=40;         *height=30;return;
    }
    if (*width<1)
        *width=1;
    if (*height<1)
        *height=1;
}


/******************************************************************************
*                                                                             *
* サイズ変更ダイアログ関数群                                                  *
*                                                                             *
******************************************************************************/
static gboolean edit,size_clicked_ok;
static gint def_view;
static GtkWidget *dialog,*button8,*check,*spin0,*spin1;


/* スピンボタンの値が変化した */
static void size_dialog_changed(GtkWidget *widget,SizeDialog *size)
{
    gint width,height;

    if (edit) {
        edit=FALSE;
        width=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
        height=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
        if (size->def_width>0 && size->def_height>0
                && !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check))) {
            /* 縦/横の比率を保持する */
            if (widget==spin0) {
                height=MAX(width*size->def_height/size->def_width,1);
                gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin1),height);
            } else {
                width=MAX(height*size->def_width/size->def_height,1);
                gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin0),width);
            }
        }
        gtk_widget_set_sensitive(button8,0<width && 0<height);
        edit=TRUE;
    }
}


/* OKボタンが押された */
static void size_dialog_clicked_ok(GtkWidget *widget,SizeDialog *size)
{
    if (def_view>0)
        size->view=def_view;
    if (size->def_width>0 && size->def_height>0)
        size->ratio=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
    size->width=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
    size->height=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
    gtk_widget_destroy(dialog);
    size_clicked_ok=TRUE;
}


/* ボタンが押された */
static void size_dialog_clicked_button(GtkWidget *widget,SizeDialog *size)
{
    gint width,height;

    def_view = (gint) g_object_get_data (G_OBJECT (widget), "user_data");
    size_set_scale(def_view,&width,&height,size->def_width,size->def_height);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin0),width);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin1),height);
}


/* スピンボタンでリターンが押された */
static void size_dialog_activate(GtkWidget *widget,SizeDialog *size)
{
    gint width,height;

    width=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
    height=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
    if (0<width && 0<height)
        size_dialog_clicked_ok(widget,size);
}


/* ESCが押された */
static gboolean size_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
                                                            gpointer user_data)
{
    if (event->keyval==GDK_Escape)
        gtk_widget_destroy(widget);
    return FALSE;
}


gboolean size_dialog(SizeDialog *size)
{
    GtkWidget *button0,*button1,*button2,*button3;
    GtkWidget *button4,*button5,*button6,*button7,*button9;
    GtkWidget *label0,*label1,*table,*hbox0,*hbox1,*vbox;

    /* メインウインドウ */
    dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(dialog),_("Size"));
    g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (size_dialog_key_press), NULL);
    g_signal_connect (G_OBJECT (dialog), "destroy", gtk_main_quit, NULL);
    /* ボタン */
    if (size->def_width>0 && size->def_height>0) {
        button0=gtk_button_new_with_label(_("Standard"));
        button1=gtk_button_new_with_label(_("1/2"));
        button2=gtk_button_new_with_label(_("1/4"));
        button3=gtk_button_new_with_label(_("1/8"));
        g_object_set_data (G_OBJECT (button0), "user_data", (gpointer)0);
        g_object_set_data (G_OBJECT (button1), "user_data", (gpointer)1);
        g_object_set_data (G_OBJECT (button2), "user_data", (gpointer)2);
        g_object_set_data (G_OBJECT (button3), "user_data", (gpointer)3);
        g_signal_connect (G_OBJECT (button0), "clicked",
                                G_CALLBACK (size_dialog_clicked_button), size);
        g_signal_connect (G_OBJECT (button1),"clicked",
                                G_CALLBACK (size_dialog_clicked_button), size);
        g_signal_connect (G_OBJECT (button2), "clicked",
                                G_CALLBACK (size_dialog_clicked_button), size);
        g_signal_connect (G_OBJECT (button3), "clicked",
                                G_CALLBACK (size_dialog_clicked_button), size);
        GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
        GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
        GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
        GTK_WIDGET_SET_FLAGS(button3,GTK_CAN_DEFAULT);
    } else {
        button0=button1=button2=button3=NULL;
    }
    button4=gtk_button_new_with_label(_("320x240"));
    button5=gtk_button_new_with_label(_("160x120"));
    button6=gtk_button_new_with_label(_("80x60"));
    button7=gtk_button_new_with_label(_("40x30"));
    button8=gtk_button_new_with_label(_("OK"));
    button9=gtk_button_new_with_label(_("Cancel"));
    g_object_set_data (G_OBJECT (button4), "user_data", (gpointer)4);
    g_object_set_data (G_OBJECT (button5), "user_data", (gpointer)5);
    g_object_set_data (G_OBJECT (button6), "user_data", (gpointer)6);
    g_object_set_data (G_OBJECT (button7), "user_data", (gpointer)7);
    g_signal_connect (G_OBJECT (button4), "clicked",
                                G_CALLBACK (size_dialog_clicked_button), size);
    g_signal_connect (G_OBJECT (button5), "clicked",
                                G_CALLBACK (size_dialog_clicked_button), size);
    g_signal_connect (G_OBJECT (button6), "clicked",
                                G_CALLBACK (size_dialog_clicked_button), size);
    g_signal_connect (G_OBJECT (button7), "clicked",
                                G_CALLBACK (size_dialog_clicked_button), size);
    g_signal_connect (G_OBJECT (button8), "clicked",
                                G_CALLBACK (size_dialog_clicked_ok), size);
    g_signal_connect_swapped (G_OBJECT (button9), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
    GTK_WIDGET_SET_FLAGS(button4,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button5,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button6,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button7,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button8,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button9,GTK_CAN_DEFAULT);
    /* チェックボタン */
    if (size->def_width>0 && size->def_height>0) {
        check = gtk_check_button_new_with_mnemonic (_("_Allow distortion"));
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),size->ratio);
    } else {
        check=NULL;
    }
    /* スピンボタン */
    spin0=gtk_spin_button_new(
        GTK_ADJUSTMENT(gtk_adjustment_new(size->width,1,G_MAXINT,1,5,0)),0,0);
    spin1=gtk_spin_button_new(
        GTK_ADJUSTMENT(gtk_adjustment_new(size->height,1,G_MAXINT,1,5,0)),0,0);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin0),TRUE);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1),TRUE);
    g_signal_connect (G_OBJECT (spin0), "activate",
                                    G_CALLBACK (size_dialog_activate), size);
    g_signal_connect (G_OBJECT (spin1), "activate",
                                    G_CALLBACK (size_dialog_activate), size);
    g_signal_connect (G_OBJECT (spin0), "changed",
                                    G_CALLBACK (size_dialog_changed), size);
    g_signal_connect (G_OBJECT (spin1), "changed",
                                    G_CALLBACK (size_dialog_changed), size);
    /* ラベル */
    label0 = gtk_label_new_with_mnemonic (_("_Width"));
    label1 = gtk_label_new_with_mnemonic (_("_Height"));
    gtk_label_set_mnemonic_widget (GTK_LABEL (label0), spin0);
    gtk_label_set_mnemonic_widget (GTK_LABEL (label1), spin1);
    /* テーブル */
    if (button0!=NULL && button1!=NULL && button2!=NULL && button3!=NULL) {
        table=gtk_table_new(2,4,FALSE);
        gtk_table_attach_defaults(GTK_TABLE(table),button0,0,1,0,1);
        gtk_table_attach_defaults(GTK_TABLE(table),button1,1,2,0,1);
        gtk_table_attach_defaults(GTK_TABLE(table),button2,2,3,0,1);
        gtk_table_attach_defaults(GTK_TABLE(table),button3,3,4,0,1);
        gtk_table_attach_defaults(GTK_TABLE(table),button4,0,1,1,2);
        gtk_table_attach_defaults(GTK_TABLE(table),button5,1,2,1,2);
        gtk_table_attach_defaults(GTK_TABLE(table),button6,2,3,1,2);
        gtk_table_attach_defaults(GTK_TABLE(table),button7,3,4,1,2);
    } else {
        table=gtk_table_new(1,4,FALSE);
        gtk_table_attach_defaults(GTK_TABLE(table),button4,0,1,0,1);
        gtk_table_attach_defaults(GTK_TABLE(table),button5,1,2,0,1);
        gtk_table_attach_defaults(GTK_TABLE(table),button6,2,3,0,1);
        gtk_table_attach_defaults(GTK_TABLE(table),button7,3,4,0,1);
    }

    /* フレームとボックス */
    vbox = gtk_vbox_new (FALSE, SPACING);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
    gtk_box_pack_start(GTK_BOX(vbox),table,FALSE,FALSE,0);

    hbox0 = gtk_hbox_new (FALSE, SPACING);
    gtk_container_set_border_width (GTK_CONTAINER (hbox0), SPACING);
    hbox1=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox1),label0,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox1),spin0,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,0);
    hbox1=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox1),label1,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(hbox1),spin1,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);

    if (check!=NULL)
        gtk_box_pack_start(GTK_BOX(vbox),check,FALSE,FALSE,0);

    hbox0 = gtk_hbox_new (FALSE, SPACING);
    gtk_box_pack_end(GTK_BOX(hbox0),button9,FALSE,FALSE,0);
    gtk_box_pack_end(GTK_BOX(hbox0),button8,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
    gtk_container_add(GTK_CONTAINER(dialog),vbox);

    /* 表示 */
    gtk_widget_set_sensitive(button8,FALSE);
    gtk_widget_grab_focus(button9);

    edit=TRUE;
    def_view=-1;
    size_clicked_ok=FALSE;

    gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
    gtk_grab_add(dialog);
    gtk_widget_show_all(dialog);
    gtk_main();

    return size_clicked_ok;
}
