/*
    avicore
    copyright (c) 2000-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "avibase.h"
#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/******************************************************************************
*                                                                             *
* ¸ؿ()                                                            *
*                                                                             *
******************************************************************************/
#define AVI_HEADERSIZE 2048


/*	ӥåȥޥåץե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	    start,ǽΥե졼
	      end,ǸΥե졼
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_bitmap(AviEdit *avi_edit,
							const gchar *file,const gint start,const gint end,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gboolean result=TRUE;
	gchar *format,*dir,*name,*ext;
	gint i,s,length;
	AviFrame *avi_frame;
	BitmapFileHeader bmfh;
	BitmapInfoHeader *bmih;

	if (avi_edit==NULL || file==NULL)
		return FALSE;
	dir=g_dirname(file);
	name=g_strdup(g_basename(file));
	for (i=g_strlen(name)-1;i>=0;i--)
		if (name[i]=='.')
			break;
	if (i>=0) {
		ext=g_strdup(name+i);
		name[i]='\0';
	} else {
		ext=g_strdup("");
	}
	for (i=0,s=end;s!=0;s/=10)
		i++;
	format=g_strdup_printf("%s/%s%%0%dd%s",dir,name,i,ext);
	g_free(dir);
	g_free(name);
	g_free(ext);

	g_memset(&bmfh,0,BMFH_SIZE);
	bmfh_set_type(&bmfh,0x4d42);
	bmfh_set_size(&bmfh,bm_all_bytes(avi_edit->bmih)+BMFH_SIZE);
	bmfh_set_off_bits(&bmfh,bm_header_bytes(avi_edit->bmih)+BMFH_SIZE);

	if ((avi_frame=avi_get_frame_open(avi_edit))==NULL) {
		g_free(format);
		return FALSE;
	}
	for (i=start;i<=end;i++) {
		/* ǥå */
		if (func!=NULL && !func((i-start)*100/(end-start+1),user_data))
			break;

		if ((bmih=avi_get_frame(avi_frame,i,bmih_get_width(avi_edit->bmih),
								bmih_get_height(avi_edit->bmih),
								bmih_get_bit_count(avi_edit->bmih)))==NULL) {
			result=FALSE;
			break;
		}
		length=bm_all_bytes(bmih);

		name=start==end?g_strdup(file):g_strdup_printf(format,i);
		fd=open(name,O_CREAT|O_EXCL|O_WRONLY,
							S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
		g_free(name);
		if (fd==-1) {
			result=FALSE;
			break;
		}
		if (flock(fd,LOCK_EX)==-1 || write(fd,&bmfh,BMFH_SIZE)!=BMFH_SIZE
											|| write(fd,bmih,length)!=length) {
			close(fd);
			result=FALSE;
			break;
		}
		if (close(fd)!=0) {
			result=FALSE;
			break;
		}
	}
	g_free(format);
	return avi_get_frame_close(avi_frame) && result;
}


/*	WAVEե¸
	 avi_edit,AVIԽϥɥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save_wave(AviEdit *avi_edit,const gchar *file,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gint length,pos=0,samples,written=0,header;
	guint8 *p,*data;

	if (avi_edit==NULL || file==NULL)
		return FALSE;
	/* إå׻ */
	header=	sizeof(guint32)										/* 'RIFF' */
			+sizeof(guint32)									/*  */
			+sizeof(guint32)									/* 'WAVE' */
			+sizeof(guint32)									/* 'fmt ' */
			+sizeof(guint32)									/*  */
			+((wf_header_bytes(avi_edit->wfx)+1)&~1)			/* ¤ */
			+sizeof(guint32)									/* 'data' */
			+sizeof(guint32);									/*  */
	/* ե򳫤 */
	if ((fd=open(file,O_CREAT|O_EXCL|O_WRONLY,
						S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH))==-1)
		return FALSE;
	if (flock(fd,LOCK_EX)==-1 || lseek(fd,header,SEEK_SET)==-1) {
		close(fd);
		return FALSE;
	}
	/* ǡ */
	length=avi_sample_size(avi_edit,0,1);
	if (length<65536) {
		samples=65536/length;
		length*=samples;
	} else {
		samples=1;
	}
	data=g_malloc(length);
	while (pos<avi_edit->length) {
		/* ǥå */
		if (func!=NULL && !func(pos*100/avi_edit->length,user_data))
			break;
		if (avi_edit->length<pos+samples) {
			samples=avi_edit->length-pos;
			length=avi_sample_size(avi_edit,pos,samples);
		}
		avi_read(avi_edit,pos,samples,data);
		pos+=samples;
		if (write(fd,data,length)!=length) {
			close(fd);
			g_free(data);
			return FALSE;
		}
		written+=length;
	}
	if ((written&1)!=0) {
		data[0]=0;
		if (write(fd,data,1)!=1) {
			close(fd);
			g_free(data);
			return FALSE;
		}
	}
	/* إåꤹ */
	p=data=g_realloc(data,header);
	*(guint32 *)p=GUINT32_TO_LE(FOURCC_RIFF);
	((guint32 *)p)++;											/* 'RIFF' */
	*(guint32 *)p=GUINT32_TO_LE(header-sizeof(guint32)*2+((written+1)&~1));
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(formtypeWAVE);
	((guint32 *)p)++;											/* 'WAVE' */
	*(guint32 *)p=GUINT32_TO_LE(formtypeWAVE);
	((guint32 *)p)++;											/* 'fmt ' */
	*(guint32 *)p=GUINT32_TO_LE(wf_header_bytes(avi_edit->wfx));
	((guint32 *)p)++;											/*  */
	g_memmove(p,avi_edit->wfx,wf_header_bytes(avi_edit->wfx));
	if ((wf_header_bytes(avi_edit->wfx)&1)!=0)
		p[wf_header_bytes(avi_edit->wfx)]=0;
	p+=(wf_header_bytes(avi_edit->wfx)+1)&~1;
	*(guint32 *)p=GUINT32_TO_LE(ckidWAVEDATA);
	((guint32 *)p)++;											/* 'data' */
	*(guint32 *)p=GUINT32_TO_LE(written);						/*  */
	if (lseek(fd,0,SEEK_SET)==-1 || write(fd,data,header)!=header) {
		close(fd);
		g_free(data);
		return FALSE;
	}
	g_free(data);
	return close(fd)==0;
}


/*	ե¸
	 avi_edit,AVIԽϥɥؤΥݥ
	     file,ե̾
	     func,Хåؿ
	user_data,ǡ
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean avi_save(AviEdit *avi_edit[],const gchar *file,
							gboolean (*func)(gint,gpointer),gpointer user_data)
{
	int fd;
	gpointer *fmt;		/* ȥ꡼Υإå */
	gint *strf;			/* ȥ꡼ΥإåΥ */
	gchar **name;		/* ȥ꡼̾ؤΥݥ */
	gint current;		/* Ǥ1ô֤Υե졼ʤȥ꡼ */
	gint longer=0;		/* Ǥ֤Ĺȥ꡼ */
	gint times;			/* Ǥ1ô֤Υե졼ʤȥ꡼λ */
	gint timer=0;		/* currentλν񤭹ߤδȤʤ */
	gint streams;		/* ȥ꡼ο */
	gint head,header;	/* 饤Ȥ줿إåΥ,إåΥ */
	gint entries=0;		/* AviIndexEntry¤Το */
	gint i,j,*pos,samples,length,audio=1,video=1;
	guint8 *p,*data=NULL;
	guint32 fourcc,size;
	AviFrame **avi_frame;
	AviIndexEntry *index=NULL;
	BitmapInfoHeader *bmih;
	off_t offset;		/* եΥեå */
	static const guint8 dummy=0;

	if (avi_edit==NULL || file==NULL)
		return FALSE;
	for (streams=0;avi_edit[streams]!=NULL;streams++);
	if (streams<=0)
		return FALSE;
	if (streams==1 && avi_edit[0]->type==streamtypeAUDIO)
		return avi_save_wave(avi_edit[0],file,func,user_data);

	/* ȥ꡼̾ */
	name=g_malloc(streams*sizeof(gchar *));
	for (i=0;i<streams;i++)
		switch (avi_edit[i]->type) {
			case streamtypeAUDIO:
				name[i]=g_strdup_printf("Audio #%d",audio++);
				break;
			case streamtypeVIDEO:
				name[i]=g_strdup_printf("Video #%d",video++);
				break;
			default:
				while (i>0)
					g_free(name[--i]);
				g_free(name);
				return FALSE;
		}

	/* إå׻ */
	header=sizeof(guint32)										/* 'RIFF' */
			+sizeof(guint32)									/*  */
			+sizeof(guint32)									/* 'AVI ' */
				+sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'hdrl' */
					+sizeof(guint32)							/* 'avih' */
					+sizeof(guint32)							/*  */
					+((AMH_SIZE+1)&~1)							/* ¤ */
				+sizeof(guint32)								/* 'JUNK' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32);								/* 'movi' */
	fmt=g_malloc(streams*sizeof(gpointer));
	strf=g_malloc(streams*sizeof(gint));
	for (i=0;i<streams;i++) {
		switch (avi_edit[i]->type) {
			case streamtypeVIDEO:/* ӥǥ */
				strf[i]=bx_header_bytes(bmih_get_width(avi_edit[i]->bmih),
									bmih_get_height(avi_edit[i]->bmih),
									bmih_get_bit_count(avi_edit[i]->bmih),
									bmih_get_compression(avi_edit[i]->bmih),0);
				fmt[i]=g_malloc(strf[i]);
				g_memmove(fmt[i],avi_edit[i]->bmih,BMIH_SIZE);
				bmih_set_color_used(fmt[i],0);
				bmih_set_color_important(fmt[i],0);
				switch (bmih_get_bit_count(fmt[i])) {
					case 1:g_memmove((guint8 *)fmt[i]+BMIH_SIZE,rgb2,
														RGBQUAD_SIZE*2);break;
					case 4:g_memmove((guint8 *)fmt[i]+BMIH_SIZE,rgb16,
														RGBQUAD_SIZE*16);break;
					case 8:g_memmove((guint8 *)fmt[i]+BMIH_SIZE,rgb256,
														RGBQUAD_SIZE*256);
				}
				break;
			case streamtypeAUDIO:/* ǥ */
				strf[i]=wf_header_bytes(avi_edit[i]->wfx);
				fmt[i]=g_memdup(avi_edit[i]->wfx,strf[i]);
		}
		header+=sizeof(guint32)									/* 'LIST' */
				+sizeof(guint32)								/*  */
				+sizeof(guint32)								/* 'strl' */
					+sizeof(guint32) 							/* 'strh' */
					+sizeof(guint32)							/*  */
					+((ASH_SIZE+1)&~1)							/* ¤ */
					+sizeof(guint32) 							/* 'strf' */
					+sizeof(guint32)							/*  */
					+((strf[i]+1)&~1)							/* ¤ */
					+sizeof(guint32) 							/* 'strn' */
					+sizeof(guint32)							/*  */
					+((g_strlen(name[i])+1)&~1);				/* ʸ */
	}
	head=(header/AVI_HEADERSIZE+1)*AVI_HEADERSIZE;

	/* ե򳫤 */
	if ((fd=open(file,O_CREAT|O_EXCL|O_WRONLY,
					S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH))==-1) {
		for (i=0;i<streams;i++) {
			g_free(name[i]);
			g_free(fmt[i]);
		}
		g_free(name);
		g_free(fmt);
		g_free(strf);
		return FALSE;
	}
	if (flock(fd,LOCK_EX)==-1 || lseek(fd,head,SEEK_SET)==-1) {
		close(fd);
		for (i=0;i<streams;i++) {
			g_free(name[i]);
			g_free(fmt[i]);
		}
		g_free(name);
		g_free(fmt);
		g_free(strf);
		return FALSE;
	}
	offset=head;

	/* Ǥ1ô֤Υե졼ʤȥ꡼õ */
	for (current=0;current<streams;current++)
		if (avi_edit[current]->type==streamtypeVIDEO)
			break;
	if (current>=streams) {
		/* ӥǥȥ꡼बʤȤ */
		current=-1;
		times=1000;
	} else {
		for (i=0;i<streams;i++)
			if (avi_edit[i]->type==streamtypeVIDEO
						&& (gint64)avi_edit[i]->rate*avi_edit[current]->scale
						<(gint64)avi_edit[current]->rate*avi_edit[i]->scale)
				current=i;
		times=avi_length_time(avi_edit[current])/avi_length(avi_edit[current]);
	}
	/* Ǥ֤Ĺȥ꡼õ */
	for (i=1;i<streams;i++)
		if (avi_length_time(avi_edit[longer])<avi_length_time(avi_edit[i]))
			longer=i;
	/* ե졼 */
	avi_frame=g_malloc0(streams*sizeof(AviFrame *));
	for (i=0;i<streams;i++)
		if (avi_edit[i]->type==streamtypeVIDEO
					&& (avi_frame[i]=avi_get_frame_open(avi_edit[i]))==NULL) {
			while (i>0)
				if (avi_frame[--i]!=NULL)
					avi_get_frame_close(avi_frame[i]);
			close(fd);
			for (i=0;i<streams;i++) {
				g_free(name[i]);
				g_free(fmt[i]);
			}
			g_free(avi_frame);
			g_free(name);
			g_free(fmt);
			g_free(strf);
			return FALSE;
		}
	pos=g_malloc0(streams*sizeof(gint));
	while (TRUE) {
		/* ǥå */
		if (func!=NULL
				&& !func(pos[longer]*100/avi_edit[longer]->length,user_data))
			break;
		/* ٤ƽϤ齪λ */
		for (i=0;i<streams;i++)
			if (pos[i]<avi_edit[i]->length)
				break;
		if (i>=streams)
			break;
		for (i=0;i<streams;i++)
			if (pos[i]<avi_edit[i]->length) {
				samples=MIN(current>=0
								?i==current?1:avi_time_to_sample(avi_edit[i],
										avi_sample_to_time(avi_edit[current],
														pos[current]+1))-pos[i]
								:avi_time_to_sample(avi_edit[i],timer)-pos[i],
							avi_edit[i]->length-pos[i]);
				if (samples>0) {
					if (avi_edit[i]->type==streamtypeVIDEO) {
						/* ӥǥ */
						for (j=0;j<samples;j++) {
							bmih=avi_get_frame(avi_frame[i],pos[i]+j,
												bmih_get_width(fmt[i]),
												bmih_get_height(fmt[i]),
												bmih_get_bit_count(fmt[i]));
							if (bmih==NULL) {
								close(fd);
								for (i=0;i<streams;i++) {
									g_free(name[i]);
									g_free(fmt[i]);
									if (avi_frame[i]!=NULL)
										avi_get_frame_close(avi_frame[i]);
								}
								g_free(avi_frame);
								g_free(name);
								g_free(fmt);
								g_free(strf);
								g_free(data);
								g_free(index);
								g_free(pos);
								return FALSE;
							}
							length=bm_image_bytes(bmih);
							fourcc=GUINT32_TO_LE(
										make4cc(i/10+'0',i%10+'0','d','b'));
							size=GUINT32_TO_LE(length);
							if (write(fd,&fourcc,sizeof(guint32))
															!=sizeof(guint32)
								|| write(fd,&size,sizeof(guint32))
														!=sizeof(guint32)
								|| write(fd,(guint8 *)bmih
										+bm_header_bytes(bmih),length)!=length
								|| ((length&1)!=0 && write(fd,&dummy,1)!=1)) {
								close(fd);
								for (i=0;i<streams;i++) {
									g_free(name[i]);
									g_free(fmt[i]);
									if (avi_frame[i]!=NULL)
										avi_get_frame_close(avi_frame[i]);
								}
								g_free(avi_frame);
								g_free(name);
								g_free(fmt);
								g_free(strf);
								g_free(data);
								g_free(index);
								g_free(pos);
								return FALSE;
							}
							/* ǥå */
							index=g_realloc(index,(entries+1)*AIE_SIZE);
							p=(guint8 *)index+entries++*AIE_SIZE;
							aie_set_type(p,make4cc(i/10+'0',i%10+'0','d','b'));
							aie_set_flags(p,AVIIF_KEYFRAME);
							aie_set_offset(p,offset-head+sizeof(guint32));
							aie_set_length(p,length);
							offset+=((length+1)&~1)+sizeof(guint32)*2;
						}
					} else {
						/* ǥ */
						length=avi_sample_size(avi_edit[i],pos[i],samples);
						data=g_realloc(data,(length+1)&~1);
						avi_read(avi_edit[i],pos[i],samples,data);
						if ((length&1)!=0)
							data[length]=0;
						fourcc=GUINT32_TO_LE(
										make4cc(i/10+'0',i%10+'0','w','b'));
						size=GUINT32_TO_LE(length);
						if (write(fd,&fourcc,sizeof(guint32))!=sizeof(guint32)
							|| write(fd,&size,sizeof(guint32))!=sizeof(guint32)
							|| write(fd,data,(length+1)&~1)!=((length+1)&~1)) {
							close(fd);
							for (i=0;i<streams;i++) {
								g_free(name[i]);
								g_free(fmt[i]);
								if (avi_frame[i]!=NULL)
									avi_get_frame_close(avi_frame[i]);
							}
							g_free(avi_frame);
							g_free(name);
							g_free(fmt);
							g_free(strf);
							g_free(data);
							g_free(index);
							g_free(pos);
							return FALSE;
						}
						/* ǥå */
						index=g_realloc(index,(entries+1)*AIE_SIZE);
						p=(guint8 *)index+entries++*AIE_SIZE;
						aie_set_type(p,make4cc(i/10+'0',i%10+'0','w','b'));
						aie_set_flags(p,0);
						aie_set_offset(p,offset-head+sizeof(guint32));
						aie_set_length(p,length);
						offset+=((length+1)&~1)+sizeof(guint32)*2;
					}
					if (i!=current)
						pos[i]+=samples;
				}
			}
		if (current>=0) {
			pos[current]++;
			if (avi_edit[current]->length<=pos[current]) {
				timer=avi_length_time(avi_edit[current]);
				current=-1;
			}
		} else {
			timer+=times;
		}
	}
	g_free(data);
	/* ե졼 */
	for (i=0;i<streams;i++)
		if (avi_frame[i]!=NULL && !avi_get_frame_close(avi_frame[i])) {
			close(fd);
			while (++i<streams)
				avi_get_frame_close(avi_frame[i]);
			for (i=0;i<streams;i++) {
				g_free(name[i]);
				g_free(fmt[i]);
			}
			g_free(avi_frame);
			g_free(name);
			g_free(fmt);
			g_free(strf);
			g_free(index);
			g_free(pos);
			return FALSE;
		}
	g_free(avi_frame);

	/* ٤ƤΥȥ꡼ब1ץʾϤȤå */
	current=-1;
	for (i=0;i<streams;i++)
		if (pos[i]<=0)
			break;
	if (i>=streams)
		for (i=0;i<streams;i++)
			if (avi_edit[i]->type==streamtypeVIDEO
									&& (current==-1 || pos[i]>pos[current]))
				current=i;/* ǤĹӥǥȥ꡼ */

	/* ǥå */
	fourcc=GUINT32_TO_LE(ckidAVINEWINDEX);
	size=GUINT32_TO_LE(entries*AIE_SIZE);
	if (current<0 || write(fd,&fourcc,sizeof(guint32))!=sizeof(guint32)
					|| write(fd,&size,sizeof(guint32))!=sizeof(guint32)
					|| write(fd,index,entries*AIE_SIZE)!=entries*AIE_SIZE) {
		close(fd);
		for (i=0;i<streams;i++) {
			g_free(name[i]);
			g_free(fmt[i]);
		}
		g_free(name);
		g_free(fmt);
		g_free(strf);
		g_free(index);
		g_free(pos);
		return FALSE;
	}
	g_free(index);

	/* إåꤹ */
	data=g_malloc0(head);
	p=data;

	*(guint32 *)p=GUINT32_TO_LE(FOURCC_RIFF);
	((guint32 *)p)++;											/* 'RIFF' */
	*(guint32 *)p=GUINT32_TO_LE(offset+entries*AIE_SIZE);
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(formtypeAVI);
	((guint32 *)p)++;											/* 'AVI ' */
	*(guint32 *)p=GUINT32_TO_LE(FOURCC_LIST);
	((guint32 *)p)++;											/* 'LIST' */
	*(guint32 *)p=GUINT32_TO_LE(sizeof(guint32)				/* 'hdrl' */
								+sizeof(guint32)			/* 'avih' */
								+sizeof(guint32)			/*  */
								+AMH_SIZE);					/* ¤ */
	for (i=0;i<streams;i++)
		*(guint32 *)p+=GUINT32_TO_LE(
				sizeof(guint32)								/* 'LIST' */
				+sizeof(guint32)							/*  */
				+sizeof(guint32)							/* 'strl' */
					+sizeof(guint32) 						/* 'strh' */
					+sizeof(guint32)						/*  */
					+ASH_SIZE								/* ¤ */
					+sizeof(guint32) 						/* 'strf' */
					+sizeof(guint32)						/*  */
					+((strf[i]+1)&~1)						/* ¤ */
					+sizeof(guint32) 						/* 'strn' */
					+sizeof(guint32)						/*  */
					+((g_strlen(name[i])+1)&~1));			/* ʸ */
	((guint32 *)p)++;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(listtypeAVIHEADER);
	((guint32 *)p)++;											/* 'hdrl' */
	*(guint32 *)p=GUINT32_TO_LE(ckidAVIMAINHDR);
	((guint32 *)p)++;											/* 'avih' */
	*(guint32 *)p=GUINT32_TO_LE(AMH_SIZE);
	((guint32 *)p)++;											/*  */
	amh_set_micro_sec_per_frame(p,0);
	amh_set_padding_granularity(p,AVI_HEADERSIZE);
	amh_set_flags(p,AVIF_HASINDEX | AVIF_MUSTUSEINDEX);
	amh_set_total_frames(p,pos[current]);
	for (i=0;i<streams;i++)
		if (pos[i]>0)
			amh_set_streams(p,amh_get_streams(p)+1);
	amh_set_width(p,bmih_get_width(fmt[current]));
	amh_set_height(p,bmih_get_height(fmt[current]));
	p+=AMH_SIZE;												/* ¤ */

	for (i=0;i<streams;i++)
		if (pos[i]>0) {
			*(guint32 *)p=GUINT32_TO_LE(FOURCC_LIST);
			((guint32 *)p)++;									/* 'LIST' */
			*(guint32 *)p=GUINT32_TO_LE(
						sizeof(guint32)						/* 'strl' */
						+sizeof(guint32) 					/* 'strh' */
						+sizeof(guint32)					/*  */
						+ASH_SIZE							/* ¤ */
						+sizeof(guint32) 					/* 'strf' */
						+sizeof(guint32)					/*  */
						+((strf[i]+1)&~1)					/* ¤ */
						+sizeof(guint32) 					/* 'strn' */
						+sizeof(guint32)					/*  */
						+((g_strlen(name[i])+1)&~1));		/* ʸ */
			((guint32 *)p)++;									/*  */
			*(guint32 *)p=GUINT32_TO_LE(listtypeSTREAMHEADER);
			((guint32 *)p)++;									/* 'strl' */

			*(guint32 *)p=GUINT32_TO_LE(ckidSTREAMHEADER);
			((guint32 *)p)++;									/* 'strh' */
			*(guint32 *)p=GUINT32_TO_LE(ASH_SIZE);
			((guint32 *)p)++;									/*  */
			ash_set_type(p,avi_edit[i]->type);
			if (avi_edit[i]->type==streamtypeVIDEO)
				ash_set_handler(p,
					(bmih_get_compression(avi_edit[i]->bmih)==BI_RGB
					|| bmih_get_compression(avi_edit[i]->bmih)==BI_BITFIELDS)
									?comptypeDIB
									:bmih_get_compression(avi_edit[i]->bmih));
			ash_set_scale(p,avi_edit[i]->scale);
			ash_set_rate(p,avi_edit[i]->rate);
			ash_set_length(p,pos[i]);
			ash_set_quality(p,-1);
			if (avi_edit[i]->type==streamtypeVIDEO) {
				ash_set_frame_right(p,bmih_get_width(avi_edit[i]->bmih));
				ash_set_frame_top(p,bmih_get_height(avi_edit[i]->bmih));
			}
			p+=ASH_SIZE;										/* ¤ */

			*(guint32 *)p=GUINT32_TO_LE(ckidSTREAMFORMAT);
			((guint32 *)p)++;									/* 'strf' */
			*(guint32 *)p=GUINT32_TO_LE((strf[i]+1)&~1);
			((guint32 *)p)++;									/*  */
			g_memmove(p,fmt[i],strf[i]);
			p+=(strf[i]+1)&~1;									/* ¤ */

			*(guint32 *)p=GUINT32_TO_LE(ckidSTREAMNAME);
			((guint32 *)p)++;									/* 'strn' */
			*(guint32 *)p=GUINT32_TO_LE((g_strlen(name[i])+1)&~1);
			((guint32 *)p)++;									/*  */
			g_memmove(p,name[i],g_strlen(name[i]));
			p+=(g_strlen(name[i])+1)&~1;						/* ʸ */
		}

	*(guint32 *)p=GUINT32_TO_LE(ckidAVIPADDING);
	((guint32 *)p)++;											/* 'JUNK' */
	*(guint32 *)p=GUINT32_TO_LE(head-header);					/*  */

	p=data+head-sizeof(guint32);
	*(guint32 *)p=GUINT32_TO_LE(listtypeAVIMOVIE);
	((guint32 *)p)--;											/* 'movi' */
	*(guint32 *)p=GUINT32_TO_LE(offset-head+sizeof(guint32));
	((guint32 *)p)--;											/*  */
	*(guint32 *)p=GUINT32_TO_LE(FOURCC_LIST);					/* 'LIST' */

	for (i=0;i<streams;i++) {
		g_free(name[i]);
		g_free(fmt[i]);
	}
	g_free(name);
	g_free(fmt);
	g_free(strf);
	g_free(pos);

	if (lseek(fd,0,SEEK_SET)==-1 || write(fd,data,head)!=head) {
		close(fd);
		g_free(data);
		return FALSE;
	}

	g_free(data);
	return close(fd)==0;
}
