/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "resource.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ꥽                                                                    *
*                                                                             *
******************************************************************************/
/* Predefined resource types */
#define RT_CURSOR		1
#define RT_BITMAP		2
#define RT_ICON			3
#define RT_MENU			4
#define RT_DIALOG		5
#define RT_STRING		6
#define RT_FONTDIR		7
#define RT_FONT			8
#define RT_ACCELERATOR	9
#define RT_RCDATA		10
#define RT_MESSAGETABLE	11
#define RT_GROUP_CURSOR	12
#define RT_GROUP_ICON	14
#define RT_VERSION		16
#define RT_DLGINCLUDE	17
#define RT_PLUGPLAY		19
#define RT_VXD			20
#define RT_ANICURSOR	21
#define RT_ANIICON		22
#define RT_HTML			23


HRSRC WINAPI FindResourceExA(HMODULE hModule,
									LPCSTR lpType,LPCSTR lpName,WORD wLanguage)
{
	guint8 *data;
	gchar *buf,*key;

	buf=(guint)lpType<0x10000?g_strdup_printf("/0x%x",(gint)lpType)
								:g_strdup_printf("/%s",lpType);
	key=(guint)lpName<0x10000
					?g_strdup_printf("%s/0x%x/0x%x",buf,(gint)lpName,wLanguage)
					:g_strdup_printf("%s/%s/0x%x",buf,lpName,wLanguage);
	g_free(buf);
	g_strdown(key);
	data=g_hash_table_lookup(((PE_image *)hModule)->resource,key);
	g_free(key);
	return data;
}


HRSRC WINAPI FindResourceExW(HMODULE hModule,
								LPCWSTR lpType,LPCWSTR lpName,WORD wLanguage)
{
	gchar *name,*type;
	gint i;
	HRSRC hRsrc;

	if ((guint)lpName<0x10000) {
		(gint)name=(gint)lpName;
	} else {
		for (i=0;lpName[i]!=0;i++);
		name=g_malloc((i+1)*sizeof(gchar));
		for (i=0;lpName[i]!=0;i++)
			name[i]=lpName[i];
		name[i]='\0';
	}
	if ((guint)lpType<0x10000) {
		(gint)type=(gint)lpType;
	} else {
		for (i=0;lpType[i]!=0;i++);
		type=g_malloc((i+1)*sizeof(gchar));
		for (i=0;lpType[i]!=0;i++)
			type[i]=lpType[i];
		type[i]='\0';
	}

	hRsrc=FindResourceExA(hModule,type,name,wLanguage);

	if ((guint)name>=0x10000)
		g_free(name);
	if ((guint)type>=0x10000)
		g_free(type);
	return hRsrc;
}


HRSRC WINAPI FindResourceA(HMODULE hModule,LPCSTR lpName,LPCSTR lpType)
{
	gint primary,secondary;
	HRSRC hRsrc;

	for (primary=0;primary<0x400;primary++)
		for (secondary=0;secondary<0x40;secondary++)
			if ((hRsrc=FindResourceExA(hModule,lpType,lpName,
											(secondary<<10)|primary))!=NULL)
				return hRsrc;
	return NULL;
}


HRSRC WINAPI FindResourceW(HMODULE hModule,LPCWSTR lpName,LPCWSTR lpType)
{
	gchar *name,*type;
	gint i;
	HRSRC hRsrc;

	if ((guint)lpName<0x10000) {
		(gint)name=(gint)lpName;
	} else {
		for (i=0;lpName[i]!=0;i++);
		name=g_malloc((i+1)*sizeof(gchar));
		for (i=0;lpName[i]!=0;i++)
			name[i]=lpName[i];
		name[i]='\0';
	}
	if ((guint)lpType<0x10000) {
		(gint)type=(gint)lpType;
	} else {
		for (i=0;lpType[i]!=0;i++);
		type=g_malloc((i+1)*sizeof(gchar));
		for (i=0;lpType[i]!=0;i++)
			type[i]=lpType[i];
		type[i]='\0';
	}

	hRsrc=FindResourceA(hModule,name,type);

	if ((guint)name>=0x10000)
		g_free(name);
	if ((guint)type>=0x10000)
		g_free(type);
	return hRsrc;
}


BOOL WINAPI FreeResource(HGLOBAL hResData)
{
	return TRUE;
}


HBITMAP WINAPI LoadBitmapA(HINSTANCE hInstance,LPCSTR lpBitmapName)
{
	return FindResourceA(hInstance,lpBitmapName,(LPCSTR)RT_BITMAP);
}


HGLOBAL WINAPI LoadResource(HMODULE hModule,HRSRC hResInfo)
{
	return (LPDWORD)hResInfo+1;
}


INT WINAPI LoadStringA(HINSTANCE hInstance,UINT uID,
												LPSTR lpBuffer,INT nBufferMax)
{
	gint i;
	guint16 *data;
	HRSRC hRsrc;

	if (lpBuffer==NULL || nBufferMax<=0)
		return 0;
	g_memset(lpBuffer,0,nBufferMax*sizeof(CHAR));

	if ((hRsrc=FindResourceA(hInstance,
						(LPCSTR)((uID>>4)&0xffff)+1,(LPCSTR)RT_STRING))!=NULL
							&& (data=LoadResource(hInstance,hRsrc))!=NULL) {
		for (i=0;i<(uID&0x0f);i++)
			data+=*data+1;
		misc_widechar_to_multibyte(data,-1,lpBuffer,nBufferMax);
		lpBuffer[nBufferMax-1]='\0';
	}

	return g_strlen(lpBuffer);
}


INT WINAPI LoadStringW(HINSTANCE hInstance,UINT uID,
												LPWSTR lpBuffer,INT nBufferMax)
{
	gint i=0;
	guint16 *data;
	HRSRC hRsrc;

	if (lpBuffer==NULL || nBufferMax<=0)
		return 0;
	g_memset(lpBuffer,0,nBufferMax*sizeof(WCHAR));

	if ((hRsrc=FindResourceA(hInstance,
						(LPCSTR)((uID>>4)&0xffff)+1,(LPCSTR)RT_STRING))!=NULL
							&& (data=LoadResource(hInstance,hRsrc))!=NULL) {
		for (i=0;i<(uID&0x0f);i++)
			data+=*data+1;
		for (i=0;i<nBufferMax-1 && data[i]!=0;i++)
			lpBuffer[i]=data[i];
	}

	return i;
}


LPVOID WINAPI LockResource(HGLOBAL hResData)
{
	return hResData;
}


DWORD WINAPI SizeofResource(HMODULE hModule,HRSRC hResInfo)
{
	return *(LPDWORD)hResInfo;
}
