/*
    Video maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __FILE_H__
#define __FILE_H__


#include "vmaid.h"


#define FILE_SAVE_AVI 0
#define FILE_SAVE_BITMAP 1
#define FILE_SAVE_WAVE 2
#define FILE_SAVE_SCENARIO 2


typedef struct FileOpen_Tag {
	gchar *file;
	gboolean merge;
} FileOpen;
typedef struct FileSave_Tag {
	gchar *file;
	gint mode;		/* 0:AVI,1:ӥåȥޥå,2:WAVE,3:ʥꥪ֥ */
	gint start,end,max;
	AviEdit *avi_edit[2];
} FileSave;


/*	ե˲ä
	file,ե̾															*/
void file_set_history(const gchar *file);


/*	եä
	file,ä褦ȤեΥեѥ
	 RET,ä褦ȤեΥ٥										*/
gchar *file_add_edit(const gchar *file,gint *same);


/*	ե
	file,褦ȤեΥեѥ									*/
void file_delete_edit(const gchar *file);


/*	ե򳫤(Ωå)
	file_open,Open
	      RET,ɥ												*/
VmaidWindow *file_open_edit(FileOpen *file_open);


/*	AVIե¸(Ωå)
	file_save,Save
	      RET,TRUE:ｪλ,FALSE:顼									*/
gboolean file_save_edit(FileSave *file_save);


#endif
