/*
    Video maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "version.h"
#include <gdk/gdkkeysyms.h>
#include "avicore/avicore.h"


/******************************************************************************
*                                                                             *
* Сؿ                                                        *
*                                                                             *
******************************************************************************/
/* Video Compressionܥ󤬲줿 */
static void version_dialog_clicked(GtkWidget *widget,gpointer user_data)
{
	icm_about();
}


/* ESC줿 */
static gboolean version_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


void version_dialog(void)
{
	guint key;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkAccelGroup *accel;
	GtkWidget *dialog,*button0,*button1,*hbox,*vbox;
/* XPM */
static gchar *vmaid_xpm[] = {
"32 32 16 1",
" 	c None",
".	c #000000",
"+	c #800000",
"@	c #008000",
"#	c #808000",
"$	c #000080",
"%	c #800080",
"&	c #008080",
"*	c #808080",
"=	c #C0C0C0",
"-	c #FF0000",
";	c #00FF00",
">	c #FFFF00",
",	c #0000FF",
"'	c #FF00FF",
")	c #00FFFF",
"                                ",
"                                ",
"++++++++++++++++++++++++++++++++",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
"++++++++++++++++++++++++++++++++",
". . + . . . . . . . . . . .+. . ",
" . .+. . . . . ' . . . . . + . .",
". . + . . . . ''  . . . . .+. . ",
" . .+. . . . ''' . . . . . + . .",
". . + . . .  '''      . . .+. . ",
" . .+. . -  '''',,,,,, . . + . .",
". . + .  ---'''',,,,, . . .+. . ",
" . .+. .  ----'',,,) . . . + . .",
". . + . . -----',)))  . . .+. . ",
" . .+. . . --->;)))))  . . + . .",
". . + . .  ->>>;;)))) . . .+. . ",
" . .+. .  >>>>>;;;;))) . . + . .",
". . + .  >>>>>>;;;;  )  . .+. . ",
" . .+. .       ;;; .   . . + . .",
". . + . . . .  ;;;  . . . .+. . ",
" . .+. . . . . ;;  . . . . + . .",
". . + . . . .  ;  . . . . .+. . ",
" . .+. . . . .   . . . . . + . .",
"++++++++++++++++++++++++++++++++",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
"++++++++++++++++++++++++++++++++",
"                                ",
"                                "};

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("About Video maid"));
	gtk_signal_connect(GTK_OBJECT(dialog),"key-press-event",
							GTK_SIGNAL_FUNC(version_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ܥ */
	button0=gtk_button_new_with_label(NULL);
	button1=gtk_button_new_with_label(_("OK"));
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button0)->child),
													_("_Video Compression"));
	gtk_widget_add_accelerator(button0,"clicked",accel,key,GDK_MOD1_MASK,0);
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
										version_dialog_clicked,NULL);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ԥޥå */
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&mask,NULL,vmaid_xpm);

	/* ե졼ȥܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),
									gtk_pixmap_new(pixmap,mask),FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new("Video maid version "VERSION
				"\ncopyright (c) 1998-2002 by Kazuki IWAMOTO"),FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_grab_focus(button1);

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();
}
