/*
    avicore
    copyright (c) 2000-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "avibase.h"
#include "avifmt.h"
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/******************************************************************************
*                                                                             *
* AVIϴؿ()                                                         *
*                                                                             *
******************************************************************************/
/*	եȽ̤
	file,ե̾
	 RET,0:AVI,1:ӥåȥޥå,2:WAVEե,3:ʥꥪ֥,-1:	*/
gint avi_file_type(const gchar *file)
{
	int fd;
	guint8 buffer[12];			/* եȽѤΥХåե */

	/* ե򳫤 */
	if (file==NULL || (fd=open(file,O_RDONLY))==-1)
		return AVI_TYPE_UNKNOW;
	if (
#ifdef HAVE_FLOCK
		flock(fd,LOCK_SH)==-1 ||
#endif
						read(fd,buffer,sizeof(guint8)*12)!=sizeof(guint8)*12) {
		close(fd);
		return AVI_TYPE_UNKNOW;
	}
	/* إåʬɤ߹ */
	if (close(fd)!=0)
		return AVI_TYPE_UNKNOW;
	/* եηʬ */
	if (buffer[0]=='R' && buffer[1]=='I' && buffer[2]=='F' && buffer[3]=='F'
										&& buffer[8]=='A' && buffer[9]=='V'
										&& buffer[10]=='I' && buffer[11]==' ')
		return AVI_TYPE_AVI;/* AVI */
	else if (buffer[0]=='B' && buffer[1]=='M')
		return AVI_TYPE_BITMAP;/* ӥåȥޥå */
	else if (buffer[0]=='R' && buffer[1]=='I'
										&& buffer[2]=='F' && buffer[3]=='F'
										&& buffer[8]=='W' && buffer[9]=='A'
										&& buffer[10]=='V' && buffer[11]=='E')
		return AVI_TYPE_WAVE;/* WAVEե */
	else if (buffer[0]=='#' && buffer[1]=='V' && buffer[2]=='M'
										&& buffer[3]=='A' && buffer[4]=='I'
										&& buffer[5]=='D' && buffer[6]=='\n')
		return AVI_TYPE_SCENARIO;/* ʥꥪ֥ */
	return AVI_TYPE_UNKNOW;
}


/*	AVIΥȥ꡼ο
	file,ե̾
	 RET,ȥ꡼ο,0:顼											*/
guint32 avi_main_streams(const gchar *file)
{
	int fd;
	guint8 buffer[12];			/* եȽѤΥХåե */
	AviMainHeader amh;
	Chunk *ck;

	/* ե򳫤 */
	if (file==NULL || (fd=open(file,O_RDONLY))==-1)
		return 0;
	/* إåʬɤ߹ */
	if (
#ifdef HAVE_FLOCK
		flock(fd,LOCK_SH)==-1 ||
#endif
						read(fd,buffer,sizeof(guint8)*12)!=sizeof(guint8)*12) {
		close(fd);
		return 0;
	}
	if (buffer[0]!='R' || buffer[1]!='I' || buffer[2]!='F' || buffer[3]!='F'
									|| buffer[8]!='A' || buffer[9]!='V'
									|| buffer[10]!='I' || buffer[11]!=' ') {
		close(fd);
		return 0;
	}
	/* եǥ꥿󥯥ݥ󥿤 */
	ck=chunk_open(fd);
	/* RIFF󥯤 */
	if (!chunk_in(fd,ck)) {
		chunk_free(ck);
		close(fd);
		return 0;
	}
	/* եबhdrlLIST󥯤õ */
	while (chunk_form(fd)!=listtypeAVIHEADER)
		if (!chunk_next(fd,ck)) {
			chunk_free(ck);
			close(fd);
			return 0;
		}
	/* եबhdrlLIST󥯤(RIFF'AVI ' -> LIST'hdrl') */
	if (!chunk_in(fd,ck)) {
		chunk_free(ck);
		close(fd);
		return 0;
	}
	/* avih󥯤õ(AviMainHeader) */
	while (chunk_id(fd)!=ckidAVIMAINHDR)
		if (!chunk_next(fd,ck)) {
			chunk_free(ck);
			close(fd);
			return 0;
		}
	/* avih󥯤Υ(AviMainHeader) */
	/* avih󥯤(AviMainHeader) (RIFF'AVI ' -> LIST'hdrl' -> avih) */
	/* AviMainHeaderɤ߹ */
	if (chunk_size(fd)!=AMH_SIZE || !chunk_in(fd,ck)
										|| read(fd,&amh,AMH_SIZE)!=AMH_SIZE) {
		chunk_free(ck);
		close(fd);
		return 0;
	}
	/* 󥯥ݥ󥿤 */
	return chunk_free(ck) & (close(fd)==0)?amh_get_streams(&amh):0;
}


/*	AVIե뤫鳫
	 file,ե̾
	param,ȥ꡼ֹ
	  RET,AVIԽϥɥ,NULL:顼										*/
AviEdit *avi_open(const gchar *file,const gint param)
{
	AviEdit *avi_edit;
	IcmObject *icm_object;

	/*  */
	avi_edit=g_malloc(sizeof(AviEdit));
	avi_edit->offset=0;
	/* å */
	g_memset(avi_edit->buf,0,AVI_EDIT_CACHE*sizeof(AviBuffer));

	if (file==NULL || (avi_edit->file=avi_open_file(file,param,&avi_edit->type,
									&avi_edit->rate,&avi_edit->scale))==NULL) {
		g_free(avi_edit);
		return NULL;
	}
	/* ŸΥեޥå */
	if (avi_type(avi_edit)==streamtypeVIDEO) {
		if (avi_edit->file->handler==comptypeDIB) {
			avi_edit->bmih=g_memdup(avi_edit->file->bmih,
										bm_header_bytes(avi_edit->file->bmih));
			if (avi_get_compression(avi_edit)==comptypeDIB)
				bmih_set_compression(avi_edit->bmih,BI_RGB);
			if (bmih_get_size_image(avi_edit->bmih)<=0)
				bmih_set_size_image(avi_edit->bmih,
											bm_image_bytes(avi_edit->bmih));
		} else {
			/*  */
			if ((icm_object=icm_open(avi_edit->file->handler,
												ICM_MODE_DECOMPRESS))==NULL) {
				avi_release_file(avi_edit->file);
				g_free(avi_edit->bmih);
				g_free(avi_edit);
				return NULL;
			}
			avi_edit->bmih=g_malloc(icm_decompress_get_format_size(icm_object,
														avi_edit->file->bmih));
			if (!icm_decompress_get_format(icm_object,
										avi_edit->file->bmih,avi_edit->bmih)
													| !icm_close(icm_object)) {
				avi_release_file(avi_edit->file);
				g_free(avi_edit->bmih);
				g_free(avi_edit);
				return NULL;
			}
			avi_edit->bmih=g_realloc(avi_edit->bmih,
											bm_header_bytes(avi_edit->bmih));
		}
		/* ǥͭ */
		avi_edit->wfx=NULL;				/* ŸΥեޥå */
	} else {
		if (wfx_get_format_tag(avi_edit->file->wfx)==WAVE_FORMAT_PCM) {
			avi_edit->wfx=g_memdup(avi_edit->file->wfx,
										wf_header_bytes(avi_edit->file->wfx));
		} else {
			/*  */
			avi_release_file(avi_edit->file);
			g_free(avi_edit);
			return NULL;
		}
		/* ӥǥͭ */
		avi_edit->bmih=NULL;			/* ŸΥեޥå */
	}
	/*  */
	avi_edit->length=avi_edit->file->length;
	return avi_edit;
}


/*	AVIĤ
	avi_edit,AVIԽϥɥ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_release(AviEdit *avi_edit)
{
	gint i;
	AviFile *avi_file;

	if (avi_edit==NULL)
		return FALSE;
	while (avi_edit->file!=NULL) {
		avi_file=avi_edit->file->next;
		avi_release_file(avi_edit->file);
		avi_edit->file=avi_file;
	}
	g_free(avi_edit->bmih);
	for (i=0;i<AVI_EDIT_CACHE;i++)
		g_free(avi_edit->buf[i].data);
	g_free(avi_edit->wfx);
	g_free(avi_edit);
	return TRUE;
}


/*	AVIΥǡΥХȿ
	avi_edit,AVIԽϥɥ
	   start,ɤ߹ߤϤ륵ץֹ
	 samples,ץ
	     RET,Хȿ														*/
gint avi_sample_size(AviEdit *avi_edit,const gint start,const gint samples)
{
	gint i,length,samples_n;

	/* Ȱ֤ȥץĴ */
	if (avi_edit==NULL || start<0)
		return 0;
	samples_n=MIN(avi_length(avi_edit)-start,samples);
	if (samples_n<=0)
		return 0;
	switch (avi_type(avi_edit)) {
		case streamtypeVIDEO:/* ӥǥ */
			avi_get_file(avi_edit,start);/* AVIե */
			length=0;
			for (i=start;i<start+samples_n;i++) {
				if (i-avi_edit->offset>=avi_edit->file->length) {
					avi_edit->offset+=avi_edit->file->length;
					avi_edit->file=avi_edit->file->next;
				}
				length+=avi_edit->file->
						index[i-avi_edit->offset+avi_edit->file->start].size;
			}
			return length;
		case streamtypeAUDIO:/* ǥ */
			return wfx_get_block_align(avi_edit->wfx)*samples_n;
	}
	return 0;
}


/*	AVIΥǡɤ߹
	avi_edit,AVIԽϥɥ
	   start,ɤ߹ߤϤ륵ץֹ
	 samples,ץ
	  buffer,ǡǼХåե
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_read(AviEdit *avi_edit,const gint start,const gint samples,
															gpointer buffer)
{
	gint i,dif,length,start_n,samples_n;
	guint32 size;
	off_t offset;

	/* Ȱ֤ȥץĴ */
	if (avi_edit==NULL || samples<=0 || start<0
										|| avi_length(avi_edit)<start+samples)
		return FALSE;
	avi_get_file(avi_edit,start);/* AVIե */
	switch (avi_type(avi_edit)) {
		case streamtypeVIDEO:/* ӥǥ */
			for (i=start;i<start+samples;i++) {
				if (i-avi_edit->offset>=avi_edit->file->length) {
					avi_edit->offset+=avi_edit->file->length;
					avi_edit->file=avi_edit->file->next;
				}
				offset=avi_edit->file->
						index[i-avi_edit->offset+avi_edit->file->start].offset;
				size=avi_edit->file->
						index[i-avi_edit->offset+avi_edit->file->start].size;
				if (avi_edit->file->data==NULL) {
					/* ե */
					if (lseek(avi_edit->file->fd,offset,SEEK_SET)==-1
								|| read(avi_edit->file->fd,buffer,size)!=size)
						return FALSE;
				} else {
					/*  */
					g_memmove(buffer,(guint8 *)avi_edit->file->data+offset,
																		size);
				}
				(guint8 *)buffer+=size;
			}
			return TRUE;
		case streamtypeAUDIO:/* ǥ */
			length=start-avi_edit->offset+avi_edit->file->start;
			dif=0;
			for (i=0;dif<=length;i++)
				dif+=avi_edit->file->index[i].size
										/wfx_get_block_align(avi_edit->wfx);
			dif-=avi_edit->file->index[--i].size
										/wfx_get_block_align(avi_edit->wfx);
			dif=length-dif;
			start_n=start;
			samples_n=samples;
			while (samples_n>0) {
				if (avi_edit->offset+avi_edit->file->length<=start_n) {
					avi_edit->offset+=avi_edit->file->length;
					avi_edit->file=avi_edit->file->next;
					dif=0;
					for (i=0;dif<=avi_edit->file->start;i++)
						dif+=avi_edit->file->index[i].size
										/wfx_get_block_align(avi_edit->wfx);
					dif-=avi_edit->file->index[--i].size
										/wfx_get_block_align(avi_edit->wfx);
					dif=length-dif;
				}
				offset=(off_t)dif*wfx_get_block_align(avi_edit->wfx);
				size=MIN(wfx_get_block_align(avi_edit->wfx)*samples_n,
										avi_edit->file->index[i].size-offset);
				offset+=avi_edit->file->index[i].offset;
				if (avi_edit->file->data==NULL) {
					/* ե */
					if (lseek(avi_edit->file->fd,offset,SEEK_SET)==-1
								|| read(avi_edit->file->fd,buffer,size)!=size)
						return FALSE;
				} else {
					/*  */
					g_memmove(buffer,(guint8 *)avi_edit->file->data+offset,
																		size);
				}
				(guint8 *)buffer+=size;
				start_n+=size/wfx_get_block_align(avi_edit->wfx);
				samples_n-=size/wfx_get_block_align(avi_edit->wfx);
				dif=0;
				i++;
			}
			return TRUE;
	}
	return FALSE;
}


/*	AVIΥեޥåȤΥ
	avi_edit,AVIԽϥɥ
	     RET,եޥåȤΥХȿ,0:顼								*/
gint avi_format_size(AviEdit *avi_edit)
{
	if (avi_edit!=NULL)
		switch (avi_type(avi_edit)) {
			case streamtypeVIDEO:/* ӥǥ */
				return bm_header_bytes(avi_edit->bmih);
			case streamtypeAUDIO:/* ǥ */
				return wf_header_bytes(avi_edit->wfx);
		}
	return 0;
}


/*	AVIΥեޥåȤɤ߹
	avi_edit,AVIԽϥɥ
	  format,ХåեؤΥݥ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_read_format(AviEdit *avi_edit,gpointer format)
{
	if (avi_edit!=NULL)
		switch (avi_type(avi_edit)) {
			case streamtypeVIDEO:/* ӥǥ */
			g_memmove(format,avi_edit->bmih,bm_header_bytes(avi_edit->bmih));
			return TRUE;
			case streamtypeAUDIO:/* ǥ */
			g_memmove(format,avi_edit->wfx,wf_header_bytes(avi_edit->wfx));
			return TRUE;
		}
	return FALSE;
}
