/*
    avicore
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Chunk                                                                       *
*                                                                             *
******************************************************************************/
#include "chunk.h"
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/*	󥯹¤Τ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_free(Chunk *ck)
{
	if (ck==NULL)
		return FALSE;
	g_free(ck->list);
	g_free(ck);
	return TRUE;
}


/*	󥯤
	 fd,եǥ꥿
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_in(int fd,Chunk *ck)
{
	if (ck==NULL || (ck->num>0
					&& GUINT32_FROM_LE(ck->list[ck->num-1].id)!=FOURCC_RIFF
					&& GUINT32_FROM_LE(ck->list[ck->num-1].id)!=FOURCC_LIST))
		return FALSE;
	ck->list=g_realloc(ck->list,(ck->num+1)*sizeof(ChunkList));
	if ((ck->list[ck->num].offset=lseek(fd,0,SEEK_CUR))==-1
		|| read(fd,&ck->list[ck->num].id,sizeof(guint32))!=sizeof(guint32)
		|| read(fd,&ck->list[ck->num].size,sizeof(guint32))!=sizeof(guint32)
		|| ((GUINT32_FROM_LE(ck->list[ck->num].id)==FOURCC_RIFF
				|| GUINT32_FROM_LE(ck->list[ck->num].id)==FOURCC_LIST)
				&& read(fd,&ck->list[ck->num].form,sizeof(guint32))
														!=sizeof(guint32))) {
		lseek(fd,ck->list[ck->num].offset,SEEK_SET);
		return FALSE;
	}
	ck->list[ck->num].size=GUINT32_FROM_LE(ck->list[ck->num].size);
	ck->num++;
	return TRUE;
}


/*	󥯤Ф
	 fd,եǥ꥿
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_out(int fd,Chunk *ck)
{
	if (ck==NULL || ck->num<=0)
		return FALSE;
	ck->num--;
	lseek(fd,ck->list[ck->num].offset,SEEK_SET);
	ck->list=g_realloc(ck->list,ck->num*sizeof(ChunkList));
	return TRUE;
}


/*	Υ󥯤˰ư
	 fd,եǥ꥿
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_next(int fd,Chunk *ck)
{
	guint32 size;
	off_t offset;

	offset=lseek(fd,0,SEEK_CUR);
	if (ck==NULL || lseek(fd,(off_t)sizeof(guint32),SEEK_CUR)==-1
						|| read(fd,&size,sizeof(guint32))!=sizeof(guint32)) {
		lseek(fd,offset,SEEK_SET);
		return FALSE;
	}
	size=(GUINT32_FROM_LE(size)+1)&~1;;
	if ((ck->num>0
		&& ck->list[ck->num-1].offset+ck->list[ck->num-1].size<=offset+size)
											|| lseek(fd,size,SEEK_CUR)==-1) {
		lseek(fd,offset,SEEK_SET);
		return FALSE;
	}
	return TRUE;
}


/*	󥯤ID
	 fd,եǥ꥿
	RET,ID,-1:顼														*/
guint32 chunk_id(int fd)
{
	guint32 id;

	return read(fd,&id,sizeof(guint32))==sizeof(guint32)
					&& lseek(fd,-(off_t)sizeof(guint32),SEEK_CUR)!=(off_t)-1
											?GUINT32_FROM_LE(id):(guint32)-1;

}


/*	󥯤Υ
	 fd,եǥ꥿
	RET,,-1:顼													*/
guint32 chunk_size(int fd)
{
	guint32 size;

	return lseek(fd,(off_t)sizeof(guint32),SEEK_CUR)!=-1
			&& read(fd,&size,sizeof(guint32))==sizeof(guint32)
			&& lseek(fd,-(off_t)(sizeof(guint32)*2),SEEK_CUR)!=-1
											?GUINT32_FROM_LE(size):(guint32)-1;
}


/*	󥯤Υե
	 fd,եǥ꥿
	RET,ե,-1:顼													*/
guint32 chunk_form(int fd)
{
	guint32 id,form;

	return read(fd,&id,sizeof(guint32))==sizeof(guint32)
		&& lseek(fd,(off_t)sizeof(guint32),SEEK_CUR)!=-1
		&& read(fd,&form,sizeof(guint32))==sizeof(guint32)
		&& lseek(fd,-(off_t)(sizeof(guint32)*3),SEEK_CUR)!=-1
		&& (GUINT32_FROM_LE(id)==FOURCC_RIFF
										|| GUINT32_FROM_LE(id)==FOURCC_LIST)
											?GUINT32_FROM_LE(form):(guint32)-1;
}
