/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "signal.h"
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkrgb.h>
#include "argument.h"
#include "command.h"
#include "file.h"
#include "general.h"
#include "thread.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ()                                             *
*                                                                             *
******************************************************************************/
gboolean signal_timeout(gpointer data)
{
	gint sx,page;
	GdkRectangle rc;
	VmaidWindow *vmaid;

	caret=!caret;
	if ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		vmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		sx=MAX((vmaid->drawing->allocation.width-4)/vmaid->width-2,1);
		if (vmaid->top<=vmaid->cursor.frame
									&& vmaid->cursor.frame<=vmaid->top+sx) {
			rc.x=(vmaid->cursor.frame-vmaid->top+1)*vmaid->width+1;
			rc.y=system_font_height*2
						+(vmaid->avi_edit[0]!=NULL && vmaid->cursor.stream>0
															?vmaid->height:0);
			rc.width=2;
			rc.height=vmaid->height;
			gtk_widget_draw(vmaid->drawing,&rc);
		}
	}
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ե졼)                                           *
*                                                                             *
******************************************************************************/
gboolean signal_focus_in(GtkWidget *widget,GdkEventFocus *event,
															VmaidWindow *vmaid)
{
	GTK_WIDGET_SET_FLAGS(widget,GTK_HAS_FOCUS);
	draw_caret(vmaid,NULL);
	return FALSE;
}


gboolean signal_focus_out(GtkWidget *widget,GdkEventFocus *event,
															VmaidWindow *vmaid)
{
	GTK_WIDGET_UNSET_FLAGS(widget,GTK_HAS_FOCUS);
	draw_caret(vmaid,NULL);
	return FALSE;
}


void signal_realize(GtkWidget *widget,gpointer user_data)
{
	/*  */
	gdk_window_set_cursor(widget->window,gdk_cursor_new(GDK_XTERM));
}


void signal_value_changed_hscroll(GtkAdjustment *adjust,VmaidWindow *vmaid)
{
	gint max,sx,top;

	top=vmaid->top;
	vmaid->top=adjust->value+0.5;
	sx=MAX((vmaid->drawing->allocation.width-4)/vmaid->width-2,1);
	max=get_max_frame(vmaid,-1)+1;
	if (vmaid->top>max-sx)
		vmaid->top=MAX(max-sx,0);
	clear_sel(vmaid,&vmaid->cursor,&vmaid->select,top);
}


gboolean signal_config(GtkWidget *widget,GdkEventConfigure *config,
															VmaidWindow *vmaid)
{
	gint sx,max;

	max=get_max_frame(vmaid,-1)+1;
	sx=MAX((config->width-4)/vmaid->width-2,1);
	if (vmaid->top>max-sx)
		vmaid->top=MAX(max-sx,0);
	draw_caret(vmaid,NULL);
	misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
													vmaid,0,max,sx,vmaid->top);
	return TRUE;
}


static void signal_expose_text(GtkWidget *widget,GdkGC *gc,VmaidWindow *vmaid,
														gint pos,gint x,gint y)
{
	gchar *text;
	gint t;

	text=g_strdup_printf(vmaid->avi_edit[0]!=NULL
					&& avi_is_keyframe(vmaid->avi_edit[0],pos)?"%d*":"%d",pos);
	if (gdk_string_width(system_font,text)<=vmaid->width)
		gdk_draw_string(widget->window,system_font,gc,
													x,system_font_ascent,text);
	g_free(text);
	t=(gint64)pos*vmaid->scale*1000/vmaid->rate;
	text=g_strdup_printf("%02d:%02d:%02d",t/60000%100,t/1000%60,t/10%100);
	if (gdk_string_width(system_font,text)<=vmaid->width)
		gdk_draw_string(widget->window,system_font,gc,
							x,y+system_font_ascent+system_font_height,text);
	g_free(text);
}


static void signal_expose_bitmap(GtkWidget *widget,GdkGC *gc,
			AviFrame *avi_frame,gint pos,gint x,gint y,gint width,gint height)
{
	guchar *buf;

	if ((buf=avi_get_frame32(avi_frame,pos,width,height))!=NULL)
		gdk_draw_rgb_32_image(widget->window,gc,x,y,width,height,
											GDK_RGB_DITHER_NORMAL,buf,width*4);
	else
		gdk_draw_rectangle(widget->window,gc,TRUE,x,y,width,height);
}


static void signal_expose_wave(GtkWidget *widget,GdkGC *gc,AviEdit *avi_edit,
							WaveFormatEx *wfx,gint current_time,gint next_time,
										gint x,gint y,gint width,gint height)
{
	guint8 *p=NULL;
	gint i,j,x0,x1,y0,y1,start,end,samples,pos,length=0,count;
	GdkPoint pt[5];

	start=0;
	end=avi_length_time(avi_edit);
	if (wfx!=NULL) {
		/* ϰPCMɤ߹ */
		pos=avi_time_to_sample(avi_edit,MAX(start,current_time));
		samples=avi_time_to_sample(avi_edit,MIN(end,next_time))-pos;
		if (samples>avi_length(avi_edit)-pos)
			samples=avi_length(avi_edit)-pos;
		length=avi_sample_size(avi_edit,pos,samples);
		if (length>0) {
			p=g_malloc(length);
			if (!avi_read(avi_edit,pos,samples,p))
				length=0;
		}
	}
	if (length<=0) {
		/* PCMɤ߹ʤ */
		if (start<=current_time && next_time<=end) {
			/* ̾λͳ */
			pt[0].x=pt[3].x=x+1;
			pt[0].y=pt[1].y=y+1;
			pt[1].x=pt[2].x=x+width-2;
			pt[2].y=pt[3].y=y+height-2;
			count=4;
		} else if (current_time<start && end<next_time) {
			/* ե졼ϰ˥ǥޤ(ɩ) */
			pt[0].x=pt[2].x=x+width/2;
			pt[0].y=y+1;
			pt[1].x=x+width-2;
			pt[1].y=pt[3].y=y+height/2;
			pt[2].y=y+height-2;
			pt[3].x=x+1;
			count=4;
		} else if (start<=current_time && end<next_time) {
			/* ¦礱 */
			pt[0].x=pt[4].x=x+1;
			pt[0].y=pt[1].y=y+1;
			pt[1].x=pt[3].x=x+width/2;
			pt[2].x=x+width-2;
			pt[2].y=y+height/2;
			pt[3].y=pt[4].y=y+height-2;
			count=5;
		} else if (current_time<start && next_time<=end) {
			/* ¦礱 */
			pt[0].x=x;
			pt[0].y=y+height/2;
			pt[1].x=pt[4].x=x+width/2;
			pt[1].y=pt[2].y=y+1;
			pt[2].x=pt[3].x=x+width-2;
			pt[3].y=pt[4].y=y+height-2;
			count=5;
		} else {
			count=0;
		}
		if (count>0) {
			gdk_gc_set_foreground(gc,system_color+2);
			gdk_gc_set_fill(gc,GDK_STIPPLED);
			gdk_draw_polygon(widget->window,gc,TRUE,pt,count);
			gdk_gc_set_foreground(gc,system_color);
			gdk_gc_set_fill(gc,GDK_SOLID);
			gdk_draw_polygon(widget->window,gc,FALSE,pt,count);
		}
	} else {
		/* ȷɽ */
		gdk_gc_set_foreground(gc,system_color);
		x0=MAX(width*(start-current_time)/(next_time-current_time)+x,x);
		x1=MIN(width*(end-current_time)/(next_time-current_time)+x,x+width);
		count=x1-x0;
		for (i=0;i<count;i++) {
			/*  */
			j=i*length/count/wfx_get_block_align(wfx)*wfx_get_block_align(wfx);
			if (wfx_get_channels(wfx)==1) {
				if (wfx_get_bits_per_sample(wfx)==8)
					y0=y1=ABS(p[j]-128)*height/256;
				else
					y0=y1=ABS(*(gint16 *)(p+j))*height/65536;
			} else {
				if (wfx_get_bits_per_sample(wfx)==8) {
					y0=ABS(p[j]-128)*height/256;
					y1=ABS(p[j+1]-128)*height/256;
				} else {
					y0=ABS(*(gint16 *)(p+j))*height/65536;
					y1=ABS(*(gint16 *)(p+j+2))*height/65536;
				}
			}
			gdk_gc_set_foreground(gc,system_color+2);
			gdk_draw_line(widget->window,gc,
										x0+i,y+height/2-y0,x0+i,y+height/2+y1);
		}
		/*  */
		gdk_gc_set_foreground(gc,system_color);
		gdk_draw_line(widget->window,gc,x0,y+height/2,x1,y+height/2);
	}
	g_free(p);
}


gboolean signal_expose(GtkWidget *widget,GdkEventExpose *event,
															VmaidWindow *vmaid)
{
	gint i,sx,max,frame,size;
	AviFrame *avi_frame;
	WaveFormatEx *wfx;
	GdkGC *gc;
	GdkRectangle rc0,rc1;

	gc=gdk_gc_new(widget->window);
	gdk_gc_set_line_attributes(gc,1,
								GDK_LINE_SOLID,GDK_CAP_BUTT,GDK_JOIN_MITER);
	gdk_gc_set_stipple(gc,bitmap0);
	for (i=0;i<4;i++)
		gdk_color_alloc(gdk_colormap_get_system(),system_color+i);
	gdk_gc_set_clip_rectangle(gc,&event->area);
	/* ե졼֤ط */
	if (system_font_height*2-event->area.y>0) {
		gdk_gc_set_foreground(gc,system_color+1);
		gdk_draw_rectangle(widget->window,gc,TRUE,event->area.x,event->area.y,
						event->area.width,system_font_height*2-event->area.y);
	}
	/* ե졼 */
	sx=MAX((widget->allocation.width-4)/vmaid->width-2,1);
	max=MIN(get_max_frame(vmaid,-1),vmaid->top+sx-1);
	frame=vmaid->select.stream>=0
		?vmaid->select.frame-(vmaid->cursor.frame<vmaid->select.frame?1:0):-1;
	gdk_gc_set_foreground(gc,system_color);
	if (frame>=0 && frame<vmaid->top)	/* 򳫻ϰ֤ΤȤ */
		signal_expose_text(widget,gc,vmaid,frame,0,0);
	for (i=vmaid->top,rc0.x=vmaid->width+2;i<=max;i++,rc0.x+=vmaid->width)
		signal_expose_text(widget,gc,vmaid,i,rc0.x,0);
	if (vmaid->top+sx<=frame)			/* 򳫻ϰ֤ΤȤ */
		signal_expose_text(widget,gc,vmaid,frame,vmaid->width*(sx+1)+4,0);
	rc0.y=system_font_height*2;
	rc0.height=vmaid->height;
	if (vmaid->avi_edit[0]!=NULL) {
		avi_frame=avi_get_frame_open(vmaid->avi_edit[0]);
		max=MIN(get_max_frame(vmaid,0),vmaid->top+sx-1);
		rc0.x=0;
		if (frame>=0 && frame<vmaid->top) {
			/* 򳫻ϰ֤ΤȤ */
			rc0.width=vmaid->width;
			if (gdk_rectangle_intersect(&event->area,&rc0,&rc1)) {
				signal_expose_bitmap(widget,gc,avi_frame,frame,
											rc0.x,rc0.y,rc0.width,rc0.height);
			}
			rc0.x=vmaid->width;
			rc0.width=2;
		} else {
			rc0.width=vmaid->width+2;
		}
		if (gdk_rectangle_intersect(&event->area,&rc0,&rc1)) {
			gdk_gc_set_foreground(gc,system_color+1);
			gdk_draw_rectangle(widget->window,gc,TRUE,rc1.x,rc1.y,
														rc1.width,rc1.height);
		}
		rc0.width=vmaid->width;
		for (i=vmaid->top,rc0.x=vmaid->width+2;i<=max;i++,rc0.x+=vmaid->width)
			if (gdk_rectangle_intersect(&event->area,&rc0,&rc1))
				signal_expose_bitmap(widget,gc,avi_frame,i,
											rc0.x,rc0.y,rc0.width,rc0.height);
		rc0.width=vmaid->width*(sx+1)+4-rc0.x;
		if (gdk_rectangle_intersect(&event->area,&rc0,&rc1)) {
			gdk_gc_set_foreground(gc,system_color+1);
			gdk_draw_rectangle(widget->window,gc,TRUE,rc1.x,rc1.y,
														rc1.width,rc1.height);
		}
		rc0.x=vmaid->width*(sx+1)+4;
		rc0.width=vmaid->width;
		if (vmaid->top+sx<=frame
						&& gdk_rectangle_intersect(&event->area,&rc0,&rc1)) {
			/* 򳫻ϰ֤ΤȤ */
			signal_expose_bitmap(widget,gc,avi_frame,frame,
										rc0.x,rc0.y,vmaid->width,rc0.height);
			rc0.x+=vmaid->width;
		}
		rc0.width=widget->allocation.width-rc0.x;
		if (gdk_rectangle_intersect(&event->area,&rc0,&rc1)) {
			gdk_gc_set_foreground(gc,system_color+1);
			gdk_draw_rectangle(widget->window,gc,TRUE,
											rc1.x,rc1.y,rc1.width,rc1.height);
		}
		rc0.y+=vmaid->height;
		avi_get_frame_close(avi_frame);
	}
	if (vmaid->avi_edit[1]!=NULL) {
		/* ط */
		rc0.x=event->area.x;
		rc0.width=event->area.width;
		if (gdk_rectangle_intersect(&event->area,&rc0,&rc1)) {
			gdk_gc_set_foreground(gc,system_color+1);
			gdk_draw_rectangle(widget->window,gc,TRUE,
											rc1.x,rc1.y,rc1.width,rc1.height);
		}
		size=avi_format_size(vmaid->avi_edit[1]);
		wfx=g_malloc(size);
		avi_read_format(vmaid->avi_edit[1],wfx);
		if (wfx_get_format_tag(wfx)!=WAVE_FORMAT_PCM
				|| (wfx_get_channels(wfx)!=1 && wfx_get_channels(wfx)!=2)
				|| (wfx_get_bits_per_sample(wfx)!=8
										&& wfx_get_bits_per_sample(wfx)!=16)
				|| wfx_get_block_align(wfx)*8
						!=wfx_get_channels(wfx)*wfx_get_bits_per_sample(wfx)) {
			g_free(wfx);
			wfx=NULL;
		}
		max=MIN(get_max_frame(vmaid,1),vmaid->top+sx-1);
		rc0.x=0;
		rc0.width=vmaid->width;
		if (frame>=0 && frame<vmaid->top
							&& gdk_rectangle_intersect(&event->area,&rc0,&rc1))
			/* 򳫻ϰ֤ΤȤ */
			signal_expose_wave(widget,gc,vmaid->avi_edit[1],wfx,
						(gint)(gint64)frame*vmaid->scale*1000/vmaid->rate,
						(gint)(gint64)(frame+1)*vmaid->scale*1000/vmaid->rate,
											rc0.x,rc0.y,rc0.width,rc0.height);
		for (i=vmaid->top,rc0.x=vmaid->width+2;i<=max;i++,rc0.x+=vmaid->width)
			if (gdk_rectangle_intersect(&event->area,&rc0,&rc1))
				signal_expose_wave(widget,gc,vmaid->avi_edit[1],wfx,
							(gint)(gint64)i*vmaid->scale*1000/vmaid->rate,
							(gint)(gint64)(i+1)*vmaid->scale*1000/vmaid->rate,
											rc0.x,rc0.y,rc0.width,rc0.height);
		rc0.x=vmaid->width*(sx+1)+4;
		if (vmaid->top+sx<=frame
							&& gdk_rectangle_intersect(&event->area,&rc0,&rc1))
			/* 򳫻ϰ֤ΤȤ */
			signal_expose_wave(widget,gc,vmaid->avi_edit[1],wfx,
						(gint)(gint64)frame*vmaid->scale*1000/vmaid->rate,
						(gint)(gint64)(frame+1)*vmaid->scale*1000/vmaid->rate,
											rc0.x,rc0.y,rc0.width,rc0.height);
		g_free(wfx);
	}
	/* ϰ */
	if (vmaid->select.stream>=0) {
		/* ϰϤȤ */
		rc0.x=MAX(vmaid->top,MIN(vmaid->cursor.frame,vmaid->select.frame));
		rc0.width=MIN(vmaid->top+sx,
							MAX(vmaid->cursor.frame,vmaid->select.frame))-1;
		if (rc0.x<=rc0.width) {
			rc0.width=(rc0.width-rc0.x+1)*vmaid->width;
			rc0.x=(rc0.x-vmaid->top+1)*vmaid->width+2;
			rc0.y=MIN(vmaid->cursor.stream,vmaid->select.stream);
			rc0.height=MAX(vmaid->cursor.stream,vmaid->select.stream)-rc0.y+1;
			if (vmaid->avi_edit[0]==NULL)
				rc0.y--;
			rc0.y=rc0.y*vmaid->height+system_font_height*2;
			rc0.height*=vmaid->height;
			if (gdk_rectangle_intersect(&event->area,&rc0,&rc1)) {
				gdk_gc_set_foreground(gc,system_color+3);
				gdk_gc_set_fill(gc,GDK_STIPPLED);
				gdk_gc_set_stipple(gc,bitmap1);
				gdk_draw_rectangle(widget->window,gc,TRUE,
											rc1.x,rc1.y,rc1.width,rc1.height);
				gdk_gc_set_fill(gc,GDK_SOLID);
			}
		}
	}
	/* åȤ */
	if (caret && GTK_WIDGET_HAS_FOCUS(widget)
									&& vmaid->top<=vmaid->cursor.frame
									&& vmaid->cursor.frame<=vmaid->top+sx) {
		rc0.x=(vmaid->cursor.frame-vmaid->top+1)*vmaid->width+1;
		rc0.y=system_font_height*2
						+(vmaid->avi_edit[0]!=NULL && vmaid->cursor.stream>0
															?vmaid->height:0);
		rc0.width=2;
		rc0.height=vmaid->height;
		if (gdk_rectangle_intersect(&event->area,&rc0,&rc1)) {
			gdk_gc_set_function(gc,GDK_INVERT);
			gdk_draw_rectangle(widget->window,gc,TRUE,
											rc1.x,rc1.y,rc1.width,rc1.height);
		}
	}
	gdk_gc_destroy(gc);
	return TRUE;
}


gboolean signal_button_press_draw(GtkWidget *widget,GdkEventButton *event,
															VmaidWindow *vmaid)
{
	if (!GTK_WIDGET_HAS_FOCUS(widget))
		gtk_widget_grab_focus(widget);
	switch (event->type) {
	case GDK_BUTTON_PRESS:
		switch (event->button) {
		case 1:/* å */
			{
				gboolean shift;
				gint max,sx;
				VmaidCursor cursor,select;

				if (vmaid->avi_edit[0]==NULL && vmaid->avi_edit[1]==NULL)
					break;
				cursor=vmaid->cursor;
				select=vmaid->select;
				shift=(event->state&GDK_SHIFT_MASK)!=0;
				max=get_max_frame(vmaid,-1)+1;
				sx=MAX((widget->allocation.width-4)/vmaid->width-2,1);
				/* å֤˥åȤư */
				vmaid->cursor.frame
							=vmaid->top+(event->x-vmaid->width-2)/vmaid->width;
				if (vmaid->cursor.frame<vmaid->top)
					vmaid->cursor.frame=vmaid->top;
				else if (vmaid->top+sx<vmaid->cursor.frame)
					vmaid->cursor.frame=vmaid->top+sx;
				if (vmaid->cursor.frame>max)
					vmaid->cursor.frame=max;
				if (vmaid->avi_edit[0]!=NULL && vmaid->avi_edit[1]!=NULL)
					vmaid->cursor.stream
							=event->y<system_font_height*2+vmaid->height?0:1;
				if (vmaid->select.stream>=0 && (!shift
								|| vmaid->cursor.frame==vmaid->select.frame))
					vmaid->select.stream=-1;/*  */
				else if (vmaid->select.stream<0
								&& shift && vmaid->cursor.frame!=cursor.frame)
					vmaid->select=cursor;/*  */
				if (vmaid->cursor.stream==cursor.stream
										&& vmaid->cursor.frame==cursor.frame
										&& vmaid->select.stream==select.stream
										&& vmaid->select.frame==select.frame)
					break;/* Ѳʤ */
				/* ˥塼 */
				if (vmaid->select.stream!=select.stream)
					set_menu_bar(vmaid);
				clear_sel(vmaid,&cursor,&select,vmaid->top);
				draw_caret(vmaid,&cursor);
			}
			break;
		case 2:/* 楯å */
			break;
		case 3:/* å */
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,"<main>/Undo"),vmaid->undo!=NULL);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,"<main>/Cut"),vmaid->select.stream>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,"<main>/Copy"),vmaid->select.stream>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,"<main>/Delete"),vmaid->select.stream>=0);
			gtk_menu_popup(GTK_MENU(
					gtk_item_factory_get_widget(item_factory_popup,"<main>")),
								NULL,NULL,NULL,NULL,event->button,event->time);
			break;
		case 4:/* ۥ */
		case 5:
			{
				gint max,sx,top;

				top=vmaid->top;
				sx=MAX((widget->allocation.width-4)/vmaid->width-2,1);
				max=get_max_frame(vmaid,-1)+1;
				vmaid->top+=event->button==4?-4:4;
				if (vmaid->top<0)
					vmaid->top=0;
				else if (vmaid->top>max-sx)
					vmaid->top=MAX(max-sx,0);
				if (vmaid->top!=top)
					misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
													vmaid,0,max,sx,vmaid->top);
				clear_sel(vmaid,&vmaid->cursor,&vmaid->select,top);
			}
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


/*	ޥΰư˴ؤ
	  ptw,ƥȾ
	    x,Xɸ
	    y,Yɸ
	state,ơ
	  RET,TRUE:뤢,FALSE:ʤ							*/
static gboolean signal_motion_notify_draw(VmaidWindow *vmaid,gint x,gint y,
														GdkModifierType state)
{
	gint max,sx,top;
	VmaidCursor cursor,select;
	GdkPoint ps;

	cursor=vmaid->cursor;
	select=vmaid->select;
	top=vmaid->top;
	sx=MAX((vmaid->drawing->allocation.width-4)/vmaid->width-2,1);
	max=get_max_frame(vmaid,-1)+1;
	ps.x=x;
	ps.y=y;
	if (ps.x<vmaid->width+2)
		ps.x=vmaid->width+2;
	else if (ps.x>(sx+1)*vmaid->width+2)
		ps.x=(sx+1)*vmaid->width+2;
	/* 뤬ˤȤ뤹 */
	if (x<vmaid->width+2 && vmaid->top>0)
		vmaid->top--;
	else if (x>(sx+1)*vmaid->width+2 && vmaid->top<max-sx)
		vmaid->top++;
	/* ΰ֤˥åȤư */
	vmaid->cursor.frame=vmaid->top+(ps.x-vmaid->width-2)/vmaid->width;
	if (vmaid->cursor.frame<0)
		vmaid->cursor.frame=0;
	else if (vmaid->cursor.frame>max)
		vmaid->cursor.frame=max;
	if (vmaid->avi_edit[0]!=NULL && vmaid->avi_edit[1]!=NULL)
		vmaid->cursor.stream=ps.y<system_font_height*2+vmaid->height?0:1;
	if (vmaid->cursor.frame==cursor.frame
										&& vmaid->cursor.stream==cursor.stream)
		return FALSE;/* Ѳʤ */
	if (vmaid->select.stream>=0 && vmaid->cursor.frame==vmaid->select.frame)
		vmaid->select.stream=-1;/*  */
	else if (vmaid->select.stream<0 && vmaid->cursor.frame!=cursor.frame)
		vmaid->select=cursor;/*  */
	/* ˥塼 */
	if (vmaid->select.stream!=select.stream)
		set_menu_bar(vmaid);
	if (vmaid->top!=top)
		misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
													vmaid,0,max,sx,vmaid->top);
	clear_sel(vmaid,&cursor,&select,top);
	draw_caret(vmaid,&cursor);
	return vmaid->top!=top;
}


static gboolean signal_timeout_draw(VmaidWindow *vmaid)
{
	gboolean result;
	gint x,y;
	GdkModifierType state;

	gdk_window_get_pointer(vmaid->drawing->window,&x,&y,&state);
	if ((state&GDK_BUTTON1_MASK)!=0) {
		result=signal_motion_notify_draw(vmaid,x,y,state);
		if (!result) {
			/* 뤬ä饿ޤϺ */
			gtk_timeout_remove(vmaid->timer_id);
			vmaid->timer_id=0;
		}
	} else {
		result=FALSE;
	}
	return result;
}


gboolean signal_motion_notify(GtkWidget *widget,GdkEventMotion *event,
															VmaidWindow *vmaid)
{
	gint x,y;
	GdkModifierType state;

	if (event->is_hint) {
		gdk_window_get_pointer(event->window,&x,&y,&state);
	} else {
		x=event->x;
		y=event->y;
		state=event->state;
	}
	if ((state&GDK_BUTTON1_MASK)!=0
		&& signal_motion_notify_draw(vmaid,x,y,state) && vmaid->timer_id==0)
		/* Ϥƥ뤷Ȥ */
		vmaid->timer_id
					=gtk_timeout_add(1,(GtkFunction)signal_timeout_draw,vmaid);
	return TRUE;
}


gboolean signal_button_release(GtkWidget *widget,GdkEventButton *event,
															VmaidWindow *vmaid)
{
	if (vmaid->timer_id!=0) {
		gtk_timeout_remove(vmaid->timer_id);
		vmaid->timer_id=0;
	}
	return TRUE;
}


gboolean signal_key_press(GtkWidget *widget,GdkEventKey *event,
															VmaidWindow *vmaid)
{
	gboolean result=FALSE;/* TRUE:λ,FALSE:³ */

	switch (event->keyval) {
	case GDK_J:
	case GDK_K:
	case GDK_j:
	case GDK_k:
		if ((event->state&GDK_MOD1_MASK)==0)
			break;
	case GDK_Up:
	case GDK_Down:
		result=TRUE;
		{
			gint sx,max,top;
			VmaidCursor cursor,select;

			if (vmaid->avi_edit[0]==NULL || vmaid->avi_edit[1]==NULL)
				break;
			cursor=vmaid->cursor;
			select=vmaid->select;
			top=vmaid->top;
			max=get_max_frame(vmaid,-1)+1;
			sx=MAX((widget->allocation.width-4)/vmaid->width-2,1);
			vmaid->cursor.stream=vmaid->cursor.stream==0?1:0;
			/* åȤɽ褦Ĵ */
			if (vmaid->top>vmaid->cursor.frame)
				vmaid->top=vmaid->cursor.frame;
			else if (vmaid->top<vmaid->cursor.frame-sx)
				vmaid->top=MAX(vmaid->cursor.frame-sx,0);
			if (vmaid->select.stream>=0 && (event->state&GDK_SHIFT_MASK)==0) {
				vmaid->select.stream=-1;/*  */
				set_menu_bar(vmaid);/* ˥塼 */
			}
			if (vmaid->top!=top)
				misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
													vmaid,0,max,sx,vmaid->top);
			clear_sel(vmaid,&cursor,&select,top);
			draw_caret(vmaid,&cursor);
		}
		break;
	case GDK_Home:
	case GDK_Left:
	case GDK_Right:
	case GDK_Page_Up:
	case GDK_Page_Down:
	case GDK_End:
	case GDK_comma:
	case GDK_period:
	case GDK_less:
	case GDK_greater:
	case GDK_H:
	case GDK_L:
	case GDK_h:
	case GDK_l:
		result=TRUE;
		{
			gboolean alt,ctrl;
			gint sx,max,top;
			VmaidCursor cursor,select;

			if (vmaid->avi_edit[0]==NULL && vmaid->avi_edit[1]==NULL)
				break;
			cursor=vmaid->cursor;
			select=vmaid->select;
			top=vmaid->top;
			max=get_max_frame(vmaid,-1)+1;
			sx=MAX((widget->allocation.width-4)/vmaid->width-2,1);
			alt=(event->state&GDK_MOD1_MASK)!=0;
			ctrl=(event->state&GDK_CONTROL_MASK)!=0;
			switch (event->keyval) {
			case GDK_Home:
				vmaid->cursor.frame=0;
				break;
			case GDK_End:
				vmaid->cursor.frame
								=get_max_frame(vmaid,vmaid->cursor.stream)+1;
				break;
			case GDK_H:
			case GDK_h:
				if (!alt)
					goto loop;
			case GDK_Left:
				if (!ctrl) {
					vmaid->cursor.frame--;
				} else if (vmaid->top>0) {
					vmaid->top--;
					if (vmaid->cursor.frame-sx>vmaid->top)
						vmaid->cursor.frame--;
				}
				break;
			case GDK_L:
			case GDK_l:
				if (!alt)
					goto loop;
			case GDK_Right:
				if (!ctrl) {
					vmaid->cursor.frame++;
				} else if (vmaid->top<max-sx) {
					vmaid->top++;
					if (vmaid->cursor.frame<vmaid->top)
						vmaid->cursor.frame++;
				}
				break;
			case GDK_Page_Up:
				if (ctrl) {
					vmaid->cursor.frame=vmaid->top;
				} else {
					vmaid->cursor.frame-=sx;
					vmaid->top-=sx;
				}
				break;
			case GDK_Page_Down:
				if (ctrl) {
					vmaid->cursor.frame=vmaid->top+sx;
				} else {
					vmaid->cursor.frame+=sx;
					vmaid->top+=sx;
				}
			}
			if (vmaid->cursor.frame<0)
				vmaid->cursor.frame=0;
			else if (vmaid->cursor.frame>max)
				vmaid->cursor.frame=max;
			/* åȤɽ褦Ĵ */
			if (vmaid->top>vmaid->cursor.frame)
				vmaid->top=vmaid->cursor.frame;
			else if (vmaid->top<vmaid->cursor.frame-sx)
				vmaid->top=MAX(vmaid->cursor.frame-sx,0);
			if (vmaid->cursor.frame==cursor.frame && vmaid->top==top)
				break;/* Ѳʤ */
			if ((event->state&GDK_SHIFT_MASK)==0) {
				vmaid->select.stream=-1;
			} else {
				if (vmaid->select.stream<0)
					vmaid->select=cursor;/*  */
				if (vmaid->cursor.frame==vmaid->select.frame)
					vmaid->select.stream=-1;/*  */
			}
			/* ˥塼 */
			if ((vmaid->select.stream<0 && select.stream>=0)
							|| (vmaid->select.stream>=0 && select.stream<0))
				set_menu_bar(vmaid);
			if (vmaid->top!=top)
				misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
													vmaid,0,max,sx,vmaid->top);
			clear_sel(vmaid,&cursor,&select,top);
			draw_caret(vmaid,&cursor);
		}
		break;
	case GDK_Escape:
	case GDK_Cancel:
		result=TRUE;
		{
			gint sx,top;
			VmaidCursor cursor,select;

			if (vmaid->select.stream<0)
				break;
			cursor=vmaid->cursor;
			select=vmaid->select;
			top=vmaid->top;
			sx=MAX((widget->allocation.width-4)/vmaid->width-2,1);
			/* åȤɽ褦Ĵ */
			if (vmaid->top>vmaid->cursor.frame)
				vmaid->top=vmaid->cursor.frame;
			else if (vmaid->top<vmaid->cursor.frame-sx)
				vmaid->top=MAX(vmaid->cursor.frame-sx,0);
			vmaid->select.stream=-1;/*  */
			/* ˥塼 */
			set_menu_bar(vmaid);
			if (vmaid->top!=top)
				misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
							vmaid,0,get_max_frame(vmaid,-1)+1,sx,vmaid->top);
			clear_sel(vmaid,&cursor,&select,top);
			draw_caret(vmaid,&cursor);
		}
		break;
	case GDK_BackSpace:
	case GDK_Delete:
	case GDK_KP_Delete:
	case GDK_3270_DeleteWord:
		result=TRUE;
		{
			gboolean ctrl;
			gint max;

			if (vmaid->avi_edit[0]==NULL && vmaid->avi_edit[1]==NULL)
				break;
			ctrl=(event->state&GDK_CONTROL_MASK)!=0;
			if (vmaid->select.stream<0) {
				if (event->keyval==GDK_BackSpace) {
					if (vmaid->cursor.frame<=0)
						break;
					vmaid->select.frame=ctrl?0:vmaid->cursor.frame-1;
				} else {
					max=get_max_frame(vmaid,vmaid->cursor.stream)+1;
					if (vmaid->cursor.frame>=max)
						break;
					vmaid->select.frame=ctrl?max:vmaid->cursor.frame+1;
				}
				vmaid->select.stream=vmaid->cursor.stream;
			}
			command_delete(NULL,0,widget);
		}
		break;
	case GDK_F10:
		{
			gint sx,top;

			if ((event->state&GDK_SHIFT_MASK)==0)
				break;
			top=vmaid->top;
			sx=MAX((widget->allocation.width-4)/vmaid->width-2,1);
			/* åȤɽ褦Ĵ */
			if (vmaid->top>vmaid->cursor.frame)
				vmaid->top=vmaid->cursor.frame;
			else if (vmaid->top<vmaid->cursor.frame-sx)
				vmaid->top=MAX(vmaid->cursor.frame-sx,0);
			if (vmaid->top!=top)
				misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
							vmaid,0,get_max_frame(vmaid,-1)+1,sx,vmaid->top);
			clear_sel(vmaid,&vmaid->cursor,&vmaid->select,top);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,"<main>/Undo"),vmaid->undo!=NULL);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,"<main>/Cut"),vmaid->select.stream>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,"<main>/Copy"),vmaid->select.stream>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
				item_factory_popup,"<main>/Delete"),vmaid->select.stream>=0);
			gtk_menu_popup(GTK_MENU(
					gtk_item_factory_get_widget(item_factory_popup,"<main>")),
											NULL,NULL,NULL,NULL,3,event->time);
		}
		result=TRUE;
		break;
	case GDK_Tab:
	case GDK_KP_Tab:
		result=TRUE;
		{
			gint page;
			guint length;
			GList *glist;

			glist=gtk_container_children(GTK_CONTAINER(notebook));
			length=g_list_length(glist);
			g_list_free(glist);
			page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
			if ((event->state&GDK_SHIFT_MASK)==0) {
				if (++page>=length)
					page=0;
			} else {
				if (--page<0)
					page=length-1;
			}
			gtk_notebook_set_page(GTK_NOTEBOOK(notebook),page);
			gtk_widget_grab_focus(((VmaidWindow *)
				gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page))))->
																	drawing);
		}
	}
	loop:
	return result;
}


void signal_destroy_draw(GtkWidget *widget,VmaidWindow *vmaid)
{
	gint i;
	GList *glist;
	GtkWidget *sub_menu;

	/* ե̾Ĵ٤ */
	file_delete_edit(vmaid->file);
	/* ɥ˥塼 */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,"<main>/Window");
	gtk_container_remove(GTK_CONTAINER(sub_menu),vmaid->menu_item);
	/* ˥塼 */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	if (g_list_length(glist)<=1) {
		set_menu_bar(NULL);
		gtk_statusbar_pop(GTK_STATUSBAR(status),
				gtk_statusbar_get_context_id(GTK_STATUSBAR(status),"Status"));
	}
	g_list_free(glist);
	/*  */
	g_free(vmaid->file);
	if (vmaid->timer_id!=0) {
		gtk_timeout_remove(vmaid->timer_id);
		vmaid->timer_id=0;
	}
	for (i=0;i<2;i++)
		if (vmaid->avi_edit[i]!=NULL)
			avi_release(vmaid->avi_edit[i]);
	delete_list(&vmaid->undo);
	delete_list(&vmaid->redo);
	g_free(vmaid);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ƥ)                                           *
*                                                                             *
******************************************************************************/
void signal_style_set(GtkWidget *widget,GtkStyle *style,gpointer user_data)
{
	gint i,ascent,height;
	GList *glist;
	VmaidWindow *vmaid;

	/* ƥ࿧ */
	style=gtk_widget_get_style(widget);
	system_color[0]=style->text[0];
	system_color[1]=style->base[0];
	system_color[2]=style->fg[3];
	system_color[3]=style->bg[3];
	if (system_font!=NULL)
		gdk_font_unref(system_font);
	/* ƥե */
	system_font=gdk_font_ref(gtk_style_get_font(style));
	for (i=0;i<256;i++) {
		gdk_text_extents(system_font,(gchar *)&i,1,
												NULL,NULL,NULL,&ascent,NULL);
		if (system_font_ascent<ascent)
			system_font_ascent=ascent;
		height=gdk_char_height(system_font,(gchar)i);
		if (system_font_height<height)
			system_font_height=height;
	}
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	for (i=g_list_length(glist)-1;i>=0;i--) {
		vmaid=gtk_object_get_user_data(GTK_OBJECT(g_list_nth_data(glist,i)));
		gtk_widget_set_usize(vmaid->drawing,vmaid->width*3+4,
						system_font_height*2+((vmaid->avi_edit[0]!=NULL?1:0)
							+(vmaid->avi_edit[1]!=NULL?1:0))*vmaid->height);
#ifndef USE_GTK2
		gtk_container_queue_resize(GTK_CONTAINER(window));
#endif
		gtk_widget_draw(vmaid->drawing,NULL);
	}
	g_list_free(glist);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(˥塼)                                           *
*                                                                             *
******************************************************************************/
void signal_activate_menu_window(GtkWidget *widget,GtkWidget *child)
{
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),child));
	gtk_widget_grab_focus(
		((VmaidWindow *)gtk_object_get_user_data(GTK_OBJECT(child)))->drawing);
}


void signal_activate_menu_history(GtkWidget *widget,gchar *file)
{
#ifndef USE_GTK2
	pthread_t id;
#endif
	FileOpen *file_open;

	file_open=g_malloc(sizeof(FileOpen));
	file_open->file=g_strdup(file);
	file_open->merge=file_merge;
#ifdef USE_GTK2
	g_thread_create((GThreadFunc)file_open_edit,file_open,TRUE,NULL);
#else
	pthread_create(&id,NULL,(void *)file_open_edit,file_open);
	pthread_detach(id);
#endif
}


void signal_destroy_menu_history(GtkWidget *widget,gchar *file)
{
	g_free(file);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(Ρ)                                             *
*                                                                             *
******************************************************************************/
void signal_clicked(GtkWidget *widget,GtkWidget *child)
{
	if (prompt_close(
				(VmaidWindow *)gtk_object_get_user_data(GTK_OBJECT(child))))
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),child));
}


void signal_switch_page(GtkNotebook *notebook,GtkNotebookPage *page,
											gint page_num,gpointer user_data)
{
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(
					GTK_OBJECT(gtk_notebook_get_nth_page(notebook,page_num)));
	/* ˥塼ɽ */
	set_menu_bar(vmaid);
}


void signal_destroy_notebook(GtkWidget *widget,gpointer user_data)
{
	gtk_timeout_remove(timer_id);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ꥹ)                                             *
*                                                                             *
******************************************************************************/
void signal_select_row(GtkWidget *widget,gint row,gint column,
									GdkEventButton *event,gpointer user_data)
{
	gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
		gtk_item_factory_get_widget(item_factory_menu,"<main>/Task"))),TRUE);
}


void signal_unselect_row(GtkWidget *widget,gint row,gint column,
									GdkEventButton *event,gpointer user_data)
{
	gint i;

	for (i=0;i<GTK_CLIST(clist)->rows;i++)
		if (((GtkCListRow *)
					(g_list_nth(GTK_CLIST(clist)->row_list,i)->data))->state
														==GTK_STATE_SELECTED)
			break;
	if (i==GTK_CLIST(clist)->rows)
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
													"<main>/Task"))),FALSE);
}


gboolean signal_button_press_clist(GtkWidget *widget,GdkEventButton *event,
															gpointer user_data)
{
	gint row,column;

	if (event->type==GDK_BUTTON_PRESS && event->button==3
			&& gtk_clist_get_selection_info(GTK_CLIST(clist),
								(gint)event->x,(gint)event->y,&row,&column)) {
		/* å */
		gtk_clist_unselect_all(GTK_CLIST(clist));
		gtk_clist_select_row(GTK_CLIST(clist),row,column);
		gtk_menu_popup(GTK_MENU(
					gtk_item_factory_get_widget(item_factory_clist,"<main>")),
								NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
	return FALSE;
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(쥯)                                       *
*                                                                             *
******************************************************************************/
void signal_drag_data_received(GtkWidget *widget,GdkDragContext *context,
		gint x,gint y,GtkSelectionData *selection_data,guint info,guint time)
{
	gchar **files;
	gint i;
#ifndef USE_GTK2
	pthread_t id;
#endif
	FileOpen *file_open;

	files=g_strsplit(selection_data->data,"\r\n",G_MAXINT);
	for (i=0;files[i]!=NULL;i++)
		if (g_strncmp(files[i],"file:",5)==0) {
			file_open=g_malloc(sizeof(FileOpen));
			file_open->file=g_strdup(files[i]+5);
			file_open->merge=file_merge;
#ifdef USE_GTK2
			g_thread_create((GThreadFunc)file_open_edit,file_open,TRUE,NULL);
#else
			pthread_create(&id,NULL,(void *)file_open_edit,file_open);
			pthread_detach(id);
#endif
		}
	g_strfreev(files);
}


gboolean signal_selection_clear(GtkWidget *widget,GdkEventSelection *event,
															gpointer user_data)
{
	if (event->selection==atom_clipboard) {
		/* åץܡ */
		g_free(clipboard_scenario);
		clipboard_scenario=NULL;
	}
	return TRUE;
}


void signal_selection_get(GtkWidget *widget,GtkSelectionData *data,
									guint info,guint time,gpointer user_data)
{
	gchar *text;

	if (data->selection==atom_clipboard) {
		/* åץܡ */
		if (clipboard_scenario!=NULL && info==TARGET_VMAID)
			gtk_selection_data_set(data,atom_scenario,8,
					(guchar *)clipboard_scenario,g_strlen(clipboard_scenario));
	} else if (data->selection==atom_videomaid0) {
		/* ץ̿ */
		text="Video maid Selection";
		gtk_selection_data_set(data,GDK_SELECTION_TYPE_STRING,8,
												(guchar *)text,g_strlen(text));
		gtk_selection_convert(window,atom_videomaid1,
								GDK_SELECTION_TYPE_STRING,GDK_CURRENT_TIME);
	} else if (data->selection==atom_videomaid1 && arg_text!=NULL) {
		/* ץ̿ */
		gtk_selection_data_set(data,GDK_SELECTION_TYPE_STRING,8,
										(guchar *)arg_text,g_strlen(arg_text));
		g_free(arg_text);
		arg_text=NULL;
	}
}


void signal_selection_received(GtkWidget *widget,GtkSelectionData *data,
												guint time,gpointer user_data)
{
	gboolean result=TRUE,paste[2],*arg_files;
	gchar **argv;
	gint i,count,max,sx;
#ifndef USE_GTK2
	pthread_t id;
#endif
	AviEdit **avi_edit;
	FileOpen *file_open;
	GdkAtom *atoms;
	VmaidWindow *vmaid;
	VmaidHistory *d;

	if (data->selection==atom_clipboard) {
		/* åץܡ */
		if (data->length>=0) {
			if (data->type==GDK_SELECTION_TYPE_ATOM) {
				atoms=(GdkAtom *)data->data;
				count=data->length/sizeof(GdkAtom);
				for (i=0;i<count;i++)
					if (atoms[i]==atom_scenario)
						break;
				if (i<count)
					gtk_selection_convert(widget,data->selection,atoms[i],
															GDK_CURRENT_TIME);
			} else if (data->type==atom_scenario) {
				/* Žդ */
				if ((avi_edit=avi_from_scenario(data->data))==NULL)
					return;
				vmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
				if (vmaid->select.stream<0) {
					/* ϰϤʤȤUNDOν */
					d=g_malloc(sizeof(VmaidHistory));
					for (i=0;i<2;i++) {
						d->avi_edit[i]=NULL;
						if (vmaid->avi_edit[i]!=NULL
								&& (d->avi_edit[i]
										=avi_clone(vmaid->avi_edit[i]))==NULL)
							result=FALSE;
					}
					if (!result) {
						misc_message_box("Video maid",_("AVI Clone Error"),0,
																_("OK"),NULL);
						for (i=0;i<2;i++)
							if (d->avi_edit[i]!=NULL)
								avi_release(d->avi_edit[i]);
						g_free(d);
						for (i=0;avi_edit[i]!=NULL;i++)
							avi_release(avi_edit[i]);
						g_free(avi_edit);
						return;
					}
					d->cursor=vmaid->cursor;
					d->select=vmaid->select;
				} else {
					/* ϰϤФ */
					d=vmaid->redo;
					vmaid->redo=NULL;
					command_delete(NULL,0,widget);
					vmaid->redo=d;
				}
				paste[0]=paste[1]=FALSE;
				for (i=0;avi_edit[i]!=NULL;i++)
					switch (avi_type(avi_edit[i])) {
						case streamtypeVIDEO:
							if (paste[0]) {
								avi_release(avi_edit[i]);
							} else {
								if (vmaid->avi_edit[0]==NULL) {
									vmaid->avi_edit[0]=avi_edit[i];
								} else if (!avi_paste(vmaid->avi_edit[0],
										MIN(vmaid->cursor.frame,
											avi_length(vmaid->avi_edit[0])),
																avi_edit[i])) {
									avi_release(avi_edit[i]);
									result=FALSE;
								}
								paste[0]=TRUE;
							}
							break;
						case streamtypeAUDIO:
							if (paste[1]) {
								avi_release(avi_edit[i]);
							} else {
								if (vmaid->avi_edit[1]==NULL) {
									vmaid->avi_edit[1]=avi_edit[i];
								} else if (!avi_paste(vmaid->avi_edit[1],
									MIN(avi_time_to_sample(vmaid->avi_edit[1],
											(gint64)vmaid->cursor.frame*1000
													*vmaid->scale/vmaid->rate),
										avi_length(vmaid->avi_edit[0])),
																avi_edit[i])) {
									avi_release(avi_edit[i]);
									result=FALSE;
								}
								paste[1]=TRUE;
							}
							break;
						default:
							avi_release(avi_edit[i]);
							result=FALSE;
					}
				g_free(avi_edit);
				if (!result || (!paste[0] && !paste[1])) {
					misc_message_box("Video maid",_("AVI Paste Error"),0,
																_("OK"),NULL);
					for (i=0;i<2;i++)
						if (vmaid->avi_edit[i]!=NULL)
							avi_release(vmaid->avi_edit[i]);
					d=vmaid->undo;
					vmaid->undo=vmaid->undo->next;
					for (i=0;i<2;i++)
						vmaid->avi_edit[i]=d->avi_edit[i];
					g_free(d);
					return;
				}
				if (vmaid->avi_edit[0]!=NULL) {
					vmaid->rate=avi_get_rate(vmaid->avi_edit[0]);
					vmaid->scale=avi_get_scale(vmaid->avi_edit[0]);
				}
				max=get_max_frame(vmaid,-1)+1;
				sx=MAX((vmaid->drawing->allocation.width-4)/vmaid->width-2,1);
				if (vmaid->avi_edit[0]!=NULL && vmaid->avi_edit[1]==NULL)
					vmaid->cursor.stream=0;
				else if (vmaid->avi_edit[0]==NULL && vmaid->avi_edit[1]!=NULL)
					vmaid->cursor.stream=1;
				if (vmaid->cursor.frame>max)
					vmaid->cursor.frame=max;
				if (vmaid->top>vmaid->cursor.frame)
					vmaid->top=vmaid->cursor.frame;
				else if (vmaid->top<vmaid->cursor.frame-sx)
					vmaid->top=MAX(vmaid->cursor.frame-sx,0);
				/* ˥塼,ơȥ,ҥɥ */
				set_menu_bar(vmaid);
				gtk_widget_set_usize(vmaid->drawing,vmaid->width*3+4,
						system_font_height*2+((vmaid->avi_edit[0]!=NULL?1:0)
							+(vmaid->avi_edit[1]!=NULL?1:0))*vmaid->height);
#ifndef USE_GTK2
				gtk_container_queue_resize(GTK_CONTAINER(window));
#endif
				gtk_widget_draw(vmaid->drawing,NULL);
				draw_caret(vmaid,NULL);
				misc_set_scroll_bar(vmaid->hscroll,
								GTK_SIGNAL_FUNC(signal_value_changed_hscroll),
													vmaid,0,max,sx,vmaid->top);
				vmaid_change_edit (vmaid, TRUE);
			}
		}
	} else if (data->selection==atom_videomaid0) {
		/* ץ̿ */
		instance=MAX(data->length,0);
	} else if (data->selection==atom_videomaid1 && data->length>0) {
		/* ץ̿ */
		/* ޥɥ饤β */
		argv=g_strsplit(data->data,"\n",G_MAXINT);
		arg_files=arg_analyse(argv,FALSE);
		for (i=0;argv[i]!=NULL;i++)
			if (arg_files[i]) {
				file_open=g_malloc(sizeof(FileOpen));
				file_open->file=g_strdup(argv[i]);
				file_open->merge=file_merge;
#ifdef USE_GTK2
				g_thread_create((GThreadFunc)file_open_edit,
														file_open,TRUE,NULL);
#else
				pthread_create(&id,NULL,(void *)file_open_edit,file_open);
				pthread_detach(id);
#endif
			}
		g_free(arg_files);
		g_strfreev(argv);
	}
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ᥤ)                                             *
*                                                                             *
******************************************************************************/
gboolean signal_delete(GtkWidget *widget,GdkEvent *event,gpointer user_data)
{
	gint page;
#ifndef USE_GTK2
	pthread_t id;
#endif
	VmaidWindow *vmaid;

	while ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		vmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		if (!prompt_close(vmaid))
			return TRUE;
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),page);
	}
#ifdef USE_GTK2
	g_thread_create((GThreadFunc)close_program,NULL,TRUE,NULL);
#else
	pthread_create(&id,NULL,(void *)close_program,NULL);
	pthread_detach(id);
#endif
	return TRUE;
}


void signal_destroy_window(GtkWidget *widget,gpointer user_data)
{
	gint i;
	GList *glist;
	GtkWidget *sub_menu;

	g_memset(history_files,0,sizeof(gchar *)*10);
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,"<main>/File");
	glist=gtk_container_children(GTK_CONTAINER(sub_menu));
	for (i=0;i<(gint)g_list_length(glist)-MENUFILE-1;i++)
		history_files[i]=g_strdup(gtk_object_get_user_data(
							GTK_OBJECT(g_list_nth_data(glist,i+MENUFILE-1))));
	g_list_free(glist);
	gtk_main_quit();
}
