/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "version.h"
#include <gdk/gdkkeysyms.h>


/******************************************************************************
*                                                                             *
* Сؿ                                                        *
*                                                                             *
******************************************************************************/
/* ĥ꡼ */
static void version_dialog_tree_select_row(GtkCTree *ctree,
							GtkCTreeNode *node,gint column,GtkWidget *button)
{
	IcmObject *icm_object;

	icm_object=gtk_ctree_node_get_row_data(ctree,node);
	gtk_object_set_user_data(GTK_OBJECT(ctree),icm_object);
	gtk_widget_set_sensitive(button,icm_object!=NULL);
}


/* ĥ꡼ */
static void version_dialog_tree_unselect_row(GtkCTree *ctree,
							GtkCTreeNode *node,gint column,GtkWidget *button)
{
	gtk_object_set_user_data(GTK_OBJECT(ctree),NULL);
	gtk_widget_set_sensitive(button,FALSE);
}


/* ĥ꡼˴ */
static void version_dialog_destroy(GtkWidget *widget,gpointer user_data)
{
	gint i;
	GtkCTreeNode *node;
	IcmObject *icm_object;

	for (i=0;(node=gtk_ctree_node_nth(GTK_CTREE(widget),i))!=NULL;i++)
		if ((icm_object=gtk_ctree_node_get_row_data(GTK_CTREE(widget),
																node))!=NULL)
			icm_close(icm_object);
}


/* Aboutܥ󤬲줿 */
static void version_dialog_clicked(GtkWidget *widget,GtkWidget *ctree)
{
	icm_dialog_about(gtk_object_get_user_data(GTK_OBJECT(ctree)));
}


/* ESC줿 */
static gboolean version_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


void version_dialog(void)
{
	gchar *text[2];
	gint i,length;
	guint key;
	GList *glist;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkAccelGroup *accel;
	GtkCTreeNode *parent,*node;
	GtkWidget *dialog,*button0,*button1,*ctree,*scroll,*hbox,*vbox;
	IcmObject *icm_object;
	IcmInfo icm_info;
/* XPM */
static gchar *vmaid_xpm[] = {
"32 32 16 1",
" 	c None",
".	c #000000",
"+	c #800000",
"@	c #008000",
"#	c #808000",
"$	c #000080",
"%	c #800080",
"&	c #008080",
"*	c #808080",
"=	c #C0C0C0",
"-	c #FF0000",
";	c #00FF00",
">	c #FFFF00",
",	c #0000FF",
"'	c #FF00FF",
")	c #00FFFF",
"                                ",
"                                ",
"++++++++++++++++++++++++++++++++",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
"++++++++++++++++++++++++++++++++",
". . + . . . . . . . . . . .+. . ",
" . .+. . . . . ' . . . . . + . .",
". . + . . . . ''  . . . . .+. . ",
" . .+. . . . ''' . . . . . + . .",
". . + . . .  '''      . . .+. . ",
" . .+. . -  '''',,,,,, . . + . .",
". . + .  ---'''',,,,, . . .+. . ",
" . .+. .  ----'',,,) . . . + . .",
". . + . . -----',)))  . . .+. . ",
" . .+. . . --->;)))))  . . + . .",
". . + . .  ->>>;;)))) . . .+. . ",
" . .+. .  >>>>>;;;;))) . . + . .",
". . + .  >>>>>>;;;;  )  . .+. . ",
" . .+. .       ;;; .   . . + . .",
". . + . . . .  ;;;  . . . .+. . ",
" . .+. . . . . ;;  . . . . + . .",
". . + . . . .  ;  . . . . .+. . ",
" . .+. . . . .   . . . . . + . .",
"++++++++++++++++++++++++++++++++",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
"++++++++++++++++++++++++++++++++",
"                                ",
"                                "};

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),_("About Video maid"));
	gtk_window_set_default_size(GTK_WINDOW(dialog),320,240);
	gtk_signal_connect(GTK_OBJECT(dialog),"key-press-event",
							GTK_SIGNAL_FUNC(version_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(dialog),accel);
	/* ܥ */
	button0=gtk_button_new_with_label("");
	button1=gtk_button_new_with_label(_("OK"));
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button0)->child),
															_("_About..."));
	gtk_widget_add_accelerator(button0,"clicked",accel,key,GDK_MOD1_MASK,0);
	/* ĥ꡼ */
	text[0]=_("Name");
	text[1]=_("Attribute");
	ctree=gtk_ctree_new_with_titles(2,0,text);
	gtk_clist_column_titles_show(GTK_CLIST(ctree));
	gtk_clist_column_titles_passive(GTK_CLIST(ctree));
	text[0]=_("Video Compressor");
	text[1]="";
	parent=gtk_ctree_insert_node(GTK_CTREE(ctree),NULL,NULL,
									text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
	if ((glist=icm_get_handler_list())!=NULL) {
		length=g_list_length(glist);
		for (i=0;i<length;i++)
			if ((icm_object=icm_open((guint32)g_list_nth_data(glist,i),
													ICM_MODE_QUERY))!=NULL) {
				if (icm_get_info(icm_object,&icm_info)) {
					text[0]=icm_info.name;
					switch (icm_info.attribute) {
						case ICM_ATTR_NATIVE:
							text[1]=_("Video maid Native");
							break;
						case ICM_ATTR_WIN32:
							text[1]=_("Win32 Emulation");
							break;
						default:
							text[1]=_("Unknown");
					}
					node=gtk_ctree_insert_node(GTK_CTREE(ctree),parent,NULL,
										text,0,NULL,NULL,NULL,NULL,TRUE,FALSE);
					g_free(icm_info.name);
					if (icm_is_dialog_about(icm_object))
						gtk_ctree_node_set_row_data(GTK_CTREE(ctree),node,
																icm_object);
					else
						icm_close(icm_object);
				} else {
					icm_close(icm_object);
				}
			}
		g_list_free(glist);
	}
	gtk_clist_columns_autosize(GTK_CLIST(ctree));
	gtk_signal_connect(GTK_OBJECT(ctree),"tree-select-row",
					GTK_SIGNAL_FUNC(version_dialog_tree_select_row),button0);
	gtk_signal_connect(GTK_OBJECT(ctree),"tree-unselect-row",
					GTK_SIGNAL_FUNC(version_dialog_tree_unselect_row),button0);
	gtk_signal_connect(GTK_OBJECT(ctree),"destroy",
								GTK_SIGNAL_FUNC(version_dialog_destroy),NULL);
	gtk_object_set_user_data(GTK_OBJECT(ctree),NULL);
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(scroll),ctree);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
									GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	/* ܥ */
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
								GTK_SIGNAL_FUNC(version_dialog_clicked),ctree);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
					GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(dialog));
	gtk_widget_set_sensitive(button0,FALSE);
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ԥޥå */
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&mask,NULL,vmaid_xpm);

	/* ե졼ȥܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	hbox=gtk_hbox_new(FALSE,8);
#ifdef USE_GTK2
	gtk_box_pack_start (GTK_BOX (hbox),
					gtk_image_new_from_pixmap (pixmap, mask), FALSE, FALSE, 0);
#else /* not USE_GTK2 */
	gtk_box_pack_start (GTK_BOX (hbox),
							gtk_pixmap_new (pixmap, mask), FALSE, FALSE, 0);
#endif /* not USE_GTK2 */
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new("Video maid version "VERSION
				"\ncopyright (c) 1998-2002 by Kazuki IWAMOTO"),TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_grab_focus(button1);

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();
}
