/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __GDI32_H__
#define __GDI32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef LPVOID HGDIOBJ;
typedef DWORD COLORREF, *PCOLORREF, *LPCOLORREF;
#include <pshpack1.h>
typedef struct tagPALETTEENTRY
{
  BYTE peRed;
  BYTE peGreen;
  BYTE peBlue;
  BYTE peFlags;
} PALETTEENTRY, *PPALETTEENTRY, *LPPALETTEENTRY;


extern W32LdrExport gdi32_exports[];


BOOL WINAPI BitBlt (HDC hdcDest, INT nXDest, INT nYDest, INT nWidth, INT nHeight, HDC hdcSrc, INT nXSrc, INT nYSrc, DWORD dwRop);
HDC WINAPI CreateCompatibleDC (HDC hdc);
BOOL WINAPI DeleteDC (HDC hdc);
BOOL WINAPI DeleteObject (HGDIOBJ hObject);
INT WINAPI GetDeviceCaps (HDC hdc, INT nIndex);
COLORREF WINAPI GetNearestColor (HDC hdc, COLORREF crColor);
INT WINAPI GetObjectA (HGDIOBJ hgdiobj, INT cbBuffer, LPVOID lpvObject);
INT WINAPI GetObjectW (HGDIOBJ hgdiobj, INT cbBuffer, LPVOID lpvObject);
UINT WINAPI GetSystemPaletteEntries (HDC hdc, UINT iStartIndex, UINT nEntries, LPPALETTEENTRY lppe);
HGDIOBJ WINAPI SelectObject (HDC hdc, HGDIOBJ hgdiobj);


#ifdef UNICODE
# define GetObject GetObjectW
#else /* not UNICODE*/
# define GetObject GetObjectA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GDI32_H__ */
