#!/usr/bin/perl
#
#   w32loader
#   copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

foreach (<STDIN>) {
  chomp;
  if (not $macro and /^#include "(\w+)\.h"$/) {
    $export="$1_exports";
    $macro="__$1_H__";
    $macro=~tr/a-z/A-Z/;
  } elsif (/#ifdef\s+W32LDR_HEADER/) {
    $header=1;
  } elsif (/#endif\s*\/\*\s+W32LDR_HEADER\s+\*\/$/) {
    $header=0;
  } elsif ($header) {
    $head.="$_\n";
  } elsif (/^\s*\/\*\s+(\w+)\s+ordinal\s*=\s*\d+,\s*argument\s*=\s*\d+\s+\*\/\s*$/) {
    $name=$1;
  } elsif ($name) {
    if (not /^\s*static\s+/) {
      $func[$n_func]{name}=$name;
      $func[$n_func]{proc}=$_;
      $n_func++;
    }
    undef $name;
  }
}
print <<EOF;
/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm\@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef $macro
#define $macro


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


EOF
print "$head\n\n" if $head;
print "extern W32LdrExport $export\[\];\n";
print "\n\n" if $n_func;
for ($i=0;$i<$n_func;$i++) {
  for ($j=0;$j<$n_func;$j++) {
    if ("$func[$i]{name}A" eq $func[$j]{name}) {
      delete $func[$i]{name};
      last;
    }
  }
  if ($func[$i]{name}) {
    if ($func[$i]{proc}=~/^\s*\/\*.*?\*\/\s*$/) {
      print "$func[$i]{proc}\n";
    } else {
      print "$func[$i]{proc};\n";
    }
  }
  if ($func[$i]{name}=~/^(\w+)(A|W)$/) {
    for ($j=$i+1;$j<$n_func;$j++) {
      $define[$n_define++]=$1 if $2 eq 'A' and $func[$j]{name} eq "$1W" or $2 eq 'W' and $func[$j]{name} eq "$1A";
    }
  }
}
if ($n_define) {
  print "\n\n#ifdef UNICODE\n";
  for ($i=0;$i<$n_define;$i++) {
    print "# define $define[$i] $define[$i]W\n";
  }
  print "#else /* not UNICODE*/\n";
  for ($i=0;$i<$n_define;$i++) {
    print "# define $define[$i] $define[$i]A\n";
  }
  print "#endif /* not UNICODE */\n";
}
print <<EOF;


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* $macro */
EOF
